/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chunkrestoration.path;

import java.time.Duration;
import java.time.Instant;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.managers.chunkrestoration.path.ChunkSnapshotAnyPath;
import org.kingdoms.managers.chunkrestoration.path.ChunkSnapshotRangedTimedPath;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0086\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0012J\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/managers/chunkrestoration/path/ChunkSnapshotPath;", "", "location", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "type", "Lorg/kingdoms/constants/namespace/Namespace;", "<init>", "(Lorg/kingdoms/constants/land/location/SimpleChunkLocation;Lorg/kingdoms/constants/namespace/Namespace;)V", "getLocation", "()Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "getType", "()Lorg/kingdoms/constants/namespace/Namespace;", "hashCode", "", "equals", "", "other", "latestUntil", "Lorg/kingdoms/managers/chunkrestoration/path/ChunkSnapshotRangedTimedPath;", "time", "Ljava/time/Duration;", "latest", "oldest", "any", "Lorg/kingdoms/managers/chunkrestoration/path/ChunkSnapshotAnyPath;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nChunkSnapshotPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkSnapshotPath.kt\norg/kingdoms/managers/chunkrestoration/path/ChunkSnapshotPath\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public class ChunkSnapshotPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleChunkLocation location;
    @NotNull
    private final Namespace type;
    @JvmField
    @NotNull
    public static final Namespace TYPE_UNCLAIM;

    public ChunkSnapshotPath(@NotNull SimpleChunkLocation location, @NotNull Namespace type) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.location = location;
        this.type = type;
        if (!this.type.isKingdoms()) {
            boolean bl = false;
            String string = "The chunk snapshot type must be a Namespace.kingdoms()";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final SimpleChunkLocation getLocation() {
        return this.location;
    }

    @NotNull
    public final Namespace getType() {
        return this.type;
    }

    public final int hashCode() {
        return this.location.hashCode();
    }

    public final boolean equals(@Nullable Object other) {
        return Intrinsics.areEqual((Object)this.location, (Object)other);
    }

    @NotNull
    public final ChunkSnapshotRangedTimedPath latestUntil(@NotNull Duration time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return new ChunkSnapshotRangedTimedPath(this.location, this.type, null, Instant.now().minus(time));
    }

    @NotNull
    public final ChunkSnapshotRangedTimedPath latest() {
        return new ChunkSnapshotRangedTimedPath(this.location, this.type, null, null);
    }

    @NotNull
    public final ChunkSnapshotRangedTimedPath oldest() {
        return new ChunkSnapshotRangedTimedPath(this.location, this.type, Instant.EPOCH, null);
    }

    @NotNull
    public final ChunkSnapshotAnyPath any() {
        return new ChunkSnapshotAnyPath(this.location, this.type);
    }

    static {
        Namespace namespace = Namespace.kingdoms("UNCLAIM");
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"kingdoms(...)");
        TYPE_UNCLAIM = namespace;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0015\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/managers/chunkrestoration/path/ChunkSnapshotPath$Companion;", "", "<init>", "()V", "TYPE_UNCLAIM", "Lorg/kingdoms/constants/namespace/Namespace;", "Lorg/kingdoms/libs/jetbrains/annotations/NotNull;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

