/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chat;

import com.google.common.base.Strings;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.data.Pair;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.compiler.pieces.showitem.ChatShowItemTokenizer;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.managers.chat.ChatTagManager;
import org.kingdoms.managers.chat.KingdomChatChannelListener;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.debugging.KingdomsDebug;

public final class KingdomsChatProcessor {
    private static final String PARSE_AS_PLACEHOLDER = "{KINGDOMS}";
    private final Player sender;
    private final KingdomPlayer kp;
    private final KingdomsChatChannel chan;
    private final KLogger logger = new KLogger(KingdomsDebug.CHAT);
    private final AsyncPlayerChatEvent event;
    private final MessageObject adminFormat;
    private boolean bypassRanged;
    private boolean parseAsPlaceholder = false;
    private final MessagePlaceholderProvider settings = new MessagePlaceholderProvider();

    public KingdomsChatProcessor(AsyncPlayerChatEvent event) {
        this.event = event;
        this.sender = event.getPlayer();
        this.kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.sender);
        this.chan = this.kp.getChatChannel();
        boolean colorize = KingdomsDefaultPluginPermission.CHAT_COLORS.hasPermission((CommandSender)this.sender, true);
        PlaceholderTranslationContext msgCtx = new PlaceholderTranslationContext(event.getMessage(), new MessageCompilerSettings(false, !this.kp.isAdmin(), colorize, this.kp.isAdmin(), false, null).withTokenHandler(ChatTagManager.INSTANCE, ChatShowItemTokenizer.INSTANCE));
        MessageObjectBuilder messageObjectBuilder = this.chan.getName();
        this.settings.withContext(this.sender).raw("message", msgCtx).parse("channel", this.chan.getColor() + messageObjectBuilder.buildPlain(MessagePlaceholderProvider.DEFAULT)).raw("channel_id", this.chan.getId());
        String adminFormatString = this.chan.getAdminFormat().stream().filter(x -> x.getKey() == null || ConditionProcessor.process((ConditionalExpression)x.getKey(), this.settings)).map(Pair::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException("Missing else option for admin formats: " + this.chan.getId()));
        this.adminFormat = MessageCompiler.compile(adminFormatString);
    }

    public void process() {
        String prefix;
        this.logger.log(() -> "Player " + this.sender.getName() + " sent a message to '" + this.chan.getId() + "' channel: " + this.event.getMessage());
        this.logger.log(() -> "Chat recipients: " + this.event.getRecipients().stream().map(Player::getName).collect(Collectors.toList()));
        if (this.kp.getMutedChannels().contains(this.chan.getDataId())) {
            KingdomsLang.COMMAND_CHAT_MUTED_CHANNEL.sendError((CommandSender)this.sender, this.settings);
            this.logger.log("That channel was muted for the player.");
            this.event.setCancelled(true);
            return;
        }
        boolean isGlobal = this.chan.isGlobal();
        if (isGlobal && !KingdomsConfig.Chat.GLOBAL_CHANNEL_FORMAT.getManager().getBoolean()) {
            return;
        }
        if (KingdomsDefaultPluginPermission.CHAT_BYPASS_RANGED.hasPermission((CommandSender)this.sender) && !Strings.isNullOrEmpty((String)(prefix = this.chan.getBypassPrefix())) && this.event.getMessage().startsWith(prefix)) {
            this.event.setMessage(this.event.getMessage().substring(prefix.length()));
            this.settings.raw("distance", 0);
            this.logger.property((Object)"Range Bypassed", true);
            this.bypassRanged = true;
        }
        String internalFormat = KingdomChatChannelListener.escapeStringFormatter(this.adminFormat.buildPlain(this.settings));
        if (isGlobal) {
            if (KingdomsConfig.Chat.GLOBAL_CHANNEL_PARSE_AS_PLACEHOLDER.getManager().getBoolean()) {
                this.parseAsPlaceholder = true;
                KingdomChatChannelListener.setFormat(this.event, MessageHandler.replace(this.event.getFormat(), PARSE_AS_PLACEHOLDER, internalFormat));
                return;
            }
            KingdomChatChannelListener.setFormat(this.event, internalFormat);
            this.logger.log(() -> "Parsing the message as placeholder with format: " + this.event.getFormat());
        } else {
            KingdomChatChannelListener.setFormat(this.event, internalFormat);
        }
        if (KingdomsConfig.Chat.CANCEL.getManager().getBoolean()) {
            this.event.setCancelled(true);
            MessagePlaceholderProvider settings1 = this.settings.ignoreColors();
            String format = this.adminFormat.buildPlain(settings1);
            if (isGlobal) {
                ServiceHandler.sendGlobalMessage(this.sender, format);
            } else {
                ServiceHandler.logPrivateMessage(this.sender, format);
            }
            this.settings.dontIgnoreColors();
            this.adminFormat.getSimpleProvider().send((CommandSender)Bukkit.getConsoleSender(), this.settings);
        }
        this.logger.property((Object)"Cancelled", this.event.isCancelled());
        if (!KingdomsConfig.Chat.RECIPIENTS_RESPECT_OTHERS.getManager().getBoolean()) {
            this.event.getRecipients().clear();
            this.event.getRecipients().addAll(Bukkit.getOnlinePlayers());
        }
        Iterator iter = this.event.getRecipients().iterator();
        ConditionalExpression condition = this.chan.getRecipientCondition();
        while (iter.hasNext()) {
            boolean send;
            Player recipient = (Player)iter.next();
            this.changeSettings(recipient);
            KingdomPlayer recipientKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)recipient);
            if (recipientKp.getMutedChannels().contains(this.chan.getDataId())) {
                iter.remove();
                this.logger.log("Recipient " + recipient.getName() + " has this channel muted.");
                continue;
            }
            MessagePlaceholderProvider recipientSettings = this.settings.clone();
            recipientSettings.withContext(recipient).other(this.sender);
            boolean bl = send = condition == null || ConditionProcessor.process(condition, recipientSettings);
            if (send) {
                if (!this.event.isCancelled()) continue;
                MessageObject format = this.getFormatter(this.settings);
                format.getSimpleProvider().send((CommandSender)recipient, this.settings);
                continue;
            }
            this.logger.log(() -> {
                Kingdom kingdom = this.kp.getKingdom();
                String rel = kingdom == null ? "NEUTRAL" : kingdom.getRelationWith(recipientKp.getKingdom()).name();
                return "Not sending to: " + recipient.getName() + ", rel=" + rel;
            });
            iter.remove();
        }
        if (!this.parseAsPlaceholder && KingdomsConfig.Chat.RECIPIENTS_CLEAR_WHEN_DONE.getManager().getBoolean()) {
            this.event.getRecipients().clear();
        }
        this.logger.end();
    }

    private static double getDistance(Player one, Player two) {
        if (one.getWorld() != two.getWorld()) {
            return -1.0;
        }
        return LocationUtils.distanceSquared(one.getLocation(), two.getLocation());
    }

    public static List<Player> getSpies() {
        return Bukkit.getOnlinePlayers().stream().filter(x -> KingdomPlayer.getKingdomPlayer((OfflinePlayer)x).isSpy()).collect(Collectors.toList());
    }

    private void changeSettings(Player other) {
        this.settings.other(other);
        if (this.bypassRanged) {
            return;
        }
        this.settings.raw("distance", KingdomsChatProcessor.getDistance(this.sender, other));
    }

    public MessageObject getFormatter(MessagePlaceholderProvider settings) {
        return this.chan.getFormats().get(settings);
    }
}

