/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.turrets;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.objects.InfernoTurret;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.constants.land.turrets.types.TurretTypeRanged;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.xseries.XEntityType;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.main.KLogger;
import org.kingdoms.managers.buildings.structures.RegulatorManager;
import org.kingdoms.managers.buildings.turrets.TurretFactory;
import org.kingdoms.managers.buildings.turrets.TurretIterationTaskHandler;
import org.kingdoms.managers.buildings.turrets.TurretStateCache;
import org.kingdoms.managers.buildings.turrets.TurretTask;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomEntity;
import org.kingdoms.managers.entity.types.KingdomLandEntity;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.services.pets.PetInfo;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cache.single.TickedCache;
import org.kingdoms.utils.internal.arrays.UnsafeArrayList;

@ApiStatus.Internal
public class TurretTurretTaskHandler
extends TurretIterationTaskHandler.TurretLandTaskHandler {
    private final TurretIterationTaskHandler.TurretLandTaskHandler landHandle;
    private final KLogger logger;
    private final Turret turret;
    private final TurretStyle style;
    private final TurretType type;
    private Integer targets;
    private Boolean shouldRayTrace;
    private final TurretStateCache stateCache;
    private final boolean hasExpired;
    private final boolean debug;

    public TurretTurretTaskHandler(TurretIterationTaskHandler.TurretLandTaskHandler landHandle, Turret turret) {
        TurretIterationTaskHandler turretIterationTaskHandler = landHandle.iteration;
        Objects.requireNonNull(turretIterationTaskHandler);
        super(landHandle);
        this.landHandle = landHandle;
        this.logger = landHandle.iteration.logger;
        this.turret = turret;
        this.style = (TurretStyle)turret.getStyle();
        this.type = (TurretType)this.style.getType();
        if (TurretFactory.ACCURACY == 0L) {
            this.stateCache = new TurretStateCache();
            this.hasExpired = true;
        } else {
            TickedCache<TurretStateCache> stateCacheCont = turret.getStateCache();
            this.hasExpired = stateCacheCont.hasExpired();
            if (this.hasExpired) {
                if (stateCacheCont.hasValue()) {
                    stateCacheCont.update();
                } else {
                    stateCacheCont.set(new TurretStateCache());
                }
            }
            this.stateCache = stateCacheCont.get();
        }
        this.debug = landHandle.iteration.g_debug && turret.getOrigin().equals(TurretFactory.debugTarget);
    }

    public void handleTurret() {
        if (this.landHandle.iteration.g_debug) {
            ++this.landHandle.iteration.totalHandledTurrets;
        }
        if (this.debug) {
            this.logger.log("----------------------------------------------");
            this.logger.log("Turret existence acknowledged: " + this.turret);
        }
        if (!this.hasExpired && !this.stateCache.canFunction) {
            if (this.debug) {
                this.logger.log("Turret was marked as non-functional as a result of previous cache.");
            }
            if (this.type.isRanged()) {
                ((RangedTurret)this.turret).tick();
            }
            return;
        }
        Boolean canFunction = this.canTurretFunction();
        if (canFunction != null) {
            this.stateCache.canFunction = canFunction;
        }
    }

    private Boolean canTurretFunction() {
        if (this.debug && this.regulatable.get() != null) {
            this.logger.property((Object)"Regulatored", true);
        }
        if (InfernoTurret.DISABLED && this.turret instanceof InfernoTurret) {
            if (this.debug) {
                this.logger.log("Inferno turrets are disabled until they're fixed. Please report the console error.");
            }
            return false;
        }
        if (!this.type.isRanged()) {
            return false;
        }
        if (this.debug) {
            this.logger.property((Object)"isRanged", true);
        }
        RangedTurret rangedTurret = (RangedTurret)this.turret;
        rangedTurret.tick();
        if (rangedTurret.isOutOfAmmo() && this.regulatable.isPresent() && ((Regulator)this.regulatable.get()).hasRule(Regulator.Rule.AUTO_FILL_TURRETS)) {
            if (this.debug) {
                this.logger.log("Refill Signal");
            }
            RegulatorManager.refillTurret(rangedTurret, this.kingdom, (Regulator)this.regulatable.get());
        }
        if (!this.turret.canFunction()) {
            if (rangedTurret.getCooldown() > 0) {
                return null;
            }
            return false;
        }
        if (this.debug) {
            this.logger.property((Object)"canFunction", true);
        }
        if (rangedTurret.isManual()) {
            return false;
        }
        if (this.debug) {
            this.logger.property((Object)"Automatic", true);
        }
        double range = this.hasExpired ? rangedTurret.getRange(this.kingdom) : -1.0;
        Location origin = rangedTurret.getActivationPoint();
        if (this.hasExpired) {
            Collection entities = this.world.getNearbyEntities(origin, range, range, range);
            if (this.debug) {
                this.logger.log("Entities: " + entities.stream().map(x -> x.getType().name()).collect(Collectors.joining(", ")));
            }
            UnsafeArrayList<EntityHandleResult> cachedEntities = null;
            int processedEntities = 0;
            Iterator iterator = entities.iterator();
            while (iterator.hasNext()) {
                Entity entity2 = (Entity)iterator.next();
                EntityHandleResult entityResult = new EntityHandleResult();
                this.handleEntity(entity2, this.debug, origin, entityResult);
                if (entityResult.target == null) continue;
                if (cachedEntities == null) {
                    cachedEntities = UnsafeArrayList.withSize(new EntityHandleResult[entities.size() - processedEntities]);
                }
                ++processedEntities;
                cachedEntities.add(entityResult);
                if (!this.activation(entityResult, origin) || !this.postActivation()) continue;
                break;
            }
            this.stateCache.entities = cachedEntities == null ? Collections.emptyList() : cachedEntities;
        } else {
            if (this.debug) {
                this.logger.property((Object)"Cached Entities", this.stateCache.entities.size());
            }
            for (EntityHandleResult entity3 : this.stateCache.entities) {
                if (entity3.target.isDead()) {
                    if (!this.debug) continue;
                    this.logger.log("Cached entity is dead");
                    continue;
                }
                entity3.calc = TurretTypeRanged.calcShot(origin, entity3.target);
                if (!this.activation(entity3, origin) || !this.postActivation()) continue;
                break;
            }
        }
        if (this.targets == null && this.turret instanceof InfernoTurret) {
            InfernoTurret inferno = (InfernoTurret)this.turret;
            inferno.stop();
        }
        return true;
    }

    private boolean activation(EntityHandleResult entityResult, Location origin) {
        if (this.debug) {
            this.logger.log("Activating Event");
        }
        TurretActivateEvent event = new TurretActivateEvent(entityResult.target, this.turret, this.kingdom, this.land, origin, entityResult.kp, entityResult.calc);
        TurretType.call(event);
        if (event.isCancelled()) {
            if (this.debug) {
                this.logger.log("Event cancelled");
            }
            return false;
        }
        return this.type.tryActivate(event);
    }

    private boolean postActivation() {
        if (this.debug) {
            this.logger.log("Activated");
        }
        RangedTurret rangedTurret = (RangedTurret)this.turret;
        rangedTurret.postActivation(this.kingdom);
        if (this.targets == null) {
            this.targets = rangedTurret.getMaxTargets(this.kingdom);
        }
        if ((this.targets = Integer.valueOf(this.targets - 1)) == 0) {
            if (this.debug) {
                this.logger.log("Max targets reached");
            }
            return true;
        }
        return false;
    }

    private void handleEntity(Entity entity2, boolean debug, Location origin, EntityHandleResult result) {
        Kingdom targetKingdom;
        LivingEntity target;
        if (debug) {
            this.logger.property((Object)"-- Entity", entity2.getType());
        }
        if (TurretTask.IGNORED_ENTITY_TYPES.contains(XEntityType.of((EntityType)entity2.getType()))) {
            return;
        }
        if (debug) {
            this.logger.property((Object)"--- Ignored Entity Type", false);
        }
        if (entity2.isDead()) {
            return;
        }
        if (debug) {
            this.logger.property((Object)"--- isDead", false);
        }
        if (!TurretFactory.ALLOW_TARGETTING_NPCS && ServiceHandler.isNPC(entity2)) {
            return;
        }
        if (debug) {
            this.logger.property((Object)"--- NPC", false);
        }
        if (TurretFactory.INVULNERABLE.containsKey(entity2)) {
            return;
        }
        if (debug) {
            this.logger.property((Object)"--- Invulnerable", false);
        }
        if ((target = (LivingEntity)entity2).isInvulnerable()) {
            return;
        }
        if (debug) {
            this.logger.property((Object)"--- isInvulnerable", false);
        }
        if (this.turret.skipTarget(target)) {
            return;
        }
        if (debug) {
            this.logger.property((Object)"--- targetCheckup", true);
        }
        KingdomPlayer kp = null;
        if (target.getType() == EntityType.PLAYER) {
            Player player;
            if (this.kingdom.isPacifist() && !this.type.isFriends() && !TurretTask.ENABLED_FOR_PACIFISTS) {
                return;
            }
            if (debug) {
                this.logger.property((Object)"--- isPacifist", this.kingdom.isPacifist());
                this.logger.property((Object)"--- pacifistsEnabled", TurretTask.ENABLED_FOR_PACIFISTS);
                this.logger.property((Object)"--- isFriends", this.type.isFriends());
                this.logger.property((Object)"--- isEnemies", this.type.isEnemies());
            }
            if (PlayerUtils.invulnerableGameMode(player = (Player)target)) {
                return;
            }
            if (debug) {
                this.logger.property((Object)"--- invulnerableGameMode", false);
            }
            if (ServiceHandler.isVanished(player)) {
                return;
            }
            if (debug) {
                this.logger.property((Object)"--- isVanished", false);
            }
            if (ServiceHandler.isInGodMode(player)) {
                return;
            }
            if (debug) {
                this.logger.property((Object)"--- isInGodMode", false);
            }
            if (PlayerUtils.isEffectivelyInvisible(player) && !this.turret.canDetectInvisible(this.kingdom)) {
                return;
            }
            if (debug) {
                this.logger.property((Object)"--- isEffectivelyInvisible", PlayerUtils.isEffectivelyInvisible(player));
                this.logger.property((Object)"--- canDetectInvisible", this.turret.canDetectInvisible(this.kingdom));
            }
            if (this.regulatable.isPresent()) {
                Boolean attr = ((Regulator)this.regulatable.get()).hasAttribute(player.getUniqueId(), Regulator.Attribute.TURRET_CEASEFIRE);
                if (debug) {
                    this.logger.property((Object)"--- Regulator.Attribute.TURRET_CEASEFIRE", attr);
                }
                if (attr != null && !attr.booleanValue()) {
                    return;
                }
            }
            kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            if (debug) {
                this.logger.property((Object)"--- isAdmin", kp.isAdmin());
            }
            if (kp.isAdmin()) {
                return;
            }
            if (!this.type.isEnemies() || !this.type.isFriends()) {
                targetKingdom = kp.getKingdom();
                if (targetKingdom != null && targetKingdom.isPacifist() && !TurretTask.CAN_TARGET_PACIFISTS && this.type.isEnemies()) {
                    return;
                }
                boolean canAttack = TurretFactory.canAttack(this.turret, targetKingdom, this.kingdom);
                if (debug) {
                    this.logger.property((Object)"--- Normal TURRET_CEASEFIRE", canAttack);
                }
                if (!canAttack ? !this.type.isFriends() : !this.type.isEnemies()) {
                    return;
                }
            }
        } else {
            KingdomLandEntity landEntity;
            Land source;
            KingdomEntity kingdomEntity;
            PetInfo pet;
            LivingEntity livingEntity;
            UUID owner = null;
            if (entity2.getType() == EntityType.WITHER && (livingEntity = (LivingEntity)entity2).getHealth() <= 150.0) {
                if (debug) {
                    this.logger.property((Object)"--- Wither Health", livingEntity.getHealth());
                }
                return;
            }
            if (owner == null && (pet = ServiceHandler.getPetInfo(entity2)) != null) {
                if (!pet.canBeAttacked()) {
                    return;
                }
                owner = pet.getOwner();
            }
            if (owner != null) {
                kp = KingdomPlayer.getKingdomPlayer(owner);
                targetKingdom = kp.getKingdom();
                boolean canAttack = TurretFactory.canAttack(this.turret, targetKingdom, this.kingdom);
                if (debug) {
                    this.logger.property((Object)"--- Pet TURRET_CEASEFIRE", canAttack);
                }
                if (!canAttack) {
                    return;
                }
            }
            if ((kingdomEntity = KingdomEntityRegistry.get((Entity)target)) instanceof KingdomLandEntity && Objects.equals((source = (landEntity = (KingdomLandEntity)kingdomEntity).getLand()).getKingdomId(), this.land.getKingdomId())) {
                if (debug) {
                    this.logger.log("--- Same source land entity");
                }
                return;
            }
        }
        TurretTypeRanged.ShootingCalculations calc = TurretTypeRanged.calcShot(origin, target);
        if (this.shouldRayTrace == null || this.shouldRayTrace.booleanValue()) {
            RangedTurret rangedTurret = (RangedTurret)this.turret;
            if (this.shouldRayTrace == null) {
                this.shouldRayTrace = XReflection.supports((int)13) && !rangedTurret.canPassThrough(this.kingdom);
                if (debug) {
                    this.logger.log("--- Raytracing");
                }
            }
            if (this.shouldRayTrace.booleanValue() && !TurretTypeRanged.rayTrace(rangedTurret, this.kingdom, target, calc)) {
                if (debug) {
                    this.logger.log("--- Raytracing failed");
                }
                return;
            }
        }
        result.calc = calc;
        result.kp = kp;
        result.target = target;
    }

    public static final class EntityHandleResult {
        public LivingEntity target;
        public KingdomPlayer kp;
        public TurretTypeRanged.ShootingCalculations calc;
    }
}

