/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.turrets;

import java.time.Duration;
import java.util.Objects;
import java.util.stream.Stream;
import org.bukkit.entity.Animals;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.NPC;
import org.bukkit.entity.WaterMob;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.Land;
import org.kingdoms.libs.xseries.XEntityType;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.main.KLogger;
import org.kingdoms.managers.buildings.turrets.TurretFactory;
import org.kingdoms.managers.buildings.turrets.TurretIterationTaskHandler;
import org.kingdoms.utils.cache.EnumCache;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;

final class TurretTask
extends BukkitRunnable {
    protected static final boolean ENABLED_FOR_PACIFISTS = KingdomsConfig.Turrets.PACIFISTS_ENABLED.getManager().getBoolean();
    protected static final boolean CAN_TARGET_PACIFISTS = KingdomsConfig.Turrets.PACIFISTS_TARGET.getManager().getBoolean();
    protected static final QuickEnumSet<XEntityType> IGNORED_ENTITY_TYPES = new QuickEnumSet((Enum[])EnumCache.XENTITY_TYPES);

    protected TurretTask() {
    }

    public void run() {
        KLogger logger;
        boolean g_debug = KLogger.isDebugging();
        KLogger kLogger = logger = g_debug ? new KLogger(KingdomsDebug.TURRET, false) : null;
        if (TurretFactory.isDisabled()) {
            if (g_debug) {
                logger.log(Duration.ofSeconds(5L), (Object)"Turrets are disabled.");
            }
            return;
        }
        if (g_debug) {
            logger.log(Duration.ofSeconds(5L), (Object)("Total turret lands to process: " + TurretFactory.TURRET_LANDS.size()));
        }
        TurretIterationTaskHandler iterationTaskHandler = new TurretIterationTaskHandler(g_debug, logger);
        for (Land land : TurretFactory.TURRET_LANDS.values()) {
            TurretIterationTaskHandler turretIterationTaskHandler = iterationTaskHandler;
            Objects.requireNonNull(turretIterationTaskHandler);
            TurretIterationTaskHandler.TurretLandTaskHandler landHandler = turretIterationTaskHandler.new TurretIterationTaskHandler.TurretLandTaskHandler(land);
            landHandler.handle();
        }
    }

    static {
        IGNORED_ENTITY_TYPES.addAll((Enum[])new XEntityType[]{XEntityType.IRON_GOLEM, XEntityType.SNOW_GOLEM, XEntityType.ARMOR_STAND});
        if (XReflection.supports((int)19)) {
            IGNORED_ENTITY_TYPES.add(XEntityType.ALLAY);
        }
        for (XEntityType entityType : EnumCache.XENTITY_TYPES) {
            Class entityClazz;
            if (!entityType.isSupported() || (entityClazz = entityType.get().getEntityClass()) != null && LivingEntity.class.isAssignableFrom(entityClazz) && !Stream.of(Animals.class, WaterMob.class, NPC.class).anyMatch(x -> x.isAssignableFrom(entityClazz))) continue;
            IGNORED_ENTITY_TYPES.add(entityType);
        }
    }
}

