/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.turrets;

import java.util.List;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.utils.internal.identity.QuantumIdentityHashMap;

public class SoldierManager
implements Listener {
    public static final String SOLDIER_METADATA = "SOLDIER";
    private static final Map<LivingEntity, Pair<BukkitTask, List<LivingEntity>>> SOLDIERS = new QuantumIdentityHashMap<LivingEntity, Pair<BukkitTask, List<LivingEntity>>>();

    public static Map<LivingEntity, Pair<BukkitTask, List<LivingEntity>>> getSoldiers() {
        return SOLDIERS;
    }

    @EventHandler
    public void onTargetDeath(EntityDeathEvent event) {
        Pair<BukkitTask, List<LivingEntity>> guards = SOLDIERS.remove(event.getEntity());
        if (guards == null) {
            return;
        }
        guards.getKey().cancel();
        ParticleDisplay display = ParticleDisplay.of((XParticle)XParticle.WITCH);
        for (LivingEntity guard : guards.getValue()) {
            if (!guard.isValid()) continue;
            display.spawn(guard.getLocation());
            guard.setHealth(0.0);
        }
    }
}

