/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.turrets;

import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.xseries.XEntityType;
import org.kingdoms.managers.ChairManager;
import org.kingdoms.managers.ChairSession;
import org.kingdoms.managers.buildings.structures.RegulatorManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/kingdoms/managers/buildings/turrets/ManualTurretHandler;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onShoot", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onQuickGUIOpen", "Lorg/bukkit/event/player/PlayerArmorStandManipulateEvent;", "core"})
@SourceDebugExtension(value={"SMAP\nManualTurretHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualTurretHandler.kt\norg/kingdoms/managers/buildings/turrets/ManualTurretHandler\n+ 2 ChairManager.kt\norg/kingdoms/managers/ChairManager$Companion\n*L\n1#1,55:1\n79#2,2:56\n79#2,2:58\n*S KotlinDebug\n*F\n+ 1 ManualTurretHandler.kt\norg/kingdoms/managers/buildings/turrets/ManualTurretHandler\n*L\n22#1:56,2\n44#1:58,2\n*E\n"})
public final class ManualTurretHandler
implements Listener {
    @EventHandler
    public final void onShoot(@NotNull PlayerInteractEvent event) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAction() != Action.LEFT_CLICK_AIR) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        ChairManager.Companion this_$iv = ChairManager.Companion;
        boolean $i$f$get = false;
        ChairSession<Object> chairSession = this_$iv.getHandler(player2);
        if (chairSession == null) {
            object2 = null;
        } else {
            ChairSession<Object> session$iv = chairSession;
            if (session$iv.getSession() instanceof RangedTurret) {
                Intrinsics.checkNotNull(session$iv, (String)"null cannot be cast to non-null type org.kingdoms.managers.ChairSession<T of org.kingdoms.managers.ChairManager.Companion.get>");
                object2 = session$iv;
            } else {
                object2 = object = null;
            }
        }
        if (object2 == null || (object = (RangedTurret)((ChairSession)object).getSession()) == null) {
            return;
        }
        Object turret = object;
        if (!((RangedTurret)turret).isManual()) {
            return;
        }
        if (((RangedTurret)turret).isOutOfAmmo()) {
            Land land = ((KingdomBlock)turret).getLand();
            Intrinsics.checkNotNull((Object)land);
            Land land2 = land;
            Regulator regulator = land2.getStructure(Regulator.class);
            if (regulator != null && regulator.hasRule(Regulator.Rule.AUTO_FILL_TURRETS)) {
                RegulatorManager.refillTurret((RangedTurret)turret, land2.getKingdom(), regulator);
            }
        }
        if (!((RangedTurret)turret).canFunction()) {
            return;
        }
        Location location = player2.getEyeLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getEyeLocation(...)");
        Location loc = location;
        Land land = ((KingdomBlock)turret).getLand();
        Kingdom kingdom = land != null ? land.getKingdom() : null;
        XEntityType type = ((RangedTurret)turret).getProjectile();
        ((RangedTurret)turret).shootEntity(type, kingdom, loc, loc.getDirection());
        ((RangedTurret)turret).postActivation(kingdom);
    }

    @EventHandler(ignoreCancelled=true)
    public final void onQuickGUIOpen(@NotNull PlayerArmorStandManipulateEvent event) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        ChairManager.Companion this_$iv = ChairManager.Companion;
        boolean $i$f$get = false;
        ChairSession<Object> chairSession = this_$iv.getHandler(player2);
        if (chairSession == null) {
            object2 = null;
        } else {
            ChairSession<Object> session$iv = chairSession;
            if (session$iv.getSession() instanceof RangedTurret) {
                Intrinsics.checkNotNull(session$iv, (String)"null cannot be cast to non-null type org.kingdoms.managers.ChairSession<T of org.kingdoms.managers.ChairManager.Companion.get>");
                object2 = session$iv;
            } else {
                object2 = object = null;
            }
        }
        if (object2 == null || (object = (RangedTurret)((ChairSession)object).getSession()) == null) {
            return;
        }
        Object turret = object;
        ((TurretType)((TurretStyle)((KingdomBuilding)turret).getStyle()).getType()).open((KingdomItemGUIContext<Turret>)new KingdomItemGUIContext<KingdomBuilding>(new KingdomItemInteractEvent<KingdomBuilding>(new PlayerInteractEvent(player2, Action.RIGHT_CLICK_AIR, null, ((KingdomBuilding)turret).getBlock(), BlockFace.UP), ((KingdomBlock)turret).getLand(), (KingdomBuilding)turret)));
    }
}

