/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.structures;

import java.time.Duration;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.abstraction.processor.KingdomsProcess;
import org.kingdoms.abstraction.processor.KingdomsProcessor;
import org.kingdoms.commands.general.building.CommandBuildingPreview;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.item.KingdomItemCreateSettings;
import org.kingdoms.constants.land.KingdomBuildingHandler;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.building.BuildingConstruction;
import org.kingdoms.constants.land.building.BuildingConstructionType;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.objects.Outpost;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.items.KingdomItemPlaceContext;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.ContextualMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.managers.ItemMatcher;
import org.kingdoms.managers.buildings.KingdomBuildingManagerCommons;
import org.kingdoms.managers.buildings.limit.BuildingLimiter;
import org.kingdoms.managers.buildings.turrets.TurretManager;
import org.kingdoms.managers.land.KingdomBuildingManager;
import org.kingdoms.managers.land.LandProtectionManager;
import org.kingdoms.managers.land.block.KingdomsBlockBreakContext;
import org.kingdoms.managers.land.block.KingdomsBlockInteractContext;
import org.kingdoms.managers.land.block.KingdomsBlockPlaceContext;
import org.kingdoms.managers.land.block.KingdomsBlockRepairContext;
import org.kingdoms.managers.land.block.KingdomsBlockUpgradeContext;
import org.kingdoms.managers.land.map.KingdomsMap;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.server.location.Direction;
import org.kingdoms.utils.chunks.ChunkConnections;
import org.kingdoms.utils.cooldown.BiCooldown;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.display.visualizer.StructureVisualizer;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class StructureManager
implements KingdomBuildingHandler<Structure> {
    private static final Cooldown<UUID> NEXUS_RP_CD = new Cooldown();
    private static final BiCooldown<UUID, Structure> CENTRAL_POINT_WARNING = new BiCooldown(IdentityHashMap::new);
    public static final Namespace NS = Namespace.kingdoms("STRUCTURE");
    public static final StructureManager INSTANCE = new StructureManager();

    private StructureManager() {
    }

    @Override
    public Messenger onPlace(@NotNull KingdomsBlockPlaceContext<Structure> context) {
        Messenger error;
        KingdomsProcessor limitProcessor;
        boolean isClaimed;
        Block block;
        Player player = context.getPlayer().getPlayer();
        PlayerInteractEvent cause = context.getCause();
        if (cause != null) {
            cause.setCancelled(true);
        }
        if (!XBlock.isAir((Material)(block = context.getOrigin().getBlock()).getType())) {
            context.getMessageContext().parse("material", KingdomsLang.translate(XMaterial.matchXMaterial((Material)block.getType())));
            return KingdomsLang.STRUCTURES_BLOCK_OCCUPIED;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            return KingdomsLang.NO_KINGDOM_STRUCTURES_USE;
        }
        if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
            return StandardKingdomPermission.STRUCTURES.getDeniedMessage();
        }
        Pair pairs = KingdomBuildingManager.getPairs(context, this);
        Structure structure = pairs.getKey();
        StructureStyle style = (StructureStyle)pairs.getValue();
        Land land = SimpleChunkLocation.of(block).getLand();
        boolean bl = isClaimed = land != null && land.isClaimed();
        if (!isClaimed && !((StructureType)((StructureStyle)structure.getStyle()).getType()).canBePlacedInUnclaimed()) {
            return KingdomsLang.UNCLAIMED_PLACE_STRUCTURES;
        }
        if (!TurretManager.canBePlacedInWorld(structure, player)) {
            return KingdomsLang.STRUCTURES_BLOCK_DISABLED_WORLD;
        }
        if (isClaimed && !KingdomsDefaultPluginPermission.STRUCTURES_BUILD_PLACE.hasPermission((CommandSender)player, true) && !land.getKingdomId().equals(kp.getKingdomId()) && !land.getKingdom().hasAttribute(kp.getKingdom(), (RelationAttribute)StandardRelationAttribute.MANAGE_STRUCTURES)) {
            return KingdomsLang.OTHER_KINGDOMS_STRUCTURE_PLACE;
        }
        if (isClaimed && !((BuildingLimiter)(limitProcessor = BuildingLimiter.ofStructures(land.getKingdom(), land).checkCanAddMore(style).process())).isSuccessful()) {
            context.inherit(limitProcessor);
            return null;
        }
        if (!kp.isAdmin() && (error = KingdomBuildingManagerCommons.evaluateConditions(structure, "place")) != null) {
            return error;
        }
        if (!kp.isAdmin() && !style.canBePlacedInBiome(block.getLocation())) {
            return KingdomsLang.STRUCTURES_CANT_PLACE_IN_BIOME;
        }
        if (CommandBuildingPreview.isEnabled(player)) {
            KingdomBuildingManager.preview(player, structure);
            return null;
        }
        if (!isClaimed) {
            land = new Land(SimpleChunkLocation.of(block));
        }
        Direction direction = Direction.cardinalDirectionFromYaw(player.getLocation().getYaw()).getOppositeFace();
        if (!KingdomBuildingManager.validateAndPreview(player, structure, true)) {
            return KingdomsLang.BUILDING_ERRORS_MAIN;
        }
        context.addFinalizer(() -> {
            StructureVisualizer.stop(player, KingdomBuildingManager.PREVIEW_NS);
            KingdomItemPlaceContext placeContext = new KingdomItemPlaceContext();
            placeContext.setPlayer(kp);
            if (cause != null) {
                placeContext.setCause((Event)cause);
                placeContext.setFromItem(cause.getItem());
            }
            placeContext.setFacing(direction);
            structure.place(placeContext);
        });
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Messenger handleNexusBreak(KingdomsBlockBreakContext<Structure> context) {
        if (!KingdomsConfig.NEXUS_BREAK_ENABLED.getManager().getBoolean()) {
            return null;
        }
        BlockBreakEvent event = context.getCause();
        KingdomPlayer kp = context.getPlayer();
        Land land = context.getBlock().getLand();
        Kingdom landKingdom = land.getKingdom();
        Player player = event.getPlayer();
        Kingdom kpKingdom = kp.getKingdom();
        if (player.getGameMode() == GameMode.CREATIVE && !KingdomsConfig.NEXUS_BREAK_CREATIVE.getBoolean()) {
            return null;
        }
        if (landKingdom.isPacifist()) return KingdomsLang.OTHER_KINGDOMS_NEXUS_BREAK_PACIFIST;
        YamlConfigAccessor section = KingdomsConfig.NEXUS_BREAK_ITEM.getManager().noDefault().getSection();
        if (section != null && !new ItemMatcher(section.getSection()).matches(player.getInventory().getItemInMainHand())) return KingdomsLang.OTHER_KINGDOMS_NEXUS_BREAK_WRONG_ITEM;
        if (NEXUS_RP_CD.isInCooldown(player.getUniqueId())) {
            event.setCancelled(true);
            context.getMessageContext().raw("cooldown", TimeFormatter.of(NEXUS_RP_CD.getTimeLeft(player.getUniqueId())));
            return KingdomsLang.OTHER_KINGDOMS_NEXUS_BREAK_COOLDOWN;
        }
        double cost = KingdomsConfig.NEXUS_BREAK_COST.getDouble();
        if (cost <= 0.0) {
            return null;
        }
        if (!landKingdom.getResourcePoints().has(cost)) {
            cost = landKingdom.getResourcePoints().get();
        }
        KingdomsLang.OTHER_KINGDOMS_NEXUS_BREAK.sendMessage((CommandSender)player, "rp", cost);
        landKingdom.getResourcePoints().add(-cost);
        kpKingdom.getResourcePoints().add(cost);
        Long cd = KingdomsConfig.NEXUS_BREAK_COOLDOWN.getTime(new PlaceholderContextBuilder().withContext(player).other(landKingdom)).toMillis();
        if (cd == null || cd <= 0L) return null;
        NEXUS_RP_CD.add(player.getUniqueId(), cd, TimeUnit.MILLISECONDS);
        return null;
    }

    @Override
    public Messenger onBreak(@NotNull KingdomsBlockBreakContext<Structure> context) {
        Messenger manualBreak;
        int radius;
        BuildingConstruction ctor;
        Messenger error;
        KingdomPlayer kp = context.getPlayer();
        Player player = kp.getPlayer();
        Land land = context.getBlock().getLand();
        Structure structure = context.getBlock();
        Kingdom landKingdom = land.getKingdom();
        Kingdom kpKingdom = kp.getKingdom();
        if (!kp.isAdmin() && kp.hasKingdom() && !kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
            return StandardKingdomPermission.STRUCTURES.getDeniedMessage();
        }
        if (!kp.isAdmin() && (error = KingdomBuildingManagerCommons.evaluateConditions(structure, "break")) != null) {
            return error;
        }
        if ((structure.getBuilding() == null || structure.getBuilding().isUnderConstruction()) && (ctor = (BuildingConstruction)structure.getBuilding()).getType() == BuildingConstructionType.DEMOLISHING) {
            return KingdomsLang.BUILDING_ALREADY_BEING_DEMOLISHED;
        }
        if (!KingdomsDefaultPluginPermission.STRUCTURES_BUILD_BREAK.hasPermission((CommandSender)player, true) && landKingdom != null) {
            if (kpKingdom != null) {
                KLogger.debug((DebugNS)KingdomsDebug.STRUCTURE_BREAK, () -> "No permission but structure is in pacifist? " + landKingdom.isPacifist() + " and has attributes? " + landKingdom.hasAttribute(kpKingdom, (RelationAttribute)StandardRelationAttribute.MANAGE_STRUCTURES));
                if (!landKingdom.hasAttribute(kpKingdom, (RelationAttribute)StandardRelationAttribute.MANAGE_STRUCTURES)) {
                    if (!((StructureType)((StructureStyle)structure.getStyle()).getType()).isNexus()) {
                        return KingdomsLang.OTHER_KINGDOMS_STRUCTURE_BREAK;
                    }
                    Messenger nexusBreak = StructureManager.handleNexusBreak(context);
                    if (nexusBreak != null) {
                        return nexusBreak;
                    }
                    return KingdomsLang.OTHER_KINGDOMS_STRUCTURE_BREAK;
                }
                if (((StructureType)((StructureStyle)structure.getStyle()).getType()).isNexus() && !Objects.equals(kpKingdom, landKingdom)) {
                    return KingdomsLang.OTHER_KINGDOMS_STRUCTURE_NEXUS_BREAK_WITH_PERMISSION;
                }
                if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
                    return StandardKingdomPermission.STRUCTURES.getDeniedMessage();
                }
            } else {
                return KingdomsLang.OTHER_KINGDOMS_STRUCTURE_BREAK;
            }
        }
        if (!KingdomsDefaultPluginPermission.NEXUS_REMOVE.hasPermission((CommandSender)player, true) && ((StructureType)((StructureStyle)structure.getStyle()).getType()).isNexus() && !KingdomsConfig.NEXUS_ALLOW_REMOVAL.getBoolean()) {
            return KingdomsLang.NEXUS_CANT_BE_REMOVED;
        }
        if (structure instanceof Outpost && landKingdom != null && (radius = ChunkConnections.getConnectionRadius()) > 0) {
            Set<SimpleChunkLocation> landLocs = landKingdom.getLandLocations();
            Set<SimpleChunkLocation> connections = ChunkConnections.getConnectedChunks(radius, land.getLocation(), landLocs::contains);
            boolean foundCentralPoint = false;
            for (SimpleChunkLocation connection : connections) {
                Land connLand;
                Structure centralPoints;
                if (connection.equals(land.getLocation()) || (centralPoints = (connLand = connection.getLand()).getStructure(x -> x instanceof Outpost || ((StructureType)((StructureStyle)x.getStyle()).getType()).isNexus())) == null) continue;
                foundCentralPoint = true;
                break;
            }
            if (!foundCentralPoint) {
                connections.add(land.getLocation());
                if (CENTRAL_POINT_WARNING.isInCooldown(player.getUniqueId(), structure)) {
                    context.addFinalizer(() -> landKingdom.unclaim(connections, kp, UnclaimLandEvent.Reason.CONNECTION_ISSUES, false));
                } else {
                    if (context.getIntent() == KingdomsProcess.Intent.REALTIME) {
                        context.addFinalizer(() -> new KingdomsMap().forPlayer(player).addElement("outpost-break-confirm", connections).displayAsync());
                    }
                    CENTRAL_POINT_WARNING.add(player.getUniqueId(), structure, Duration.ofSeconds(15L));
                    context.var("will_unclaim", connections.size());
                    return KingdomsLang.STRUCTURES_BREAK_CENTRAL_POINT;
                }
            }
        }
        if ((manualBreak = KingdomBuildingManagerCommons.handleManualBreak(context)) != null) {
            return manualBreak;
        }
        context.addFinalizer(() -> {
            StructureVisualizer.stop(player, KingdomBuildingManager.PREVIEW_NS);
            KingdomItemGUIContext.closeForOthers(structure, kp.getId());
            boolean toInv = KingdomsConfig.Structures.TO_INVENTORY_ON_BREAK.getManager().getBoolean();
            KingdomItemRemoveContext ctx = new KingdomItemRemoveContext();
            ctx.setCause((Event)context.getCause());
            ctx.setPlayer(kp);
            ctx.setDropsItem(!toInv);
            if (structure.remove(ctx).isCancelled()) {
                return;
            }
            KLogger.debug((DebugNS)KingdomsDebug.STRUCTURE_BREAK, () -> "Land kingdom is: " + landKingdom + " and permission " + KingdomsDefaultPluginPermission.STRUCTURES_BUILD_BREAK.hasPermission((CommandSender)player, true) + " with nexus permmission: " + KingdomsDefaultPluginPermission.NEXUS_REMOVE.hasPermission((CommandSender)player, true) + " and structure type: " + ((StructureStyle)structure.getStyle()).getType());
            if (VersionSupport.SUPPORTS_BlockBreakEvent_setDropItems) {
                context.getCause().setDropItems(false);
            }
            if (toInv && ((StructureStyle)structure.getStyle()).hasItem()) {
                XItemStack.giveOrDrop((Player)player, (ItemStack[])new ItemStack[]{structure.getItem(new KingdomItemCreateSettings(landKingdom == null ? kpKingdom : landKingdom, kp)).getItem()});
            }
        });
        return null;
    }

    @Override
    public Messenger onInteract(@NotNull KingdomsBlockInteractContext<Structure> context) {
        Messenger error;
        Kingdom kingdom;
        PlayerInteractEvent event = context.getCause();
        Player player = event.getPlayer();
        Structure structure = context.getBlock();
        if (!context.isFunctionalPoint("interaction")) {
            return null;
        }
        if (player.isSneaking() && KingdomsConfig.Structures.DISABLE_SHIFT_CLICK.getManager().getBoolean()) {
            Material type = player.getInventory().getItemInMainHand().getType();
            if (type == Material.AIR || !type.isBlock()) {
                event.setUseInteractedBlock(Event.Result.DENY);
            }
            return null;
        }
        Land land = structure.getLand();
        event.setCancelled(true);
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (land.isClaimed() && !KingdomsDefaultPluginPermission.STRUCTURES_INTERACT.hasPermission((CommandSender)player, true) && !StandardRelationAttribute.MANAGE_STRUCTURES.hasAttribute(kingdom = kp.getKingdom(), land.getKingdom())) {
            return KingdomsLang.OTHER_KINGDOMS_STRUCTURE_INTERACT;
        }
        if (structure.getBuilding().isUnderConstruction()) {
            return KingdomsLang.STRUCTURES_BUILDING_UNDER_CONSTRUCTION;
        }
        if (!kp.isAdmin() && (error = KingdomBuildingManagerCommons.evaluateConditions(structure, "interact")) != null) {
            return error;
        }
        KingdomItemInteractEvent<Structure> structureEvent = new KingdomItemInteractEvent<Structure>(event, land, structure);
        Bukkit.getPluginManager().callEvent(structureEvent);
        if (structureEvent.isCancelled()) {
            return null;
        }
        if (!land.isClaimed()) {
            LandProtectionManager.openKingdomItemGUI(player, structure, structureEvent);
            return KingdomsLang.OTHER_KINGDOMS_STRUCTURE_CAN_TAKE;
        }
        ((StructureType)((StructureStyle)structure.getStyle()).getType()).open(new KingdomItemGUIContext<Structure>(structureEvent));
        return null;
    }

    @Override
    public @NonNull Namespace getNamespace() {
        return NS;
    }

    @Override
    @Nullable
    public Messenger onRepair(@NotNull KingdomsBlockRepairContext<Structure> context) {
        return null;
    }

    @Override
    @Nullable
    public Messenger onUpgrade(@NotNull KingdomsBlockUpgradeContext<Structure> context) {
        Structure structure = context.getBlock();
        Kingdom kingdom = structure.getLand().getKingdom();
        KingdomPlayer kp = context.getPlayer();
        Player player = kp.getPlayer();
        Kingdom kpKingdom = kp.getKingdom();
        Kingdom viewerKingdom = kpKingdom == null ? kingdom : kpKingdom;
        int maxLevel = structure.getMaxLevel(kingdom);
        int upgradeCost = structure.getUpgradeCost(kingdom);
        if (structure.getLevel() >= maxLevel) {
            return KingdomsLang.STRUCTURES_UPGRADE_MAX_LEVEL;
        }
        if (structure.getBuilding().isUnderConstruction()) {
            return KingdomsLang.STRUCTURES_BUILDING_UNDER_CONSTRUCTION;
        }
        boolean admin = context.getPlayer().isAdmin();
        if (!admin) {
            if (!kp.hasPermission(StandardKingdomPermission.UPGRADE)) {
                return StandardKingdomPermission.UPGRADE.getDeniedMessage();
            }
            if (!viewerKingdom.getResourcePoints().has(upgradeCost)) {
                context.getMessageContext().raw("cost", upgradeCost);
                return KingdomsLang.STRUCTURES_UPGRADE_NOT_ENOUGH_RESOURCE_POINTS;
            }
            Messenger error = KingdomBuildingManagerCommons.evaluateConditions(structure, "upgrade");
            if (error != null) {
                return error;
            }
        }
        context.addFinalizer(() -> {
            if (player != null) {
                StructureVisualizer.stop(player, KingdomBuildingManager.PREVIEW_NS);
            }
            if (structure.upgrade(context.getNewLevel(), upgradeCost, kp).isCancelled()) {
                return;
            }
            if (!admin) {
                viewerKingdom.getResourcePoints().add(-upgradeCost);
            }
            structure.playSound("upgrading");
            context.message(KingdomsProcess.MessageType.INFO, new ContextualMessenger(KingdomsLang.STRUCTURES_UPGRADE_UPGRADING, structure.getMessageContext()));
            KingdomItemGUIContext.closeForOthers(structure, kp.getId());
        });
        return null;
    }

    @NotNull
    public StructureRegistry getRegistry() {
        return StructureRegistry.get();
    }
}

