/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.structures;

import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.KeyedConfigAccessor;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.objects.SiegeCannon;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.items.structures.SiegeCannonHitEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.messages.ActionBar;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.ChairManager;
import org.kingdoms.managers.ChairSession;
import org.kingdoms.managers.buildings.structures.SiegeCannonAmmo;
import org.kingdoms.managers.land.protection.explosions.LandExplosionManager;
import org.kingdoms.utils.EventUtil;
import org.kingdoms.utils.KingdomsBukkitExtensions;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.hash.EntityHashSet;
import org.kingdoms.utils.hash.EntityWeakHashSet;
import org.kingdoms.utils.kingdoms.Shields;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\fH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/managers/buildings/structures/SiegeManager;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onCannonHit", "", "event", "Lorg/bukkit/event/entity/ProjectileHitEvent;", "onCannonDamage", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onShoot", "onQuickGUIOpen", "Lorg/bukkit/event/player/PlayerArmorStandManipulateEvent;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSiegeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SiegeManager.kt\norg/kingdoms/managers/buildings/structures/SiegeManager\n+ 2 KingdomsBukkitExtensions.kt\norg/kingdoms/utils/KingdomsBukkitExtensions\n+ 3 ChairManager.kt\norg/kingdoms/managers/ChairManager$Companion\n*L\n1#1,271:1\n34#2:272\n33#2:273\n79#3,2:274\n79#3,2:276\n*S KotlinDebug\n*F\n+ 1 SiegeManager.kt\norg/kingdoms/managers/buildings/structures/SiegeManager\n*L\n112#1:272\n112#1:273\n212#1:274,2\n242#1:276,2\n*E\n"})
public final class SiegeManager
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final EntityWeakHashSet<Player> ARMORSTAND_RIGHT_CLICKED = ((EntityHashSet.WeakBuilder)((EntityHashSet.WeakBuilder)EntityHashSet.weakBuilder(Player.class).onDeath(SiegeManager::ARMORSTAND_RIGHT_CLICKED$lambda$3)).onLeave(SiegeManager::ARMORSTAND_RIGHT_CLICKED$lambda$4)).build();
    @JvmField
    @NotNull
    public static final Cooldown<UUID> SIEGE_LAST_ATTACK = new Cooldown();

    /*
     * WARNING - void declaration
     */
    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onCannonHit(@NotNull ProjectileHitEvent event) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Projectile projectile = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)projectile, (String)"getEntity(...)");
        Projectile projectile2 = projectile;
        Pair<SiegeCannon, SiegeCannonAmmo> pair = SiegeCannon.getSiegeCannonFromProjectile((Entity)projectile2);
        if (pair == null) {
            return;
        }
        Pair<SiegeCannon, SiegeCannonAmmo> pair2 = pair;
        SiegeCannon cannon = (SiegeCannon)((Map.Entry)pair2).getKey();
        SiegeCannonAmmo ammo = (SiegeCannonAmmo)((Map.Entry)pair2).getValue();
        Location location = projectile2.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Location location2 = location;
        cannon.displayParticle(location2, "hit");
        cannon.playSound(location2, "hit");
        Player player = cannon.getHandler();
        if (player == null) {
            return;
        }
        Player cannonShooterPlayer = player;
        SimpleChunkLocation chunk = SimpleChunkLocation.of(location2);
        Land land = chunk.getLand();
        if (event.getHitEntity() != null && event.getHitEntity() instanceof Player) {
            Entity entity2 = event.getHitEntity();
            Intrinsics.checkNotNull((Object)entity2, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
            Player hitPlayer = (Player)entity2;
            if (hitPlayer.isBlocking()) {
                PlayerInventory it = hitPlayer.getInventory();
                boolean bl = false;
                if (XMaterial.SHIELD.isSimilar(it.getItemInMainHand())) {
                    it.setItemInMainHand(null);
                } else {
                    it.setItemInOffHand(null);
                }
                hitPlayer.getInventory().setItemInOffHand(null);
                KingdomsLang.SIEGE_CANNON_HIT_PLAYERS_SHIELD.sendMessage((CommandSender)cannonShooterPlayer);
            }
        }
        Duration damage = cannon.getShieldDamage(ammo);
        SiegeCannonHitEvent siegeCannonHitEvent = new SiegeCannonHitEvent(cannon, event, damage);
        cannon.setLastHit(siegeCannonHitEvent);
        World world = location2.getWorld();
        Intrinsics.checkNotNull((Object)world);
        for (Entity entity3 : world.getNearbyEntities(location2, 15.0, 15.0, 15.0)) {
            if (entity3.getType() == EntityType.PLAYER || entity3.getType() == EntityType.ARMOR_STAND) continue;
            LandExplosionManager.protectEntityFromExplosion(null, (Entity)projectile2, entity3);
        }
        if (land == null) {
            KingdomsLang.SIEGE_CANNON_HIT_UNCLAIMED_LAND.sendError((CommandSender)cannonShooterPlayer, new Object[0]);
            EventUtil.cancelAndCall((Event)siegeCannonHitEvent);
            return;
        }
        Kingdom hitKingdom = land.getKingdom();
        if (hitKingdom == null) {
            KingdomsLang.SIEGE_CANNON_HIT_UNCLAIMED_LAND.sendError((CommandSender)cannonShooterPlayer, new Object[0]);
            EventUtil.cancelAndCall((Event)siegeCannonHitEvent);
            return;
        }
        Land land2 = cannon.getLand();
        if (!StandardRelationAttribute.INVADE.hasAttribute(hitKingdom, land2 != null ? land2.getKingdom() : null)) {
            Object[] entity3 = new Object[]{"kingdom", hitKingdom.getName()};
            KingdomsLang.SIEGE_CANNON_FRIENDLY_FIRE.sendError((CommandSender)cannonShooterPlayer, entity3);
            EventUtil.cancelAndCall((Event)siegeCannonHitEvent);
            return;
        }
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(hitKingdom);
        if (Shields.isEffectivelyPacifist(hitKingdom)) {
            CommandSender commandSender = (CommandSender)cannonShooterPlayer;
            Intrinsics.checkNotNull((Object)settings);
            KingdomsLang.SIEGE_CANNON_HIT_PACIFIST.sendMessage(commandSender, settings);
            EventUtil.cancelAndCall((Event)siegeCannonHitEvent);
            return;
        }
        String[] stringArray = new String[]{"attacker-shield-damage"};
        KeyedConfigAccessor keyedConfigAccessor = ((StructureStyle)cannon.getStyle()).getOption(stringArray);
        if (keyedConfigAccessor != null) {
            void this_$iv;
            KeyedConfigAccessor selfDmg = keyedConfigAccessor;
            boolean bl = false;
            objectArray = KingdomsBukkitExtensions.INSTANCE;
            OfflinePlayer $this$getKingdom$iv = (OfflinePlayer)cannonShooterPlayer;
            boolean $i$f$getKingdom = false;
            void var21_24 = this_$iv;
            OfflinePlayer $this$asKingdomPlayer$iv$iv = $this$getKingdom$iv;
            boolean $i$f$asKingdomPlayer = false;
            KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer($this$asKingdomPlayer$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
            Kingdom kingdom = kingdomPlayer.getKingdom();
            Intrinsics.checkNotNull((Object)kingdom);
            Kingdom userKingdom = kingdom;
            Duration dmg = selfDmg.getTime(new PlaceholderContextBuilder().withContext(userKingdom));
            if (dmg != null && !dmg.isZero()) {
                userKingdom.getShield().subtractDuration(dmg);
            }
        }
        Group group = Shields.getShieldToUse(hitKingdom);
        Intrinsics.checkNotNullExpressionValue((Object)group, (String)"getShieldToUse(...)");
        Group groupsShieldToUse = group;
        settings.withContext(groupsShieldToUse);
        Kingdom kingdom = KingdomPlayer.getKingdomPlayer((OfflinePlayer)cannonShooterPlayer).getKingdom();
        Intrinsics.checkNotNull((Object)kingdom);
        Kingdom attackerKingdom = kingdom;
        if (groupsShieldToUse.getShield().hasExpired()) {
            CommandSender commandSender = (CommandSender)cannonShooterPlayer;
            Intrinsics.checkNotNull((Object)settings);
            KingdomsLang.SIEGE_CANNON_HIT_NO_SHIELD.sendMessage(commandSender, settings);
            if (StandardRelationAttribute.BUILD.hasAttribute(hitKingdom, attackerKingdom)) {
                KingdomsLang.SIEGE_CANNON_HIT_BUILD_ATTRIBUTE.sendMessage((CommandSender)cannonShooterPlayer, settings);
            }
            EventUtil.cancelAndCall((Event)siegeCannonHitEvent);
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)siegeCannonHitEvent);
        if (siegeCannonHitEvent.isCancelled()) {
            return;
        }
        UUID uUID = hitKingdom.getKey();
        Long l = KingdomsConfig.Invasions.SHIELDS_PURCHASE_COOLDOWN_LAST_SIEGE_CANNON_HIT.getManager().getTimeMillis();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getTimeMillis(...)");
        SIEGE_LAST_ATTACK.add(uUID, ((Number)l).longValue());
        damage = siegeCannonHitEvent.getShieldDamage();
        if (damage.compareTo(groupsShieldToUse.getShield().getTimeLeft()) >= 0) {
            CommandSender commandSender = (CommandSender)cannonShooterPlayer;
            Intrinsics.checkNotNull((Object)settings);
            KingdomsLang.SIEGE_CANNON_HIT_DESTROYED_SHIELD.sendMessage(commandSender, settings);
            groupsShieldToUse.getShield().deactivate();
            return;
        }
        groupsShieldToUse.getShield().setDuration(groupsShieldToUse.getShield().getTimeLeft().minus(damage));
        CommandSender commandSender = (CommandSender)cannonShooterPlayer;
        Intrinsics.checkNotNull((Object)settings);
        KingdomsLang.SIEGE_CANNON_HIT_DAMAGED_SHIELD.sendMessage(commandSender, settings);
        for (Player member : hitKingdom.getOnlineMembers()) {
            objectArray = new Object[8];
            objectArray[0] = "attacker-kingdom";
            objectArray[1] = attackerKingdom.getName();
            objectArray[2] = "attacker";
            objectArray[3] = cannonShooterPlayer.getName();
            objectArray[4] = "attacked-chunk";
            Object[] objectArray2 = LocationUtils.getChunkEdits(chunk);
            objectArray[5] = KingdomsLang.LOCATIONS_CHUNK.parse(Arrays.copyOf(objectArray2, objectArray2.length));
            objectArray[6] = "attackers-chunk";
            objectArray2 = LocationUtils.getChunkEdits(SimpleChunkLocation.of(cannonShooterPlayer.getLocation()));
            objectArray[7] = KingdomsLang.LOCATIONS_CHUNK.parse(Arrays.copyOf(objectArray2, objectArray2.length));
            KingdomsLang.SIEGE_CANNON_HIT_DAMAGED_SHIELD_NOTIFY.sendMessage((CommandSender)member, objectArray);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public final void onCannonDamage(@NotNull EntityDamageByEntityEvent event) {
        Kingdom shooterKingdom;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SiegeManager $this$onCannonDamage_u24lambda_u242 = this;
        boolean bl = false;
        Pair<SiegeCannon, SiegeCannonAmmo> cannon = SiegeCannon.getSiegeCannonFromProjectile(event.getEntity());
        if (cannon != null) {
            event.setCancelled(true);
            return;
        }
        Pair<SiegeCannon, SiegeCannonAmmo> pair = SiegeCannon.getSiegeCannonFromProjectile(event.getDamager());
        if (pair == null) {
            return;
        }
        Pair<SiegeCannon, SiegeCannonAmmo> pair2 = pair;
        SiegeCannon cannon2 = (SiegeCannon)((Map.Entry)pair2).getKey();
        SiegeCannonAmmo ammo = (SiegeCannonAmmo)((Map.Entry)pair2).getValue();
        Entity entity2 = event.getEntity();
        Player player = entity2 instanceof Player ? (Player)entity2 : null;
        if (player == null) {
            return;
        }
        Player victim = player;
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)victim);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
        KingdomPlayer kp = kingdomPlayer;
        Kingdom kingdom = kp.getKingdom();
        Land land = cannon2.getLand();
        Kingdom kingdom2 = shooterKingdom = land != null ? land.getKingdom() : null;
        if (StandardRelationAttribute.CEASEFIRE.hasAttribute(kingdom, shooterKingdom)) {
            event.setCancelled(true);
        }
        event.setDamage(cannon2.getDamage(ammo));
        PlayerUtils.damageArmor((LivingEntity)victim, (int)cannon2.getArmorDamage(ammo));
        double knockback = cannon2.getKnockBack(ammo);
        LocationUtils.knockback(cannon2.getOrigin().toVector(), (Entity)victim, knockback, 0.0);
    }

    @EventHandler
    public final void onShoot(@NotNull EntityDamageByEntityEvent event) {
        String actionbar;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity2 = event.getDamager();
        Player player = entity2 instanceof Player ? (Player)entity2 : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        if (ARMORSTAND_RIGHT_CLICKED.remove((Object)player2)) {
            return;
        }
        ChairManager.Companion this_$iv = ChairManager.Companion;
        boolean $i$f$get = false;
        ChairSession<Object> chairSession = this_$iv.getHandler(player2);
        if (chairSession == null) {
            object2 = null;
        } else {
            ChairSession<Object> session$iv = chairSession;
            if (session$iv.getSession() instanceof SiegeCannon) {
                Intrinsics.checkNotNull(session$iv, (String)"null cannot be cast to non-null type org.kingdoms.managers.ChairSession<T of org.kingdoms.managers.ChairManager.Companion.get>");
                object2 = session$iv;
            } else {
                object2 = object = null;
            }
        }
        if (object2 == null || (object = (SiegeCannon)((ChairSession)object).getSession()) == null) {
            return;
        }
        Object cannon = object;
        event.setCancelled(true);
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(player2);
        if (!((SiegeCannon)cannon).isLoaded()) {
            String[] stringArray = new String[]{"actionbar", "not-loaded"};
            actionbar = ((StructureStyle)((KingdomBuilding)cannon).getStyle()).getOption(stringArray).getString();
            actionbar = MessageCompiler.compile(actionbar).buildPlain(settings);
            ActionBar.sendActionBar((Plugin)((Plugin)Kingdoms.get().getLoader()), (Player)player2, (String)actionbar);
            ((KingdomBuilding)cannon).playSound("empty");
            return;
        }
        if (((SiegeCannon)cannon).isInCooldown()) {
            ((KingdomBuilding)cannon).playSound("cooldown");
            return;
        }
        String[] stringArray = new String[]{"actionbar", "fire"};
        actionbar = ((StructureStyle)((KingdomBuilding)cannon).getStyle()).getOption(stringArray).getString();
        actionbar = MessageCompiler.compile(actionbar).buildPlain(settings);
        ActionBar.sendActionBar((Plugin)((Plugin)Kingdoms.get().getLoader()), (Player)player2, (String)actionbar);
        ((SiegeCannon)cannon).shoot();
    }

    @EventHandler(ignoreCancelled=true)
    public final void onQuickGUIOpen(@NotNull PlayerArmorStandManipulateEvent event) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        ChairManager.Companion this_$iv = ChairManager.Companion;
        boolean $i$f$get = false;
        ChairSession<Object> chairSession = this_$iv.getHandler(player2);
        if (chairSession == null) {
            object2 = null;
        } else {
            ChairSession<Object> session$iv = chairSession;
            if (session$iv.getSession() instanceof SiegeCannon) {
                Intrinsics.checkNotNull(session$iv, (String)"null cannot be cast to non-null type org.kingdoms.managers.ChairSession<T of org.kingdoms.managers.ChairManager.Companion.get>");
                object2 = session$iv;
            } else {
                object2 = object = null;
            }
        }
        if (object2 == null || (object = (SiegeCannon)((ChairSession)object).getSession()) == null) {
            return;
        }
        Object cannon = object;
        event.setCancelled(true);
        ARMORSTAND_RIGHT_CLICKED.add((Player)((Entity)player2));
        PlayerInteractEvent interactEvent = new PlayerInteractEvent(player2, Action.RIGHT_CLICK_BLOCK, null, null, BlockFace.SELF);
        KingdomItemInteractEvent<KingdomBuilding> structureInteractEvent = new KingdomItemInteractEvent<KingdomBuilding>(interactEvent, Land.getLand(event.getRightClicked().getLocation()), (KingdomBuilding)cannon);
        ((StructureType)((StructureStyle)((KingdomBuilding)cannon).getStyle()).getType()).open(new KingdomItemGUIContext<KingdomBuilding>(structureInteractEvent));
    }

    private static final void ARMORSTAND_RIGHT_CLICKED$lambda$3(EntityWeakHashSet map, Player x) {
        map.remove(x);
    }

    private static final void ARMORSTAND_RIGHT_CLICKED$lambda$4(EntityWeakHashSet map, Player x) {
        map.remove(x);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R4\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/kingdoms/managers/buildings/structures/SiegeManager$Companion;", "", "<init>", "()V", "ARMORSTAND_RIGHT_CLICKED", "Lorg/kingdoms/utils/hash/EntityWeakHashSet;", "Lorg/bukkit/entity/Player;", "org.kingdoms.libs.kotlin.jvm.PlatformType", "Lorg/kingdoms/utils/hash/EntityWeakHashSet;", "SIEGE_LAST_ATTACK", "Lorg/kingdoms/utils/cooldown/Cooldown;", "Ljava/util/UUID;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

