/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.structures;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Animals;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.events.general.GroupResourcePointConvertEvent;
import org.kingdoms.events.items.KingdomItemPlaceEvent;
import org.kingdoms.events.items.turrets.TurretAmmoFillEvent;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;

public final class RegulatorManager
implements Listener {
    private static final QuickEnumSet<CreatureSpawnEvent.SpawnReason> ACCEPTED_REASONS = new QuickEnumSet((Enum[])CreatureSpawnEvent.SpawnReason.values()).addAll((Enum[])new CreatureSpawnEvent.SpawnReason[]{CreatureSpawnEvent.SpawnReason.NATURAL, CreatureSpawnEvent.SpawnReason.LIGHTNING, CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK});

    @EventHandler(ignoreCancelled=true)
    public void onSpawn(CreatureSpawnEvent event) {
        Regulator.Rule rule;
        if (event.getEntityType() == EntityType.ARMOR_STAND) {
            return;
        }
        if (!ACCEPTED_REASONS.contains(event.getSpawnReason())) {
            return;
        }
        Location location = event.getLocation();
        Land land = Land.getLand(location);
        if (land == null || !land.isClaimed()) {
            return;
        }
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator == null) {
            return;
        }
        Regulator.Rule rule2 = rule = event.getEntity() instanceof Animals ? Regulator.Rule.DISABLE_ANIMAL_SPAWNING : Regulator.Rule.DISABLE_MOB_SPAWNING;
        if (regulator.hasRule(rule)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRegulatorPlace(KingdomItemPlaceEvent<?> event) {
        if (!(event.getKingdomItem() instanceof Regulator)) {
            return;
        }
        Regulator regulator = (Regulator)event.getKingdomItem();
        if (!regulator.hasRule(Regulator.Rule.AUTO_FILL_TURRETS)) {
            return;
        }
        Land land = regulator.getLand();
        Kingdom kingdom = land.getKingdom();
        RegulatorManager.refillAllTurrets(land, kingdom, regulator);
    }

    public static void refillAllTurrets(Land land, Kingdom kingdom, Regulator regulator) {
        for (Turret turret : land.getTurrets().values()) {
            RangedTurret ranged;
            if (!(turret instanceof RangedTurret) || !(ranged = (RangedTurret)turret).isOutOfAmmo() || RegulatorManager.refillTurret(ranged, kingdom, regulator)) continue;
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomResourcePointIncreaseTurretRefill(GroupResourcePointConvertEvent event) {
        if (!(event.getGroup() instanceof Kingdom)) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
            Kingdom kingdom = (Kingdom)event.getGroup();
            for (Land land : kingdom.getLands()) {
                Regulator regulator = land.getStructure(Regulator.class);
                if (regulator == null || !regulator.hasRule(Regulator.Rule.AUTO_FILL_TURRETS)) continue;
                RegulatorManager.refillAllTurrets(land, kingdom, regulator);
            }
        }, 1L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTurretPlaceRefill(KingdomItemPlaceEvent<?> event) {
        if (!(event.getKingdomItem() instanceof RangedTurret)) {
            return;
        }
        RangedTurret turret = (RangedTurret)event.getKingdomItem();
        Land land = turret.getLand();
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator == null) {
            return;
        }
        if (!regulator.hasRule(Regulator.Rule.AUTO_FILL_TURRETS)) {
            return;
        }
        RegulatorManager.refillTurret(turret, land.getKingdom(), regulator);
    }

    public static boolean refillTurret(RangedTurret turret, Kingdom kingdom, Regulator regulator) {
        if (kingdom.getResourcePoints().isEmpty()) {
            return false;
        }
        int maxAmmo = turret.getMaxAmmo(kingdom);
        long cost = (long)MathUtils.eval(((StructureStyle)regulator.getStyle()).getOption("auto-fill-cost").getMathExpression(), (PlaceholderProvider)new PlaceholderContextBuilder().withContext(kingdom).raw("maxAmmo", maxAmmo));
        if (!kingdom.getResourcePoints().has(cost)) {
            return false;
        }
        TurretAmmoFillEvent ammoEvent = new TurretAmmoFillEvent(turret, maxAmmo, cost, TurretAmmoFillEvent.FillType.REGULATOR, null);
        ammoEvent.getMetadata().put(Regulator.NS, (Object)regulator);
        Bukkit.getPluginManager().callEvent((Event)ammoEvent);
        if (!ammoEvent.isCancelled()) {
            kingdom.getResourcePoints().add(-cost);
            turret.setAmmo(ammoEvent.getAmount());
        }
        return true;
    }
}

