/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.structures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.KingdomsGlobals;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.type.StructureTypeOutpost;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.items.structures.OutpostPurchaseItemEvent;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InteractiveGUIManager;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.gui.OptionCategory;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.general.ItemAmountPickerGUI;
import org.kingdoms.gui.pagination.GUIPagination;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.buildings.structures.NexusManager;
import org.kingdoms.managers.buildings.structures.OutpostStock;
import org.kingdoms.utils.ItemUtil;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.config.ConfigSection;

public final class OutpostMarket {
    private final KingdomItemGUIContext<Structure> context;
    private final Player player;
    private final Kingdom kingdom;
    private int page;

    private OutpostMarket(KingdomItemGUIContext<Structure> context) {
        KingdomItemInteractEvent<Structure> event = context.getEvent();
        this.context = context;
        this.player = event.getPlayer().getPlayer();
        this.kingdom = ((Structure)event.getKingdomItem()).getLand().getKingdom();
    }

    public static InteractiveGUI open(KingdomItemGUIContext<Structure> context) {
        return new OutpostMarket(context).open();
    }

    private static long adjustStockValue(OutpostStock stock, long value) {
        long max = stock.getStockValue().getMax();
        long min = stock.getStockValue().getMin();
        return MathUtils.adjustBetween(min, value, max);
    }

    private static void changeStock(OutpostStock stock, long add) {
        if (stock.getStockValue().getInitial() == 0L) {
            return;
        }
        KingdomsGlobals.get().getStocks().compute(stock.getId(), (k, v) -> v == null ? OutpostMarket.adjustStockValue(stock, add) : OutpostMarket.adjustStockValue(stock, v + add));
    }

    private InteractiveGUI open() {
        KingdomItemInteractEvent<Structure> event = this.context.getEvent();
        KingdomPlayer kp = event.getPlayer();
        Structure outpost = (Structure)this.context.getEvent().getKingdomItem();
        Map<String, OutpostStock> stocks = OutpostStock.loadAll(outpost.getStyle());
        if (kp.hasKingdom() && !kp.hasPermission(StandardKingdomPermission.OUTPOST)) {
            StandardKingdomPermission.OUTPOST.sendDeniedMessage(this.player);
            return null;
        }
        MessagePlaceholderProvider structContext = outpost.getMessageContext();
        Object gui = new GUIBuilder("structures/outpost/" + (this.page + 1)).forPlayer(this.player).withSettings(structContext).build();
        if (gui == null) {
            return null;
        }
        int maxPages = (int)kp.getLanguage().getGUIs().keySet().stream().filter(x -> x.startsWith("structures/outpost/")).filter(x -> Pattern.compile("/\\d+$").matcher((CharSequence)x).find()).count();
        GUIPagination.paginate(gui, this.page, maxPages, newPage -> {
            this.page = newPage;
            this.open();
        });
        for (OptionCategory holder : ((InteractiveGUI)gui).getOptions("stock")) {
            OutpostStock stock;
            OptionHandler opt = holder.getOption();
            ConfigSection config = opt.getConfig();
            if (config == null || (stock = stocks.get(holder.getName())) == null) continue;
            if (!config.isSet("perform-action")) {
                int maxItemsCanBeBought;
                long passedSinceCapped;
                Long stockRemaining = KingdomsGlobals.get().getStocks().get(stock.getId());
                if (stockRemaining == null) {
                    stockRemaining = stock.getStockValue().getInitial();
                    KingdomsGlobals.get().getStocks().put(stock.getId(), stockRemaining);
                }
                structContext.raw("stock", stockRemaining);
                structContext.raw("initial", stock.getStockValue().getInitial());
                Double sellCost = stock.getSellCost() == null ? null : Double.valueOf(MathUtils.eval(stock.getSellCost(), (PlaceholderProvider)structContext));
                Double buyCost = stock.getBuyCost() == null ? null : Double.valueOf(MathUtils.eval(stock.getBuyCost(), (PlaceholderProvider)structContext));
                ItemStack item = stock.getItem();
                String itemName = ItemUtil.getName(item);
                long perItemCooldown = 0L;
                long maxCooldownCap = 0L;
                long accumulatedCooldown = 0L;
                opt.getMessageContext().raw("can_purchase", true);
                if (stock.getPurchaseLimit() != null) {
                    OutpostStock.PurchaseLimit purchaseLimit = stock.getPurchaseLimit();
                    perItemCooldown = (long)MathUtils.eval(purchaseLimit.getCooldownPerItem(), (PlaceholderProvider)structContext);
                    maxCooldownCap = (long)MathUtils.eval(purchaseLimit.getMaxCooldown(), (PlaceholderProvider)structContext);
                    accumulatedCooldown = StructureTypeOutpost.getPurchaseCooldown(this.kingdom, (StructureStyle)outpost.getStyle(), stock.getId());
                    opt.getMessageContext().raw("can_purchase", accumulatedCooldown < maxCooldownCap + perItemCooldown);
                    opt.getMessageContext().raw("max_cooldown", maxCooldownCap);
                    opt.getMessageContext().raw("cooldown_per_item", perItemCooldown);
                }
                long finalMaxCooldown = maxCooldownCap;
                long finalPerItemCooldown = perItemCooldown;
                int maxItemsDisplay = -1;
                if (stock.getPurchaseLimit() != null) {
                    long finalAccumulatedCooldown = StructureTypeOutpost.getPurchaseCooldown(this.kingdom, (StructureStyle)outpost.getStyle(), stock.getId());
                    passedSinceCapped = finalMaxCooldown - finalAccumulatedCooldown;
                    if (finalAccumulatedCooldown == 0L) {
                        maxItemsCanBeBought = 64;
                        maxItemsDisplay = (int)(passedSinceCapped / finalPerItemCooldown);
                    } else {
                        maxItemsDisplay = maxItemsCanBeBought = (int)(passedSinceCapped / finalPerItemCooldown);
                    }
                } else {
                    maxItemsCanBeBought = 64;
                    passedSinceCapped = 0L;
                }
                opt.getMessageContext().raw("item_name", itemName).raw("buy", buyCost).raw("sell", sellCost).raw("amount", item.getAmount()).raw("buy_max_items", maxItemsDisplay).raw("buy_allowed", maxItemsCanBeBought > 0).raw("buy_cooldown", finalPerItemCooldown - passedSinceCapped).raw("stock", stock);
                opt.on(Arrays.asList(ClickType.LEFT, ClickType.SHIFT_LEFT), (ctx, click) -> {
                    if (maxItemsCanBeBought <= 0) {
                        ctx.getMessageContext().raw("cooldown", finalPerItemCooldown - passedSinceCapped);
                        ctx.sendError(KingdomsLang.OUTPOST_COOLDOWN, new Object[0]);
                        return;
                    }
                    new ItemAmountPickerGUI(this.player, item.clone(), gui.getName() + '.' + holder.getName(), 1, Math.min(maxItemsCanBeBought, item.getMaxStackSize()), click.isShiftClick(), buyCost, innerGUI -> innerGUI.push("cancel", this::open, new Object[0]), newItem -> {
                        double amountedCost = buyCost * (double)newItem.getAmount();
                        if (!this.kingdom.getResourcePoints().has(amountedCost)) {
                            ctx.sendError(KingdomsLang.OUTPOST_NOT_ENOUGH_RESOURCE_POINTS, new Object[0]);
                            return;
                        }
                        OutpostPurchaseItemEvent.Purchase purchase = new OutpostPurchaseItemEvent.Purchase(holder.getName(), itemName, (ItemStack)newItem, amountedCost);
                        OutpostPurchaseItemEvent purchaseEvent = new OutpostPurchaseItemEvent((KingdomBuilding)event.getKingdomItem(), purchase, kp);
                        Bukkit.getPluginManager().callEvent((Event)purchaseEvent);
                        if (purchaseEvent.isCancelled()) {
                            return;
                        }
                        OutpostMarket.changeStock(stock, -newItem.getAmount());
                        if (stock.getPurchaseLimit() != null) {
                            StructureTypeOutpost.addPurchaseCooldown(this.kingdom, (StructureStyle)outpost.getStyle(), stock.getId(), finalPerItemCooldown * (long)purchase.getItem().getAmount());
                        }
                        this.kingdom.getResourcePoints().subtract(amountedCost);
                        XItemStack.giveOrDrop((Player)this.player, (boolean)true, (ItemStack[])new ItemStack[]{purchase.getItem()});
                        KingdomsLang.OUTPOST_PURCHASED.sendMessage((CommandSender)this.player, "amount", newItem.getAmount(), "name", itemName, "cost", amountedCost);
                        this.open();
                    }).process();
                }).on(Collections.singletonList(ClickType.RIGHT), (ctx, click) -> this.sellingGUI(item, structContext, sellCost, stock, false));
            }
            opt.done();
        }
        ((InteractiveGUI)gui).push("nexus", () -> new NexusManager(this.kingdom, event.getPlayer().getPlayer()).openNexus(), new Object[0]);
        return this.context.finalizeGUI((InteractiveGUI)gui);
    }

    private void sellingGUI(ItemStack item, MessagePlaceholderProvider structContext, Double sellCost, OutpostStock stock, boolean refreshing) {
        InventoryInteractiveGUI sellingGUI;
        String itemName = ItemUtil.getName(item);
        if (!refreshing) {
            sellingGUI = (InventoryInteractiveGUI)new GUIBuilder("structures/outpost/selling").inventoryGUIOnly().forPlayer(this.player).editMessageContext(msgCtx -> msgCtx.inheritPlaceholders(structContext).raw("item_name", itemName).raw("total_amount", 0).raw("total_resource_points", 0)).build();
        } else {
            sellingGUI = (InventoryInteractiveGUI)InteractiveGUIManager.getGuis().get(this.player.getEntityId());
            sellingGUI.resetOptions();
            ArrayList<ItemStack> accepted = new ArrayList<ItemStack>();
            for (ItemStack sellingItem : sellingGUI.getInteractableItems()) {
                if (!sellingItem.isSimilar(item)) continue;
                accepted.add(sellingItem);
            }
            long totalSold = accepted.stream().mapToLong(ItemStack::getAmount).sum();
            double amountedSell = sellCost * (double)totalSold;
            sellingGUI.getMessageContext().inheritPlaceholders(structContext).raw("item_name", itemName).raw("total_amount", totalSold).raw("total_resource_points", amountedSell);
        }
        sellingGUI.onInteractableSlot(interact -> {
            if (ItemUtil.notNull(interact.getItem()) && !item.isSimilar(interact.getItem())) {
                interact.setCancelled(true);
                KingdomsLang.OUTPOST_MISMATCHED_ITEM.sendError((CommandSender)this.player, new Object[0]);
            } else {
                Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> this.sellingGUI(item, structContext, sellCost, stock, true), 1L);
            }
        });
        sellingGUI.push("back", () -> {
            sellingGUI.returnItems();
            this.open();
        }, new Object[0]);
        AtomicBoolean refresh = new AtomicBoolean(false);
        sellingGUI.push("apply", () -> {
            ArrayList<ItemStack> accepted = new ArrayList<ItemStack>();
            ArrayList<ItemStack> rejected = new ArrayList<ItemStack>();
            for (ItemStack sellingItem : sellingGUI.getInteractableItems()) {
                if (sellingItem.isSimilar(item)) {
                    accepted.add(sellingItem);
                    continue;
                }
                rejected.add(sellingItem);
            }
            long totalSold = accepted.stream().mapToLong(ItemStack::getAmount).sum();
            double amountedSell = sellCost * (double)totalSold;
            OutpostMarket.changeStock(stock, totalSold);
            this.kingdom.getResourcePoints().add(amountedSell);
            XItemStack.giveOrDrop((Player)this.player, (boolean)true, (ItemStack[])rejected.toArray(new ItemStack[0]));
            KingdomsLang.OUTPOST_SOLD.sendMessage((CommandSender)this.player, "amount", totalSold, "name", itemName, "cost", amountedSell);
            refresh.set(true);
            this.open();
        }, new Object[0]);
        sellingGUI.onClose(() -> {
            if (!refresh.get()) {
                sellingGUI.returnItems();
            }
        });
        if (!refreshing) {
            sellingGUI.open();
        } else {
            sellingGUI.setRemainingOptions();
        }
    }
}

