/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.structures;

import java.awt.Color;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.general.others.CommandKick;
import org.kingdoms.commands.general.ranking.CommandPromote;
import org.kingdoms.commands.general.resourcepoints.CommandResourcePointsDeposit;
import org.kingdoms.commands.general.resourcepoints.CommandResourcePointsWithdraw;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.config.implementation.ConfigAccessorConfigurationSection;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.economy.DualCost;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.flag.GroupBanner;
import org.kingdoms.constants.group.flag.GroupBannerProvider;
import org.kingdoms.constants.group.flag.GroupBannerRegistry;
import org.kingdoms.constants.group.flag.MinecraftBannerGroupBanner;
import org.kingdoms.constants.group.flag.URLGroupBanner;
import org.kingdoms.constants.group.model.logs.lands.LogKingdomInvaded;
import org.kingdoms.constants.group.model.logs.misc.LogKingdomPacifismStateChange;
import org.kingdoms.constants.group.model.logs.purchases.kingdomitem.LogPurchaseStructure;
import org.kingdoms.constants.group.model.logs.purchases.kingdomitem.LogPurchaseTurret;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.upgradable.KingdomUpgrade;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.group.upgradable.Powerup;
import org.kingdoms.constants.group.upgradable.champion.ChampionUpgrade;
import org.kingdoms.constants.group.upgradable.champion.StandardChampionUpgrade;
import org.kingdoms.constants.item.KingdomItemCreateSettings;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.namespaces.DefaultTaxes;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.constants.themes.MainTheme;
import org.kingdoms.events.general.ChampionChangeEvent;
import org.kingdoms.events.general.GroupBannerChangeEvent;
import org.kingdoms.events.general.GroupResourcePointConvertEvent;
import org.kingdoms.events.general.GroupShieldPurchaseEvent;
import org.kingdoms.events.general.ranks.PlayerRankChangeContext;
import org.kingdoms.events.general.ranks.PlayerRankChangeEvent;
import org.kingdoms.events.general.ranks.RankIdentifier;
import org.kingdoms.events.general.upgrade.KingdomChampionUpgradeUpgradeEvent;
import org.kingdoms.events.general.upgrade.KingdomMiscUpgradeToggleEvent;
import org.kingdoms.events.general.upgrade.KingdomMiscUpgradeUpgradeEvent;
import org.kingdoms.events.general.upgrade.KingdomPowerupUpgradeEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InteractiveGUIManager;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionCategory;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.GUIProtectionInterrupter;
import org.kingdoms.managers.ThemeManager;
import org.kingdoms.managers.buildings.limit.BuildingLimitType;
import org.kingdoms.managers.buildings.limit.BuildingLimiter;
import org.kingdoms.managers.buildings.structures.RankEditor;
import org.kingdoms.managers.buildings.structures.SiegeManager;
import org.kingdoms.managers.land.protection.MiscUpgradeManager;
import org.kingdoms.managers.logger.LogAndStatsManager;
import org.kingdoms.managers.logger.gui.AuditLogGUI;
import org.kingdoms.managers.mails.MailUserAgent;
import org.kingdoms.managers.resourcepoints.ConvertedResourcePoints;
import org.kingdoms.managers.resourcepoints.ResourcePointManager;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.internal.XObject;
import org.kingdoms.utils.internal.enumeration.OrderedSet;
import org.kingdoms.utils.internal.numbers.Numbers;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.time.CooldownCalc;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.time.TimeUtils;

public final class NexusManager {
    private static final Cooldown<UUID> KINGDOM_FLAG_COOLDOWN = new Cooldown();
    private final Group group;
    private final Player viewer;
    private final KingdomPlayer kp;
    private final MessagePlaceholderProvider settings;
    private final Kingdom kingdom;
    private final boolean isNation;

    public NexusManager(Group group, Player viewer) {
        Nation nation;
        this.group = Objects.requireNonNull(group, "Group cannot be null");
        this.viewer = Objects.requireNonNull(viewer, "Viewer player cannot be null");
        this.kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)viewer);
        this.isNation = group instanceof Nation;
        Kingdom kingdom = this.kingdom = group instanceof Kingdom ? (Kingdom)group : null;
        Object placeholder = this.kingdom != null ? (this.kingdom.isMember((OfflinePlayer)viewer) ? viewer : (this.kingdom.hasOwner() ? Bukkit.getOfflinePlayer((UUID)this.kingdom.getKingId()) : null)) : ((nation = (Nation)group).isMember(this.kp.getKingdomId()) ? viewer : (nation.getCapital().hasOwner() ? nation.getCapital().getKing().getOfflinePlayer() : null));
        this.settings = new MessagePlaceholderProvider().withContext((OfflinePlayer)placeholder);
    }

    public static boolean admin(Player player) {
        return KingdomsDefaultPluginPermission.STRUCTURES_INTERACT.hasPermission((CommandSender)player, false);
    }

    public static void init() {
    }

    public InteractiveGUI openNexus() {
        InteractiveGUI gui = this.nexus();
        if (gui != null) {
            gui.open();
        }
        return gui;
    }

    public InteractiveGUI nexus() {
        if (!this.hasPermission(StandardKingdomPermission.NEXUS, false)) {
            StandardKingdomPermission.NEXUS.sendDeniedMessage(this.viewer);
            return null;
        }
        InteractiveGUI gui = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_NEXUS);
        if (gui == null) {
            return null;
        }
        gui.push("members", () -> this.openMembers(0), new Object[0]).push("settings", this::openSettings, new Object[0]).push("ranks", this::openRanks, new Object[0]).push("nexus-chest", this::openNexusChest, new Object[0]).push("misc-upgrades", this::openMiscUpgrades, new Object[0]).push("champion-upgrades", this::openChampionUpgrades, new Object[0]).push("structures", this::openStructures, new Object[0]).push("turrets", this::openTurrets, new Object[0]).push("resource-points", () -> this.openRp(rp -> rp.push("back", () -> {
            ((InventoryInteractiveGUI)rp).returnItems();
            this.openNexus();
        }, new Object[0])), new Object[0]);
        gui.push("mailbox", () -> {
            InteractiveGUI mailbox = MailUserAgent.getMailbox(this.viewer, this.kingdom, mailboxGUI -> mailboxGUI.push("back", this::openNexus, new Object[0]));
            if (mailbox == null) {
                return;
            }
            mailbox.open();
        }, new Object[0]);
        gui.push("logs", () -> new AuditLogGUI(this.viewer, this.kingdom, 0, logs -> {
            logs.push("back", this::openNexus, new Object[0]);
            logs.open();
        }).openGUI(), new Object[0]);
        for (Powerup powerup : Powerup.getRegistry().getRegistry().values()) {
            int maxLevel = powerup.getMaxLevel(gui.getMessageContext());
            MessagePlaceholderProvider settings = new MessagePlaceholderProvider().raw("powerup", powerup.getDisplayName());
            NexusManager.addUpgradePlaceholders(powerup, this.kingdom, settings);
            gui.option(powerup.getConfigName()).setSettings(settings).onNormalClicks(ctx -> {
                Messenger error = powerup.evaluateConditions(settings);
                if (error != null) {
                    error.sendError((CommandSender)this.viewer, new Object[0]);
                    return;
                }
                if (!this.hasPermission(StandardKingdomPermission.UPGRADE)) {
                    StandardKingdomPermission.UPGRADE.sendDeniedMessage(this.viewer);
                    return;
                }
                int lvl = this.kingdom.getUpgradeLevel(powerup);
                if (lvl >= maxLevel) {
                    ctx.sendError(KingdomsLang.UPGRADES_POWERUP_MAX, new Object[0]);
                    return;
                }
                long cost = this.kingdom.getUpgradeCost(powerup);
                if (!this.kp.isAdmin() && !this.kingdom.getResourcePoints().has(cost)) {
                    ctx.sendError(KingdomsLang.UPGRADES_POWERUP_NOT_ENOUGH_RESOURCEPOINTS, new Object[0]);
                    return;
                }
                KingdomPowerupUpgradeEvent event = new KingdomPowerupUpgradeEvent(this.kingdom, powerup, this.kp, lvl, lvl + 1, cost);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                if (!this.kp.isAdmin()) {
                    this.kingdom.getResourcePoints().add(-cost);
                }
                this.kingdom.setUpgradeLevel(powerup, event.getNewLevel());
                ctx.getMessageContext().raw("new_level", event.getNewLevel());
                ctx.sendMessage((Messenger)KingdomsLang.UPGRADES_POWERUP_UPGRADE, new Object[0]);
                this.openNexus();
            }).done();
        }
        return gui;
    }

    private InteractiveGUI prepare(KingdomsGUI gui) {
        return GUIAccessor.prepare(this.viewer, gui, this.settings);
    }

    public InteractiveGUI openTurrets() {
        if (!this.hasPermission(StandardKingdomPermission.TURRETS)) {
            StandardKingdomPermission.TURRETS.sendDeniedMessage(this.viewer);
            return null;
        }
        InteractiveGUI turrets = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_TURRETS);
        if (turrets == null) {
            return null;
        }
        turrets.push("back", this::openNexus, new Object[0]);
        PlayerInventory inv = this.viewer.getInventory();
        for (Map.Entry<String, TurretStyle> turret : TurretRegistry.get().getStyles().entrySet()) {
            TurretStyle style = turret.getValue();
            DualCost cost = style.getCost(this.kingdom);
            if (!style.hasItem()) {
                throw new IllegalStateException("Misconfigured turret '" + style.getName() + "' no 'item' option present.");
            }
            turrets.option(Strings.configOption(turret.getKey())).var("cost", cost.getResourcePoints()).var("rp", cost.getResourcePoints()).var("money", cost.getMoney()).var("turret", style.getDisplayName()).onNormalClicks(arg_0 -> this.lambda$openTurrets$33(style, (Inventory)inv, cost, arg_0)).done();
        }
        turrets.open();
        return turrets;
    }

    public InteractiveGUI openStructures() {
        if (!this.hasPermission(StandardKingdomPermission.STRUCTURES)) {
            StandardKingdomPermission.STRUCTURES.sendDeniedMessage(this.viewer);
            return null;
        }
        InteractiveGUI structures = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_STRUCTURES);
        if (structures == null) {
            return null;
        }
        structures.push("back", this::openNexus, new Object[0]);
        PlayerInventory inv = this.viewer.getInventory();
        for (StructureStyle style : StructureRegistry.get().getStyles().values()) {
            if (((StructureType)style.getType()).isNexus()) continue;
            DualCost cost = style.getCost(this.kingdom);
            if (!style.hasItem()) {
                throw new IllegalStateException("Misconfigured structure '" + style.getName() + "' no 'item' option present.");
            }
            structures.option(style.getName()).var("cost", cost.getResourcePoints()).var("rp", cost.getResourcePoints()).var("money", cost.getMoney()).var("structure", style.getDisplayName()).onNormalClicks(arg_0 -> this.lambda$openStructures$35((Inventory)inv, style, cost, arg_0)).done();
        }
        structures.open();
        return structures;
    }

    public void openNexusChest() {
        if (!this.hasPermission(StandardKingdomPermission.NEXUS_CHEST)) {
            StandardKingdomPermission.NEXUS_CHEST.sendDeniedMessage(this.viewer);
            return;
        }
        if (!this.kp.isAdmin() && this.viewer.getGameMode() == GameMode.CREATIVE && !KingdomsDefaultPluginPermission.GUIS_BYPASS_CREATIVE.hasPermission((CommandSender)this.viewer, false)) {
            KingdomsLang.GUIS_CREATIVE.sendError((CommandSender)this.viewer, new Object[0]);
            return;
        }
        if (!this.kp.isAdmin() && !this.kingdom.isMember(this.kp)) {
            KingdomsLang.NEXUS_CHEST_OTHERS.sendMessage((CommandSender)this.viewer);
            this.viewer.closeInventory();
            return;
        }
        XSound.BLOCK_CHEST_OPEN.record().soundPlayer().forPlayers(new Player[]{this.viewer}).play();
        this.viewer.openInventory(this.kingdom.getNexusChest().getOriginal());
    }

    public InventoryInteractiveGUI openRp(Consumer<InteractiveGUI> modifier) {
        return this.openRp(modifier, false);
    }

    private InventoryInteractiveGUI openRp(Consumer<InteractiveGUI> modifier, boolean refreshing) {
        Kingdom kingdom;
        InventoryInteractiveGUI rp;
        MessagePlaceholderProvider edits = new MessagePlaceholderProvider().withContext(this.viewer);
        if (!refreshing) {
            edits.raw("total_worth", 0);
            rp = (InventoryInteractiveGUI)new GUIBuilder(this.group instanceof Kingdom ? KingdomsGUI.STRUCTURES_NEXUS_RESOURCE$POINTS$CONVERTER : KingdomsGUI.STRUCTURES_NEXUS_NATION_RESOURCE$POINTS$CONVERTER).forPlayer(this.viewer).withSettings(edits).inventoryGUIOnly().build();
        } else {
            rp = (InventoryInteractiveGUI)InteractiveGUIManager.getGuis().get(this.viewer.getEntityId());
            rp.resetOptions();
            List stackedX = XItemStack.stack(rp.getInteractableItems());
            double totalWorth = ResourcePointManager.convertToResourcePoints(stackedX, null).getTotalWorth();
            rp.setMessageContext(edits.raw("total_worth", totalWorth));
        }
        if (rp == null) {
            return null;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.viewer);
        rp.onDelayedInteractableSlot(event -> this.openRp(modifier, true));
        AtomicBoolean refresh = new AtomicBoolean(false);
        rp.push("apply", () -> {
            List converted = XItemStack.stack(rp.getInteractableItems());
            ConvertedResourcePoints result = ResourcePointManager.convertToResourcePoints(converted, null);
            GroupResourcePointConvertEvent event = kp.donate(this.group, result);
            if (!event.isCancelled()) {
                double added = event.getAmount();
                Collection<ItemStack> leftOvers = event.getLeftOvers();
                this.group.getResourcePoints().add(added);
                if (leftOvers != null) {
                    XItemStack.giveOrDrop((Player)this.viewer, (boolean)true, (ItemStack[])leftOvers.toArray(new ItemStack[0]));
                }
                KingdomsLang.NEXUS_RESOURCE_POINTS.sendMessage((CommandSender)this.viewer, "amount", Numbers.toFancyNumber(added));
            }
            refresh.set(true);
            this.openRp(modifier);
        }, new Object[0]);
        Kingdom kingdom2 = kingdom = this.group instanceof Kingdom ? (Kingdom)this.group : null;
        if (kingdom != null) {
            rp.push("deposit", () -> {
                if (ServiceHandler.bankServiceNotAvailable((CommandSender)this.viewer)) {
                    return;
                }
                rp.returnItems();
                rp.clearReturnableItems();
                KingdomsLang.NEXUS_RESOURCE_POINTS_ENTER_VALUE.sendMessage((CommandSender)this.viewer);
                rp.startConversation("deposit", true);
            }, input -> {
                long amount;
                try {
                    amount = Long.parseLong(input);
                }
                catch (NumberFormatException ignored) {
                    KingdomsLang.INVALID_NUMBER.sendError((CommandSender)this.viewer, new MessagePlaceholderProvider().raws("needed", "rp", "arg", input).withContext(this.viewer));
                    return;
                }
                if (amount == 0L) {
                    KingdomsLang.COMMAND_RESOURCEPOINTS_ZERO.sendError((CommandSender)this.viewer, new Object[0]);
                    return;
                }
                if (amount < 0L) {
                    KingdomsLang.COMMAND_RESOURCEPOINTS_NEGATIVE.sendError((CommandSender)this.viewer, new Object[0]);
                    return;
                }
                if (CommandResourcePointsDeposit.handleDeposit(kp, this.viewer, kingdom, amount)) {
                    rp.endConversation();
                    this.openRp(modifier);
                }
            }, new Object[0]).push("withdraw", () -> {
                if (ServiceHandler.bankServiceNotAvailable((CommandSender)this.viewer)) {
                    return;
                }
                rp.returnItems();
                rp.clearReturnableItems();
                KingdomsLang.NEXUS_RESOURCE_POINTS_ENTER_VALUE.sendMessage((CommandSender)this.viewer);
                rp.startConversation("withdraw", true);
            }, input -> {
                long amount;
                try {
                    amount = Long.parseLong(input);
                }
                catch (NumberFormatException ignored) {
                    KingdomsLang.INVALID_NUMBER.sendError((CommandSender)this.viewer, new MessagePlaceholderProvider().raws("needed", "rp", "arg", input).withContext(this.viewer));
                    return;
                }
                if (amount == 0L) {
                    KingdomsLang.COMMAND_RESOURCEPOINTS_ZERO.sendError((CommandSender)this.viewer, new Object[0]);
                    return;
                }
                if (amount < 0L) {
                    KingdomsLang.COMMAND_RESOURCEPOINTS_NEGATIVE.sendError((CommandSender)this.viewer, new Object[0]);
                    return;
                }
                if (CommandResourcePointsWithdraw.handleWithdraw(kp, this.viewer, kingdom, amount)) {
                    rp.endConversation();
                    this.openRp(modifier);
                }
            }, new Object[0]);
        }
        rp.onClose(() -> {
            if (!refresh.get()) {
                rp.returnItems();
            }
        });
        modifier.accept(rp);
        if (!refreshing) {
            rp.open();
        } else {
            rp.setRemainingOptions();
        }
        return rp;
    }

    public InteractiveGUI openMiscUpgrades() {
        return this.openMiscUpgrades(false);
    }

    public InteractiveGUI openMiscUpgrades(boolean allowOpeningOthers) {
        if (!NexusManager.admin(this.viewer)) {
            if (!allowOpeningOthers && !this.kingdom.isMember(this.kp)) {
                KingdomsLang.NEXUS_MISC_UPGRADES_OTHERS.sendError((CommandSender)this.viewer, new Object[0]);
                this.viewer.closeInventory();
                return null;
            }
            if (!this.hasPermission(StandardKingdomPermission.UPGRADE)) {
                StandardKingdomPermission.UPGRADE.sendDeniedMessage(this.viewer);
                this.viewer.closeInventory();
                return null;
            }
        }
        InteractiveGUI misc = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_MISC$UPGRADES);
        misc.push("back", this::openNexus, new Object[0]);
        for (MiscUpgrade upgrade : MiscUpgrade.getRegistry().getRegistry().values()) {
            Messenger name = upgrade.getDisplayName();
            int upgradeLevel = this.kingdom.getMiscUpgrades().getOrDefault(upgrade.getNamespace(), 0);
            long cost = Math.abs(this.kingdom.getUpgradeCost(upgrade));
            int usedInvasions = MiscUpgradeManager.getInvasionCooldown().getOrDefault(this.kingdom.getId(), 0);
            int totalInvasions = (int)MiscUpgrade.INVASIONS.getScaling(this.kingdom);
            String option = upgrade.getNamespace().getConfigOptionName();
            OptionHandler optionHandle = misc.option(option);
            MessagePlaceholderProvider ctx = optionHandle.getMessageContext().withContext(this.kingdom);
            NexusManager.addUpgradePlaceholders(upgrade, this.kingdom, ctx);
            ctx.raws("enabled", upgradeLevel >= 0, "toggle", false, "invasions", usedInvasions, "invasion-limit", totalInvasions, "max_turrets_per_land", BuildingLimiter.ofTurrets(this.kingdom).getLimit(BuildingLimitType.TOTAL), "invasion-refresh-cooldown", TimeFormatter.of(MiscUpgradeManager.getInvadeRefreshCd(this.kingdom)));
            optionHandle.on(ClickType.LEFT, () -> {
                Messenger error;
                if (!this.kp.isAdmin() && (error = upgrade.evaluateConditions(ctx)) != null) {
                    error.sendError((CommandSender)this.viewer, new Object[0]);
                    return;
                }
                int lvl = this.kingdom.getMiscUpgrades().getOrDefault(upgrade.getNamespace(), 0);
                if (lvl < 0) {
                    KingdomMiscUpgradeToggleEvent event = new KingdomMiscUpgradeToggleEvent(this.kingdom, upgrade, this.kp, true);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    KingdomsLang.UPGRADES_MISC_ENABLED.sendMessage((CommandSender)this.viewer, "upgrade", name, "level", lvl + 1, "cost", cost);
                    this.kingdom.getMiscUpgrades().put(upgrade.getNamespace(), (Integer)(-lvl));
                    this.openMiscUpgrades();
                    return;
                }
                if (lvl >= upgrade.getMaxLevel(ctx)) {
                    KingdomsLang.UPGRADES_MISC_MAX.sendError((CommandSender)this.viewer, "upgrade", name);
                    return;
                }
                if (!this.kp.isAdmin() && !this.kingdom.getResourcePoints().has(cost)) {
                    KingdomsLang.UPGRADES_MISC_NOT_ENOUGH_RESOURCEPOINTS.sendError((CommandSender)this.viewer, "upgrade", name, "level", lvl + 1, "cost", cost);
                    return;
                }
                KingdomMiscUpgradeUpgradeEvent event = new KingdomMiscUpgradeUpgradeEvent(this.kingdom, upgrade, this.kp, lvl, lvl + 1, cost);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                if (!this.kp.isAdmin()) {
                    this.kingdom.getResourcePoints().add(-cost);
                }
                int newLevel = event.getNewLevel();
                upgrade.executeCommands(ctx, newLevel);
                this.kingdom.setUpgradeLevel(upgrade, newLevel);
                KingdomsLang.UPGRADES_MISC_UPGRADE.sendMessage((CommandSender)this.viewer, "upgrade", name, "level", lvl, "new_level", newLevel, "cost", cost);
                if (upgrade == MiscUpgrade.CHEST_SIZE) {
                    this.kingdom.updateChest();
                }
                this.openMiscUpgrades();
            }).on(ClickType.RIGHT, () -> {
                int lvl = this.kingdom.getMiscUpgrades().getOrDefault(upgrade.getNamespace(), 0);
                if (!upgrade.canBeDisabled()) {
                    KingdomsLang.UPGRADES_MISC_CANNOT_BE_DISABLED.sendMessage((CommandSender)this.viewer, "upgrade", upgrade.toString(), "level", 0, "cost", cost);
                    return;
                }
                if (lvl == 0) {
                    KingdomsLang.UPGRADES_MISC_NOT_UPGRADED.sendMessage((CommandSender)this.viewer, "upgrade", name, "level", 0, "cost", cost);
                    return;
                }
                boolean willBeEnabled = lvl < 0;
                KingdomMiscUpgradeToggleEvent event = new KingdomMiscUpgradeToggleEvent(this.kingdom, upgrade, this.kp, willBeEnabled);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                (willBeEnabled ? KingdomsLang.UPGRADES_MISC_ENABLED : KingdomsLang.UPGRADES_MISC_DISABLED).sendMessage((CommandSender)this.viewer, "upgrade", name, "level", lvl + 1, "cost", cost);
                upgrade.executeCommands(ctx.raw("enabled", willBeEnabled).raw("toggle", true), Math.abs(lvl));
                this.kingdom.getMiscUpgrades().put(upgrade.getNamespace(), (Integer)(-lvl));
                this.openMiscUpgrades();
            }).done();
        }
        misc.open();
        return misc;
    }

    private static void addUpgradePlaceholders(KingdomUpgrade upgrade, Kingdom kingdom, PlaceholderContextBuilder settings) {
        Messenger name = upgrade.getDisplayName();
        int lvl = kingdom.getUpgradeLevel(upgrade);
        long cost = kingdom.getUpgradeCost(upgrade);
        String scaling = upgrade instanceof Powerup ? "Context Based Scaling" : Numbers.toFancyNumber(upgrade.getScaling(kingdom));
        settings.raw("upgrade", name).raw("name", name).raw("level", Math.abs(lvl)).raw("lvl", Math.abs(lvl)).raw("cost", cost).raw("scaling", scaling);
        int maxLevel = upgrade.getMaxLevel(settings);
        settings.raw("max_level", maxLevel).raw("maxxed", Math.abs(lvl) >= maxLevel);
    }

    public InteractiveGUI openChampionUpgrades() {
        if (!this.hasPermission(StandardKingdomPermission.UPGRADE)) {
            StandardKingdomPermission.UPGRADE.sendDeniedMessage(this.viewer);
            return null;
        }
        InteractiveGUI champion = GUIAccessor.prepare(this.viewer, this.kp.getOfflinePlayer(), "structures/nexus/champion-upgrades", new Object[0]);
        if (champion == null) {
            return null;
        }
        champion.push("back", this::openNexus, new Object[0]);
        for (ChampionUpgrade upgrade : StandardChampionUpgrade.getRegistry().getRegistry().values()) {
            if (upgrade == StandardChampionUpgrade.EQUIPMENT) continue;
            int lvl = this.kingdom.getUpgradeLevel(upgrade);
            long cost = this.kingdom.getUpgradeCost(upgrade);
            String option = upgrade.getConfigName();
            MessagePlaceholderProvider settings = new MessagePlaceholderProvider().viewer(this.kp).withContext(this.kingdom);
            NexusManager.addUpgradePlaceholders(upgrade, this.kingdom, settings);
            Duration cooldown = upgrade.getOption("cooldown").getTime(settings);
            if (cooldown != null) {
                settings.raw("cooldown", TimeFormatter.of(cooldown));
            }
            settings.addChild("upgrade", placeholder -> {
                KeyedYamlConfigAccessor upgradeOpt = upgrade.getOption(Strings.configOption(placeholder));
                if (upgradeOpt == null) {
                    return null;
                }
                MathExpression math = upgradeOpt.getMathExpression();
                if (math.isDefault()) {
                    return null;
                }
                return MathUtils.eval(math, (PlaceholderProvider)new PlaceholderContextBuilder().raw("lvl", lvl));
            });
            champion.option(option).setSettings(settings).onNormalClicks(ctx -> {
                Messenger error;
                if (!this.kp.isAdmin() && (error = upgrade.evaluateConditions(settings)) != null) {
                    error.sendError((CommandSender)this.viewer, new Object[0]);
                    return;
                }
                if (this.kingdom.getUpgradeLevel(upgrade) >= upgrade.getMaxLevel(null)) {
                    ctx.sendError(KingdomsLang.UPGRADES_CHAMPION_MAX, new Object[0]);
                    return;
                }
                if (!this.kp.isAdmin() && !this.kingdom.getResourcePoints().has(cost)) {
                    ctx.sendError(KingdomsLang.UPGRADES_CHAMPION_NOT_ENOUGH_RESOURCEPOINTS, new Object[0]);
                    return;
                }
                KingdomChampionUpgradeUpgradeEvent event = new KingdomChampionUpgradeUpgradeEvent(this.kingdom, upgrade, this.kp, lvl, lvl + 1, cost);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                int newLevel = event.getNewLevel();
                if (!this.kp.isAdmin()) {
                    this.kingdom.getResourcePoints().add(-cost);
                }
                this.kingdom.setUpgradeLevel(upgrade, newLevel);
                ctx.getMessageContext().raw("new_level", event.getNewLevel());
                ctx.sendMessage((Messenger)KingdomsLang.UPGRADES_CHAMPION_UPGRADE, new Object[0]);
                this.openChampionUpgrades();
            }).done();
        }
        champion.push("settings", this::openChampionSettings, new Object[0]);
        champion.open();
        return champion;
    }

    public InteractiveGUI openRanks() {
        if (!this.hasPermission(StandardKingdomPermission.EDIT_RANKS)) {
            StandardKingdomPermission.EDIT_RANKS.sendDeniedMessage(this.viewer);
            return null;
        }
        if (!this.kp.isAdmin() && !this.kingdom.isMember(this.kp)) {
            KingdomsLang.NEXUS_RANK_EDITOR_OTHER.sendMessage((CommandSender)this.viewer);
            this.viewer.closeInventory();
            return null;
        }
        return RankEditor.openRanks(KingdomsGUI.STRUCTURES_NEXUS_RANKS_RANKS, this.viewer, this.kp, this.kingdom, gui -> gui.push("back", this::openNexus, new Object[0]));
    }

    public InteractiveGUI openChampionSettings() {
        InteractiveGUI champion = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_CHAMPION$SETTINGS);
        if (champion == null) {
            return null;
        }
        champion.push("back", this::openChampionUpgrades, new Object[0]);
        ConfigAccessor championConfig = this.kingdom.findChampionSection();
        KingdomsLang name = KingdomsLang.UPGRADES_CHAMPION_EQUIPMENT_NAME;
        int maxLevel = championConfig.getInt("max-level");
        StandardChampionUpgrade upgrade = StandardChampionUpgrade.EQUIPMENT;
        int lvl = this.kingdom.getUpgradeLevel(upgrade);
        long cost = (long)MathUtils.eval(championConfig.getString("cost"), this.kingdom, "lvl", lvl);
        champion.push("change", this::openChampionTypes, new Object[0]).push("upgrade", () -> {
            ConfigSection sounds = champion.getOptionsSection().getSection("upgrade", "sounds");
            if (this.kingdom.getUpgradeLevel(upgrade) >= maxLevel) {
                KingdomsLang.UPGRADES_CHAMPION_MAX.sendMessage((CommandSender)this.viewer, "upgrade", name, "level", lvl + 1, "cost", cost);
                if (sounds != null) {
                    XSound.play((String)sounds.getString("max-level"), x -> x.forPlayers(new Player[]{this.viewer}));
                }
                return;
            }
            if (!this.kingdom.getResourcePoints().has(cost)) {
                KingdomsLang.UPGRADES_CHAMPION_NOT_ENOUGH_RESOURCEPOINTS.sendMessage((CommandSender)this.viewer, "upgrade", name, "level", lvl + 1, "cost", cost);
                if (sounds != null) {
                    XSound.play((String)sounds.getString("not-enough-resource-points"), x -> x.forPlayers(new Player[]{this.viewer}));
                }
            }
            KingdomChampionUpgradeUpgradeEvent event = new KingdomChampionUpgradeUpgradeEvent(this.kingdom, upgrade, this.kp, lvl, lvl + 1, cost);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            long finalCost = event.getResourcePointsCost();
            int newLevel = event.getNewLevel();
            if (this.kingdom.getResourcePoints().has(finalCost)) {
                this.kingdom.setUpgradeLevel(upgrade, newLevel);
                this.kingdom.getResourcePoints().add(-finalCost);
                if (sounds != null) {
                    XSound.play((String)sounds.getString("upgraded"), x -> x.forPlayers(new Player[]{this.viewer}));
                }
                KingdomsLang.UPGRADES_CHAMPION_UPGRADE.sendMessage((CommandSender)this.viewer, "upgrade", name, "new_level", newLevel, "cost", finalCost);
                this.openChampionSettings();
            } else {
                KingdomsLang.UPGRADES_CHAMPION_NOT_ENOUGH_RESOURCEPOINTS.sendMessage((CommandSender)this.viewer, "upgrade", name, "level", newLevel, "cost", finalCost);
                if (sounds != null) {
                    XSound.play((String)sounds.getString("not-enough-resource-points"), x -> x.forPlayers(new Player[]{this.viewer}));
                }
            }
        }, "level", lvl, "cost", cost);
        champion.open();
        return champion;
    }

    public InteractiveGUI openChampionTypes() {
        InteractiveGUI gui = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_CHAMPIONS);
        if (gui == null) {
            return null;
        }
        gui.push("back", this::openChampionSettings, new Object[0]);
        ConfigAccessorConfigurationSection config = KingdomsConfig.CHAMPION_UPGRADES.accessor().gotoSection("champions").toBukkitConfigurationSection();
        for (String champion : config.getKeys(false)) {
            if (champion.equalsIgnoreCase("default")) continue;
            gui.push(champion, () -> {
                if (this.kingdom.getChampionType().equals(champion)) {
                    KingdomsLang.CHAMPION_TYPE_ALREADY_IN_USE.sendMessage((CommandSender)this.viewer, "champion", champion);
                    this.viewer.closeInventory();
                } else {
                    ChampionChangeEvent champChange = new ChampionChangeEvent(this.kingdom, this.kingdom.getChampionType(), champion, this.kp);
                    Bukkit.getPluginManager().callEvent((Event)champChange);
                    if (champChange.isCancelled()) {
                        return;
                    }
                    String newChamp = champChange.getNewType();
                    for (Player member : this.kingdom.getOnlineMembers()) {
                        KingdomsLang.CHAMPION_TYPE_CHANGED.sendMessage((CommandSender)member, "old_champion", this.kingdom.getChampionType(), "new_champion", newChamp);
                    }
                    this.kingdom.setChampionType(newChamp);
                    this.openChampionSettings();
                }
            }, new Object[0]);
        }
        gui.open();
        return gui;
    }

    public InteractiveGUI openSettings() {
        if (this.kingdom != null && this.kingdom.isBeingInvaded()) {
            KingdomsLang.GUIS_CANT_OPEN_DURING_INVASION.sendError((CommandSender)this.viewer, new Object[0]);
            return null;
        }
        long pacifismCooldown = this.getPacifismCooldown();
        MessageObjectBuilder pacifismCooldownDisplay = TimeFormatter.of(pacifismCooldown);
        KingdomsGUI guiPath = this.group instanceof Nation ? KingdomsGUI.STRUCTURES_NEXUS_NATION_SETTINGS_SETTINGS : KingdomsGUI.STRUCTURES_NEXUS_SETTINGS_SETTINGS;
        StructureStyle nexus = StructureRegistry.get().getStyle("nexus");
        int maxLevel = nexus.getMaxLevel(this.settings);
        InteractiveGUI gui = GUIAccessor.prepare(this.viewer, guiPath, this.settings.clone().raws("tax_equation", XObject.firstNotNull(this.group.getTaxes().get(DefaultTaxes.MAIN), KingdomsConfig.TAX_KINGDOMS_MEMBERS_DEFAULT_EQUATION.getString()), "pacifism_cooldown", pacifismCooldownDisplay, "pacifism_left", pacifismCooldown, "public_home", this.group.isHomePublic(), "level", this.group.getLevel(), "next_level", this.group.getLevel() + 1, "max_level", maxLevel, "upgrade_cost", nexus.getUpgradeCost(this.settings.clone().raw("level", this.group.getLevel()))).placeholders("pacifism", this.kingdom == null ? null : (this.kingdom.isPacifist() ? "&aEnabled" : "&cDisabled"), "invites", this.group.requiresInvite() ? "&aEnabled" : "&cDisabled"));
        if (gui == null) {
            return null;
        }
        boolean hasSettingsPermission = this.hasSettingsPermission();
        Color kColor = this.group.getThemes().get(MainTheme.INSTANCE);
        if (kColor == null) {
            kColor = Color.BLACK;
        }
        Object[] colorEdits = new Object[]{"r", kColor.getRed(), "b", kColor.getBlue(), "g", kColor.getGreen()};
        gui.push("back", () -> {
            if (this.group instanceof Nation) {
                this.nationalNexus();
            } else {
                this.openNexus();
            }
        }, new Object[0]);
        gui.option("public-home").on(ClickType.LEFT, () -> {
            if (!hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.viewer);
                return;
            }
            this.group.setPublicHome(!this.group.isHomePublic());
            KingdomsLang lang = this.group.isHomePublic() ? KingdomsLang.NEXUS_HOME_PUBLIC : KingdomsLang.NEXUS_HOME_NOT_PUBLIC;
            lang.sendMessage((CommandSender)this.viewer);
            this.openSettings();
        }).on(ClickType.RIGHT, ctx -> {
            if (!hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.viewer);
                return;
            }
            ctx.converse(answer -> {
                double amount;
                MathCompiler.Expression tax;
                double money = ServiceVault.getMoney((OfflinePlayer)this.viewer);
                try {
                    tax = MathCompiler.compile(answer);
                    amount = MathUtils.eval(tax, (PlaceholderProvider)new PlaceholderContextBuilder().withContext(this.viewer).raw("money", money));
                }
                catch (Exception ex) {
                    KingdomsLang.NEXUS_SETTINGS_TAX_INVALID.sendMessage((CommandSender)this.viewer, "tax", answer, "reason", ex);
                    return;
                }
                ctx.endConversation();
                this.group.setTax(DefaultTaxes.PUBLIC_HOME, tax);
                KingdomsLang.NEXUS_SETTINGS_TAX_SET.sendMessage((CommandSender)this.viewer, "tax", tax, "test", amount);
                this.openSettings();
            });
        }).done();
        gui.push("upgrade", () -> {
            long upgradeCost = (long)nexus.getUpgradeCost(gui.getMessageContext());
            int oldLvl = this.group.getLevel();
            int newLvl = oldLvl + 1;
            Player player = this.kp.getPlayer();
            if (this.group.getLevel() >= maxLevel) {
                KingdomsLang.KINGDOM_UPGRADE_MAX_LEVEL.sendMessage((CommandSender)player);
                return;
            }
            if (!this.kp.isAdmin()) {
                if (!this.hasPermission(StandardKingdomPermission.UPGRADE)) {
                    StandardKingdomPermission.UPGRADE.sendDeniedMessage(player);
                    return;
                }
                if (!this.kingdom.getResourcePoints().has(upgradeCost)) {
                    KingdomsLang.KINGDOM_UPGRADE_NOT_ENOUGH_RESOURCE_POINTS.sendError((CommandSender)player, gui.getMessageContext());
                    return;
                }
                this.kingdom.getResourcePoints().add(-upgradeCost);
            }
            this.kingdom.changeLevel(newLvl, player);
            KingdomsLang.KINGDOM_UPGRADE_UPGRADED.sendMessage((CommandSender)player, gui.getMessageContext());
            player.closeInventory();
        }, new Object[0]).push("pacifism", () -> {
            if (!hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.viewer);
                return;
            }
            if (!this.kp.isAdmin() && pacifismCooldown > 0L) {
                KingdomsLang.NEXUS_PACIFISM_COOLDOWN.sendMessage((CommandSender)this.viewer, "cooldown", pacifismCooldownDisplay);
                return;
            }
            if (this.kingdom.setPacifist(!this.kingdom.isPacifist(), this.kp, null).isCancelled()) {
                return;
            }
            KingdomsLang lang = this.kingdom.isPacifist() ? KingdomsLang.NEXUS_PACIFISM_ENABLE : KingdomsLang.NEXUS_PACIFISM_DISABLE;
            lang.sendMessage((CommandSender)this.viewer);
            this.openSettings();
        }, new Object[0]).push("hidden", () -> {
            if (!hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.viewer);
                return;
            }
            if (this.group.setHidden(!this.group.isHidden(), this.kp).isCancelled()) {
                return;
            }
            KingdomsLang lang = this.group.isHidden() ? KingdomsLang.NEXUS_HIDDEN_ENABLED : KingdomsLang.NEXUS_HIDDEN_DISABLED;
            lang.sendMessage((CommandSender)this.viewer);
            this.openSettings();
        }, new Object[0]).push("invites", () -> {
            if (!hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.viewer);
                return;
            }
            this.group.setRequiresInvite(!this.group.requiresInvite());
            KingdomsLang lang = this.group.requiresInvite() ? KingdomsLang.NEXUS_INVITES_ENABLE : KingdomsLang.NEXUS_INVITES_DISABLE;
            lang.sendMessage((CommandSender)this.viewer);
            this.openSettings();
        }, new Object[0]).push("relations", () -> this.openRelations(innerGUI -> innerGUI.push("back", this::openSettings, new Object[0])), new Object[0]).push("tax", () -> {
            if (ServiceHandler.bankServiceNotAvailable((CommandSender)this.viewer)) {
                return;
            }
            if (!hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.viewer);
                return;
            }
            KingdomsLang.NEXUS_SETTINGS_TAX_ENTER_VALUE.sendMessage((CommandSender)this.viewer);
            gui.startConversation("tax");
        }, tax -> {
            double amount;
            double money = ServiceVault.getMoney((OfflinePlayer)this.viewer);
            int illegalIndex = Strings.indexOfAny(tax, new String[]{"kingdoms_tax", "kingdoms_fancy_tax", "kingdoms_short_tax"});
            if (illegalIndex != -1) {
                KingdomsLang.NEXUS_SETTINGS_TAX_ILLEGAL_VARIABLE.sendMessage((CommandSender)this.viewer, "tax", tax, "index", illegalIndex);
                return;
            }
            try {
                amount = MathUtils.eval(tax, (OfflinePlayer)this.viewer, "money", money);
            }
            catch (Exception ex) {
                KingdomsLang.NEXUS_SETTINGS_TAX_INVALID.sendMessage((CommandSender)this.viewer, "tax", tax, "reason", ex.getMessage());
                return;
            }
            KingdomsLang.NEXUS_SETTINGS_TAX_SET.sendMessage((CommandSender)this.viewer, "tax", tax, "test", amount);
            this.group.setTax(DefaultTaxes.MAIN, MathCompiler.compile(tax));
            gui.endConversation();
            this.openSettings();
        }, new Object[0]).push("banners", () -> this.openBanners(x -> x.push("back", this::openSettings, new Object[0])), new Object[0]).push("color", () -> {
            if (!hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.viewer);
                return;
            }
            new ThemeManager(this.viewer, this.group).setHandlers(innerGUI -> innerGUI.push("back", this::openSettings, new Object[0])).groupColorTypes();
        }, colorEdits).push("shields", this::openShields, new Object[0]);
        gui.open();
        return gui;
    }

    private boolean hasSettingsPermission() {
        return this.hasPermission(StandardKingdomPermission.SETTINGS);
    }

    private boolean hasPermission(StandardKingdomPermission permission) {
        return this.hasPermission(permission, true);
    }

    private boolean hasPermission(StandardKingdomPermission permission, boolean sameOriginPolicy) {
        return NexusManager.hasPermission(permission, this.kp, this.group, sameOriginPolicy);
    }

    public static boolean hasPermission(StandardKingdomPermission permission, KingdomPlayer kp, Group group, boolean sameOriginPolicy) {
        return NexusManager.admin(kp.getPlayer()) || (group instanceof Nation ? (!sameOriginPolicy || kp.getKingdom().getNationId().equals(group.getId())) && kp.hasNationPermission(permission) : (!sameOriginPolicy || kp.getKingdomId().equals(group.getId())) && kp.hasPermission(permission));
    }

    private long getPacifismCooldown() {
        CooldownCalc cd;
        if (this.kingdom == null) {
            return 0L;
        }
        LogKingdomPacifismStateChange lastPacifismChange = this.kingdom.getNewestLog(LogKingdomPacifismStateChange.class);
        if (lastPacifismChange != null && (cd = new CooldownCalc().cooldown(KingdomsConfig.Invasions.PACIFISM_COOLDOWNS_GENERAL.getManager().getTime(this.settings)).eventOccurrenceTime(lastPacifismChange.getTime())).isInCooldown()) {
            return cd.getTimeRemaining();
        }
        CooldownCalc cd2 = new CooldownCalc().cooldown(KingdomsConfig.Invasions.PACIFISM_COOLDOWNS_AFTER_INVASION.getManager().getTime(this.settings)).eventOccurrenceTime(this.kingdom.getLastInvasion());
        if (cd2.isInCooldown()) {
            return cd2.getTimeRemaining();
        }
        return 0L;
    }

    public InteractiveGUI openShields() {
        if (!this.hasPermission(StandardKingdomPermission.UPGRADE)) {
            StandardKingdomPermission.UPGRADE.sendDeniedMessage(this.viewer);
            return null;
        }
        Object shields = new GUIBuilder("structures/nexus/" + (this.group instanceof Nation ? "nation/" : "") + "settings/shields").forPlayer(this.viewer).withSettings(new MessagePlaceholderProvider().withContext(this.group)).build();
        MathExpression refundEqn = KingdomsConfig.Invasions.SHIELDS_REFUND.getManager().getMathExpression();
        double refund = !this.group.getShield().hasShield() ? 0.0 : MathUtils.eval(refundEqn, (PlaceholderProvider)new PlaceholderContextBuilder().withContext(this.group).raw("time_left", this.group.getShield().getTimeLeft()));
        ((InteractiveGUI)shields).push("refund", () -> {
            if (!this.group.getShield().hasShield()) {
                KingdomsLang.NEXUS_SETTINGS_SHIELD_NOTHING_TO_REFUND.sendMessage((CommandSender)this.viewer);
                return;
            }
            this.group.getShield().deactivate();
            this.group.getResourcePoints().add(refund);
            KingdomsLang.NEXUS_SETTINGS_SHIELD_REFUNDED.sendMessage((CommandSender)this.viewer, "rp", refund);
            this.openShields();
        }, "refund", refund);
        for (OptionCategory holder : ((InteractiveGUI)shields).getOptions("shield")) {
            ConfigSection shield = holder.getOption().getConfig();
            long cost = (long)MathUtils.eval(shield.getMathExpression("cost"), (PlaceholderProvider)((InteractiveGUI)shields).getMessageContext());
            Long time = TimeUtils.parseTime(shield.getString("time"));
            if (time == null) continue;
            holder.getOption().setEdits("cost", Numbers.toFancyNumber(cost)).onNormalClicks(() -> {
                if (!this.group.getResourcePoints().has(cost)) {
                    KingdomsLang.NEXUS_SETTINGS_SHIELD_NOT_ENOUGH_RESOURCE_POINTS.sendMessage((CommandSender)this.viewer);
                    return;
                }
                if (this.kingdom != null) {
                    long passedSinceTheHit;
                    long passedSinceTheInvade;
                    long passedSinceTheLastInvasion;
                    YamlConfigAccessor extraConditions = KingdomsConfig.Invasions.SHIELDS_EXTRA_DENY_CONDITIONS.getManager().getSection();
                    Messenger result = ConditionProcessor.mapConditions(extraConditions.getSection()).evaluate(new PlaceholderContextBuilder().withContext(this.kingdom), true);
                    if (result != null) {
                        result.sendError((CommandSender)this.viewer, new MessagePlaceholderProvider().withContext(this.kingdom));
                        return;
                    }
                    long cooldown = KingdomsConfig.Invasions.SHIELDS_PURCHASE_COOLDOWN_LAST_INVASION_ATTACKED.getManager().getTimeMillis();
                    if (cooldown > 0L && (passedSinceTheLastInvasion = System.currentTimeMillis() - this.kingdom.getLastInvasion()) < cooldown) {
                        KingdomsLang.NEXUS_SETTINGS_SHIELD_COOLDOWN_INVASIONS_ATTACKED.sendError((CommandSender)this.viewer, "time", TimeFormatter.of(cooldown - passedSinceTheLastInvasion), "last", TimeFormatter.of(passedSinceTheLastInvasion));
                        return;
                    }
                    Long wasInvaded = this.kingdom.getNewestLog(LogKingdomInvaded.class, x -> x.getResult().isSuccessful() ? Long.valueOf(x.getTime()) : null);
                    long invadeCooldown = KingdomsConfig.Invasions.SHIELDS_PURCHASE_COOLDOWN_LAST_INVASION_DEFENDED.getManager().getTimeMillis();
                    if (wasInvaded != null && invadeCooldown > 0L && (passedSinceTheInvade = System.currentTimeMillis() - wasInvaded) < invadeCooldown) {
                        KingdomsLang.NEXUS_SETTINGS_SHIELD_COOLDOWN_INVASIONS_DEFENDED.sendError((CommandSender)this.viewer, "time", TimeFormatter.of(invadeCooldown - passedSinceTheInvade), "last", TimeFormatter.of(passedSinceTheInvade));
                        return;
                    }
                    long siegeHitCd = KingdomsConfig.Invasions.SHIELDS_PURCHASE_COOLDOWN_LAST_SIEGE_CANNON_HIT.getManager().getTimeMillis();
                    long lastSiegeHit = SiegeManager.SIEGE_LAST_ATTACK.getTimeLeft(this.kingdom.getId());
                    if (siegeHitCd > 0L && lastSiegeHit > 0L && (passedSinceTheHit = System.currentTimeMillis() - lastSiegeHit) < siegeHitCd) {
                        KingdomsLang.NEXUS_SETTINGS_SHIELD_COOLDOWN_SIEGE_CANNON.sendError((CommandSender)this.viewer, "time", TimeFormatter.of(siegeHitCd - passedSinceTheHit), "last", TimeFormatter.of(passedSinceTheHit));
                        return;
                    }
                }
                GroupShieldPurchaseEvent event = new GroupShieldPurchaseEvent(this.group, this.kp, time, cost);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                this.group.getResourcePoints().add(-event.getResourcePointsCost());
                this.group.getShield().addDuration(Duration.ofMillis(event.getShieldDuration()));
                KingdomsLang.NEXUS_SETTINGS_SHIELD_ACTIVATED.sendMessage((CommandSender)this.viewer);
                this.openShields();
            }).done();
        }
        ((InteractiveGUI)shields).option("back").onNormalClicks(this::openSettings).done();
        ((InteractiveGUI)shields).open();
        return shields;
    }

    public InteractiveGUI openBanners(Consumer<InteractiveGUI> editor) {
        if (!this.hasSettingsPermission()) {
            StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.viewer);
            return null;
        }
        Object gui = new GUIBuilder(this.isNation ? KingdomsGUI.STRUCTURES_NEXUS_NATION_SETTINGS_BANNERS : KingdomsGUI.STRUCTURES_NEXUS_SETTINGS_BANNERS).forPlayer(this.viewer).withSettings(new MessagePlaceholderProvider().withContext(this.kp.getOfflinePlayer())).build();
        if (gui == null) {
            return null;
        }
        ((InteractiveGUI)gui).option("flag").editMessageContext(ctx -> ctx.raw("banner_description", this.group.getFlag() == null ? KingdomsLang.NONE : this.group.getFlag().description())).on(ClickType.LEFT, () -> {
            long flagCd;
            if (!this.kp.isAdmin() && (flagCd = KINGDOM_FLAG_COOLDOWN.getTimeLeft(this.group.getId())) != 0L) {
                KingdomsLang.NEXUS_SETTINGS_FLAG_COOLDOWN.sendMessage((CommandSender)this.viewer, "cooldown", TimeFormatter.of(flagCd));
                return;
            }
            GroupBannerRegistry.INSTANCE.getRegistered(URLGroupBanner.PROVIDER).prompt(this.viewer).thenAccept(flag -> Kingdoms.taskScheduler().run(TaskThreadType.SYNC, () -> {
                GroupBanner finalFlag = flag;
                GroupBannerChangeEvent event = this.group.setFlag(finalFlag, this.kp);
                if (event.isCancelled()) {
                    return;
                }
                finalFlag = event.getNewBanner();
                KINGDOM_FLAG_COOLDOWN.add(this.group.getId(), KingdomsConfig.FLAG_COOLDOWN.getManager().getTimeMillis());
                KingdomsLang.NEXUS_SETTINGS_FLAG_SET.sendMessage((CommandSender)this.viewer, "flag", finalFlag.description());
                this.openBanners(editor);
            }));
        }).on(ClickType.RIGHT, () -> {
            KingdomsLang.NEXUS_SETTINGS_FLAG_REMOVED.sendMessage((CommandSender)this.viewer);
            this.group.setFlag(null, this.kp);
            this.openBanners(editor);
        }).done();
        ((InteractiveGUI)gui).option("banner").editMessageContext(ctx -> ctx.raw("banner_description", this.group.getBanner() == null ? KingdomsLang.NONE : this.group.getBanner().description())).on(ClickType.LEFT, () -> ((GroupBannerProvider)GroupBannerRegistry.INSTANCE.getRegistered(MinecraftBannerGroupBanner.PROVIDER)).prompt(this.viewer).thenAccept(flag -> Kingdoms.taskScheduler().run(TaskThreadType.SYNC, () -> {
            GroupBanner finalBanner = flag;
            GroupBannerChangeEvent event = this.group.setBanner(finalBanner, this.kp);
            if (event.isCancelled()) {
                return;
            }
            finalBanner = event.getNewBanner();
            KingdomsLang.NEXUS_SETTINGS_BANNER_SET.sendMessage((CommandSender)this.viewer, "banner", finalBanner);
            this.openBanners(editor);
        }))).on(ClickType.RIGHT, () -> {
            KingdomsLang.NEXUS_SETTINGS_BANNER_REMOVED.sendMessage((CommandSender)this.viewer);
            this.group.setBanner(null, this.kp);
            this.openBanners(editor);
        }).done();
        editor.accept((InteractiveGUI)gui);
        ((InteractiveGUI)gui).open();
        return gui;
    }

    public InteractiveGUI openRelations(Consumer<InteractiveGUI> editor) {
        if (!this.hasPermission(StandardKingdomPermission.RELATION_ATTRIBUTES)) {
            StandardKingdomPermission.RELATION_ATTRIBUTES.sendDeniedMessage(this.viewer);
            return null;
        }
        Object gui = new GUIBuilder(this.isNation ? KingdomsGUI.STRUCTURES_NEXUS_NATION_SETTINGS_RELATIONS : KingdomsGUI.STRUCTURES_NEXUS_SETTINGS_RELATIONS).forPlayer(this.viewer).withSettings(new MessagePlaceholderProvider().withContext(this.kp.getOfflinePlayer())).build();
        if (gui == null) {
            return null;
        }
        for (KingdomRelation relation : KingdomRelation.values()) {
            String holder = relation.name().toLowerCase(Locale.ENGLISH);
            ((InteractiveGUI)gui).push(holder, () -> this.openRelationEditor(relation, editor), new Object[0]);
        }
        editor.accept((InteractiveGUI)gui);
        ((InteractiveGUI)gui).open();
        return gui;
    }

    public InteractiveGUI nationalNexus() {
        if (!this.hasPermission(StandardKingdomPermission.NEXUS, false)) {
            StandardKingdomPermission.NEXUS.sendDeniedMessage(this.viewer);
            return null;
        }
        InteractiveGUI gui = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_NATION_NEXUS);
        if (gui == null) {
            return null;
        }
        gui.push("settings", this::openSettings, new Object[0]).push("ranks", () -> {
            if (!this.hasPermission(StandardKingdomPermission.EDIT_RANKS)) {
                StandardKingdomPermission.EDIT_RANKS.sendDeniedMessage(this.viewer);
                return;
            }
            RankEditor.openRanks(KingdomsGUI.STRUCTURES_NEXUS_NATION_RANKS_RANKS, this.viewer, this.kp, this.group, innerGUI -> innerGUI.push("back", this::nationalNexus, new Object[0]));
        }, new Object[0]).push("resource-points", () -> this.openRp(rp -> rp.push("back", () -> {
            ((InventoryInteractiveGUI)rp).returnItems();
            this.nationalNexus();
        }, new Object[0])), new Object[0]);
        gui.open();
        return gui;
    }

    public void openRelationEditor(KingdomRelation relation, Consumer<InteractiveGUI> relationsEditor) {
        String guiPath = this.group instanceof Nation ? "structures/nexus/nation/settings/relation-editor" : "structures/nexus/settings/relation-editor";
        InteractiveGUI gui = GUIAccessor.prepare(this.viewer, this.kp.getOfflinePlayer(), guiPath, new Object[0]);
        if (gui == null) {
            return;
        }
        Set<RelationAttribute> attributesOpt = this.group.getAttributes().get((Object)relation);
        if (attributesOpt == null) {
            attributesOpt = new OrderedSet<RelationAttribute>(10);
        }
        gui.push("back", () -> this.openRelations(relationsEditor), new Object[0]);
        Set<RelationAttribute> attributes = attributesOpt;
        for (RelationAttribute attribute : Kingdoms.get().getRelationAttributeRegistry().getRegistry().values()) {
            boolean enabled = attributes.contains(attribute);
            gui.push(attribute.getNamespace().getConfigOptionName(), () -> {
                if (enabled) {
                    attributes.remove(attribute);
                } else {
                    attributes.add(attribute);
                }
                if (!attributes.isEmpty()) {
                    this.group.getAttributes().put(relation, attributes);
                }
                this.openRelationEditor(relation, relationsEditor);
            }, "enabled", enabled);
        }
        gui.open();
    }

    public InteractiveGUI openMembers(int page) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            InteractiveGUI gui = GUIAccessor.prepare(this.viewer, KingdomsGUI.STRUCTURES_NEXUS_MEMBERS.getGUIPath(), this.settings.clone().raw("page", page + 1));
            gui.push("back", this::openNexus, new Object[0]);
            ReusableOptionHandler holder = Objects.requireNonNull(gui.getReusableOption("members"), "Missing 'members' option from members GUI");
            List<KingdomPlayer> members = this.kingdom.getKingdomPlayers();
            int eachPage = holder.slotsCount();
            int maxPages = MathUtils.getPageNumbers(members.size(), eachPage);
            gui.getMessageContext().raw("pages", maxPages);
            gui.push("next-page", () -> {
                if (page + 1 >= maxPages) {
                    KingdomsLang.GUIS_PAGES_NEXT_PAGE_NOT_AVAILABLE.sendError((CommandSender)this.viewer, "pages", maxPages, "page", page + 1);
                    return;
                }
                this.openMembers(page + 1);
            }, new Object[0]);
            gui.push("previous-page", () -> {
                if (page == 0) {
                    KingdomsLang.GUIS_PAGES_PREVIOUS_PAGE_NOT_AVAILABLE.sendError((CommandSender)this.viewer, "pages", maxPages);
                    return;
                }
                this.openMembers(page - 1);
            }, new Object[0]);
            members.sort(KingdomPlayer::compareTo);
            for (KingdomPlayer member : (KingdomPlayer[])members.stream().skip((long)page * (long)eachPage).limit(eachPage).toArray(KingdomPlayer[]::new)) {
                OfflinePlayer memberPlayer = member.getOfflinePlayer();
                if (this.hasPermission(StandardKingdomPermission.MANAGE_RANKS)) {
                    holder.onNormalClicks(() -> this.openMember(member, memberGUI -> memberGUI.push("back", () -> this.openMembers(page), new Object[0])));
                }
                holder.pushHead(memberPlayer);
            }
            gui.open();
        });
        return null;
    }

    public InteractiveGUI openMember(KingdomPlayer member, Consumer<InteractiveGUI> handlers) {
        OfflinePlayer placeholder = member.getOfflinePlayer();
        Kingdom kingdom = member.getKingdom();
        InteractiveGUI memberGUI = GUIAccessor.prepare(this.viewer, member.getOfflinePlayer(), KingdomsGUI.STRUCTURES_NEXUS_MEMBER.getGUIPath(), new Object[0]);
        ReusableOptionHandler memberHead = memberGUI.getReusableOption("member");
        memberHead.pushHead(placeholder);
        GUIProtectionInterrupter.watchKingdomMember(member.getId(), memberGUI, null);
        boolean hasHigherPriority = this.kp.isAdmin() || this.kp.getRank().isHigherThan(member.getRank());
        boolean canChangeRank = hasHigherPriority && this.kp.hasPermission(StandardKingdomPermission.MANAGE_RANKS);
        memberGUI.getMessageContext().raw("can_demote", canChangeRank).raw("can_promote", canChangeRank).raw("can_kick", hasHigherPriority && this.kp.hasPermission(StandardKingdomPermission.KICK));
        memberGUI.push("kick", () -> {
            CommandKick.kick(kingdom, this.viewer, placeholder, NexusManager.admin(this.viewer));
            this.viewer.closeInventory();
        }, new Object[0]).push("demote", () -> {
            if (!this.hasPermission(StandardKingdomPermission.MANAGE_RANKS)) {
                StandardKingdomPermission.MANAGE_RANKS.sendDeniedMessage(this.viewer);
                return;
            }
            Rank rank = member.getRank();
            if (rank.isKing()) {
                KingdomsLang.COMMAND_DEMOTE_CANT_DEMOTE_KING.sendError((CommandSender)this.viewer, "demoted", placeholder.getName());
                return;
            }
            if (!NexusManager.admin(this.viewer) && !this.kp.getRank().isHigherThan(rank)) {
                KingdomsLang.COMMAND_DEMOTE_CANT_DEMOTE.sendError((CommandSender)this.viewer, "demoted", placeholder.getName());
                return;
            }
            if (kingdom.getRanks().isMemberRank(rank)) {
                KingdomsLang.COMMAND_DEMOTE_MEMBER.sendError((CommandSender)this.viewer, new Object[0]);
                return;
            }
            @NonNull PlayerRankChangeEvent demoteEvent = member.changeRank(new PlayerRankChangeContext(this.group, RankIdentifier.demote()).byPlayer(this.kp));
            if (demoteEvent.isCancelled()) {
                return;
            }
            rank = demoteEvent.getRank();
            for (Player kingdomMembers : kingdom.getOnlineMembers()) {
                KingdomsLang.COMMAND_DEMOTE_DEMOTED.sendMessage((CommandSender)kingdomMembers, (OfflinePlayer)this.viewer, new Object[]{"rank", rank.getColor() + rank.getName(), "demoted", placeholder.getName()});
            }
            this.openMember(member, handlers);
        }, new Object[0]).push("promote", () -> {
            if (!this.hasPermission(StandardKingdomPermission.MANAGE_RANKS)) {
                StandardKingdomPermission.MANAGE_RANKS.sendDeniedMessage(this.viewer);
                return;
            }
            if (CommandPromote.promote(this.kp, member)) {
                this.openMember(member, handlers);
            }
        }, new Object[0]);
        handlers.accept(memberGUI);
        memberGUI.open();
        return memberGUI;
    }

    private /* synthetic */ void lambda$openStructures$35(Inventory inv, StructureStyle style, DualCost cost, OptionHandler context) {
        if (inv.firstEmpty() == -1) {
            KingdomsLang.NEXUS_STRUCTURE_INVENTORY_FULL.sendError((CommandSender)this.viewer, new Object[0]);
            return;
        }
        if (!this.kp.isAdmin()) {
            Messenger error = style.evaluateConditions(new MessagePlaceholderProvider().withContext(this.kingdom), "purchase");
            if (error != null) {
                error.sendError((CommandSender)this.viewer, new Object[0]);
                return;
            }
            if (!this.kingdom.getResourcePoints().has(cost.getResourcePoints()) || !this.kingdom.getBank().has(cost.getMoney())) {
                context.sendError(KingdomsLang.NEXUS_STRUCTURE_COST, new Object[0]);
                return;
            }
            this.kingdom.getResourcePoints().add(-cost.getResourcePoints());
            this.kingdom.getBank().add(-cost.getMoney());
        }
        ItemStack item = style.buildItem(new KingdomItemCreateSettings(this.kingdom, this.kp)).getItem();
        XItemStack.addItems((Inventory)this.viewer.getInventory(), (boolean)false, (ItemStack[])new ItemStack[]{item});
        context.sendMessage((Messenger)KingdomsLang.NEXUS_STRUCTURE_PURCHASED, new Object[0]);
        LogAndStatsManager.handlePurchase(this.kingdom, new LogPurchaseStructure((double)((long)cost.getResourcePoints()), this.viewer.getUniqueId(), 1, style), collector -> new LogPurchaseStructure(collector.getResourcePointsCost(), this.viewer.getUniqueId(), collector.getAmount(), style));
    }

    private /* synthetic */ void lambda$openTurrets$33(TurretStyle style, Inventory inv, DualCost cost, OptionHandler context) {
        Messenger error;
        if (!this.kp.isAdmin() && (error = style.evaluateConditions(new MessagePlaceholderProvider().withContext(this.kingdom), "purchase")) != null) {
            error.sendError((CommandSender)this.viewer, new Object[0]);
            return;
        }
        if (inv.firstEmpty() == -1) {
            KingdomsLang.NEXUS_TURRET_INVENTORY_FULL.sendMessage((CommandSender)this.viewer);
            this.viewer.closeInventory();
            return;
        }
        if (!this.kp.isAdmin()) {
            if (!this.kingdom.getResourcePoints().has(cost.getResourcePoints()) || !this.kingdom.getBank().has(cost.getMoney())) {
                context.sendError(KingdomsLang.NEXUS_TURRET_COST, new Object[0]);
                return;
            }
            this.kingdom.getResourcePoints().add(-cost.getResourcePoints());
            this.kingdom.getBank().add(-cost.getMoney());
        }
        ItemStack item = style.buildItem(new KingdomItemCreateSettings(this.kingdom, this.kp)).getItem();
        inv.addItem(new ItemStack[]{item});
        context.sendMessage((Messenger)KingdomsLang.NEXUS_TURRET_PURCHASED, new Object[0]);
        LogAndStatsManager.handlePurchase(this.kingdom, new LogPurchaseTurret((double)((long)cost.getResourcePoints()), this.viewer.getUniqueId(), 1, style), collector -> new LogPurchaseTurret(collector.getResourcePointsCost(), this.viewer.getUniqueId(), collector.getAmount(), style));
    }

    static {
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_NEXUS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openNexus());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_STRUCTURES, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openStructures());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_TURRETS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openTurrets());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_SETTINGS_SETTINGS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openSettings());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_SETTINGS_RELATIONS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openRelations(gui -> gui.push("back", () -> inf.senderAsPlayer().closeInventory(), new Object[0])));
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_MEMBERS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openMembers(0));
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_RANKS_RANKS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openRanks());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_SETTINGS_SHIELDS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openShields());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_CHAMPION$UPGRADES, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openChampionUpgrades());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_MISC$UPGRADES, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openMiscUpgrades());
        GUIConfig.registerIndependentGUI(KingdomsGUI.MAILS_MAILBOX, inf -> {
            InteractiveGUI mailbox = MailUserAgent.getMailbox(inf.senderAsPlayer(), inf.getKingdom(), mailboxGUI -> mailboxGUI.push("back", () -> inf.senderAsPlayer().closeInventory(), new Object[0]));
            if (mailbox == null) {
                return null;
            }
            mailbox.open();
            return mailbox;
        });
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_LOGS, inf -> {
            Player player = inf.senderAsPlayer();
            return new AuditLogGUI(player, inf.getKingdom(), 0, logs -> {
                logs.push("back", () -> ((Player)player).closeInventory(), new Object[0]);
                logs.open();
            }).openGUI();
        });
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_RESOURCE$POINTS$CONVERTER, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openRp(gui -> gui.push("back", () -> inf.senderAsPlayer().closeInventory(), new Object[0])));
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_MEMBER, inf -> {
            KingdomPlayer member;
            if (inf.assertArgs(1)) {
                OfflinePlayer player = inf.getOfflinePlayer(0);
                if (player == null) {
                    return null;
                }
                member = KingdomPlayer.getKingdomPlayer(player);
                if (!inf.getKingdom().isMember(member)) {
                    inf.sendError(KingdomsLang.NOT_FOUND_IN_YOUR_KINGDOM, new Object[0]);
                    return null;
                }
            } else {
                member = inf.getKingdomPlayer();
            }
            return new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openMember(member, gui -> gui.push("back", () -> inf.senderAsPlayer().closeInventory(), new Object[0]));
        });
    }
}

