/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.itemoffer.impl;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.ItemMatcher;
import org.kingdoms.managers.buildings.itemoffer.BuildingItemOfferSession;
import org.kingdoms.managers.buildings.itemoffer.ItemOfferResult;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.numbers.Numbers;

public class BuildingRepairItemOffer
extends BuildingItemOfferSession {
    private double durabilityRecovery;

    public BuildingRepairItemOffer(Player player, Item droppedItem, SimpleLocation droppedLocation, ItemStack droppedItemStack) {
        super(player, droppedItem, droppedLocation, droppedItemStack);
    }

    @Override
    public void checkBuilding(KingdomBuilding<?> building) {
        boolean currentFull;
        double durability = building.getDurability();
        double maxDurability = ((KingdomBuildingStyle)building.getStyle()).getMaxDurability(building.getContext());
        ItemMatcher matched = null;
        double repairAmount = 0.0;
        for (ConfigSection variant : ((KingdomBuildingStyle)building.getStyle()).getOption("repair", "materials").getSection().getSection().getSections().values()) {
            matched = new ItemMatcher(variant.getSection("item"));
            if (matched.matches(this.droppedItemStack)) {
                repairAmount = variant.getDouble("amount");
                break;
            }
            matched = null;
        }
        if (matched == null) {
            return;
        }
        boolean bl = currentFull = durability >= maxDurability || durability <= 0.0;
        if (this.compareNeedsAndDistance(building, currentFull)) {
            return;
        }
        this.lastBuildingNeedsItem = !currentFull;
        this.building = building;
        this.matchedItem = matched;
        this.durabilityRecovery = repairAmount;
    }

    @Override
    public ItemOfferResult finalizeProcess() {
        int keep;
        double oldDurability = this.building.getDurability();
        if (oldDurability <= 0.0) {
            KingdomsLang.BUILDING_REPAIRS_REQUIRES_FULL_REPAIR.sendError((CommandSender)this.player, this.building.getMessageContext());
            return null;
        }
        if (!this.lastBuildingNeedsItem) {
            KingdomsLang.BUILDING_REPAIRS_DOESNT_NEED.sendError((CommandSender)this.player, this.building.getMessageContext());
            return null;
        }
        int amount = this.droppedItemStack.getAmount();
        this.building.playSound("partial-repair");
        double capacity = ((KingdomBuildingStyle)this.building.getStyle()).getMaxDurability(this.building.getContext());
        double costPerItem = this.durabilityRecovery;
        double added = costPerItem * (double)amount;
        this.building.setDurability(Math.min(capacity, oldDurability + added));
        double newDurability = this.building.getDurability();
        if (newDurability == capacity) {
            double needed = capacity - oldDurability;
            keep = (int)Math.floor((added - needed) / costPerItem);
        } else {
            keep = 0;
        }
        return new ItemOfferResult(keep, newDurability == capacity ? KingdomsLang.BUILDING_REPAIRS_MAXXED : KingdomsLang.BUILDING_REPAIRS_FILL, this.building.getMessageContext().raws("old-durability", Numbers.toFancyNumber(oldDurability), "added-durability", Numbers.toFancyNumber(added)));
    }
}

