/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.itemoffer;

import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.managers.ItemMatcher;
import org.kingdoms.managers.buildings.itemoffer.ItemOfferResult;

public abstract class BuildingItemOfferSession {
    public KingdomBuilding<?> building;
    public ItemMatcher matchedItem;
    protected boolean lastBuildingNeedsItem;
    protected final Player player;
    protected final Item droppedItem;
    protected final SimpleLocation droppedLocation;
    protected final ItemStack droppedItemStack;

    protected BuildingItemOfferSession(Player player, Item droppedItem, SimpleLocation droppedLocation, ItemStack droppedItemStack) {
        this.player = player;
        this.droppedItem = droppedItem;
        this.droppedLocation = droppedLocation;
        this.droppedItemStack = droppedItemStack;
    }

    public abstract void checkBuilding(KingdomBuilding<?> var1);

    public abstract ItemOfferResult finalizeProcess();

    protected boolean compareNeedsAndDistance(KingdomBuilding<?> building, boolean currentFull) {
        if (currentFull && this.lastBuildingNeedsItem) {
            return true;
        }
        if (currentFull == !this.lastBuildingNeedsItem && this.building != null) {
            double newDist;
            SimpleLocation prevLoc = this.building.getOrigin();
            SimpleLocation newLoc = building.getOrigin();
            double prevDist = this.droppedLocation.distance(prevLoc);
            if (prevDist < (newDist = this.droppedLocation.distance(newLoc))) {
                return true;
            }
        }
        return false;
    }
}

