/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.itemoffer;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.buildings.itemoffer.BuildingItemOfferSession;
import org.kingdoms.managers.buildings.itemoffer.ItemOfferResult;
import org.kingdoms.managers.buildings.itemoffer.impl.BuildingFuelItemOffer;
import org.kingdoms.managers.buildings.itemoffer.impl.BuildingRepairItemOffer;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.nms.HologramFactory;

public final class BuildingItemOfferManager
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDrop(PlayerDropItemEvent event) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Kingdoms.get(), () -> {
            Item droppedItem = event.getItemDrop();
            if (!droppedItem.isValid()) {
                return;
            }
            Player player = event.getPlayer();
            SimpleLocation droppedLocation = SimpleLocation.of(droppedItem.getLocation());
            ItemStack droppedItemStack = droppedItem.getItemStack();
            BuildingItemOfferSession[] sessions = new BuildingItemOfferSession[]{new BuildingFuelItemOffer(player, droppedItem, droppedLocation, droppedItemStack), new BuildingRepairItemOffer(player, droppedItem, droppedLocation, droppedItemStack)};
            Set checkedBuildings = Collections.newSetFromMap(new IdentityHashMap());
            LocationUtils.findBlock(droppedItem.getLocation().getBlock(), 3, block -> {
                SimpleLocation loc = SimpleLocation.of(block);
                SimpleChunkLocation chunk = loc.toSimpleChunkLocation();
                Land land = chunk.getLand();
                if (land == null || !land.isClaimed()) {
                    return false;
                }
                KingdomBuilding building = land.getKingdomBlock(loc.toBlockVector(), KingdomBuilding.class);
                if (building == null) {
                    return false;
                }
                if (!checkedBuildings.add(building)) {
                    return false;
                }
                for (BuildingItemOfferSession session : sessions) {
                    session.checkBuilding(building);
                }
                return false;
            });
            if (!droppedItem.isValid() || droppedItem.isDead()) {
                return;
            }
            ItemOfferResult result = null;
            BuildingItemOfferSession finalSession = null;
            for (BuildingItemOfferSession session : sessions) {
                if (session.building != null) {
                    finalSession = session;
                }
                if (!session.lastBuildingNeedsItem) continue;
                result = session.finalizeProcess();
                break;
            }
            if (result == null) {
                if (finalSession != null) {
                    finalSession.finalizeProcess();
                }
                return;
            }
            ParticleDisplay.of((XParticle)XParticle.SMOKE).offset(0.3).withCount(Math.max(20, (droppedItemStack.getAmount() - result.getKeep()) * 5)).spawn(droppedItem.getLocation());
            ItemOfferResult finalResult = result;
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
                if (finalResult.getKeep() > 0) {
                    droppedItemStack.setAmount(finalResult.getKeep());
                    droppedItem.setItemStack(droppedItemStack);
                } else {
                    droppedItem.remove();
                }
            });
            MessagePlaceholderProvider settings = result.getContext();
            String msg = result.getHologram().parse(settings);
            KingdomBuilding<?> finalBuilding = finalSession.building;
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> HologramFactory.spawnUpwards(finalBuilding.getOrigin().toBukkitLocation(), msg));
        }, 7L);
    }
}

