/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings;

import java.awt.Color;
import java.time.Duration;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.kingdoms.commands.general.admin.CommandSession;
import org.kingdoms.commands.general.admin.SessionAnswer;
import org.kingdoms.commands.general.building.CommandBuildingRemove;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.abstraction.KingdomBuildingType;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.locale.SimpleContextualMessageSender;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.buildings.turrets.TurretManager;
import org.kingdoms.managers.land.KingdomBuildingManager;
import org.kingdoms.managers.land.block.KingdomsBlockBreakContext;
import org.kingdoms.managers.land.block.KingdomsBlockContext;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.display.visualizer.StructureVisualizer;

public final class KingdomBuildingManagerCommons {
    private KingdomBuildingManagerCommons() {
    }

    @Nullable
    public static Messenger evaluateConditions(KingdomBuilding<?> building, String type) {
        return ((KingdomBuildingStyle)building.getStyle()).evaluateConditions(building.getMessageContext(), type);
    }

    public static Messenger handleManualBreak(KingdomsBlockBreakContext<? extends KingdomBuilding<?>> context) {
        KingdomBuilding<?> building = context.getBlock();
        BlockBreakEvent event = context.getCause();
        Player player = context.getPlayer().getPlayer();
        if (building.getBuilding().getRegion().getBlocks().size() > 1 && !context.getMetadata().containsKey(KingdomsBlockContext.DefaultMetadatas.CONFIRMATION)) {
            BlockLocation3 targetted = BukkitAdapter.adaptLocation(event.getBlock());
            event.setCancelled(true);
            Set<BlockVector3> blocks = building.getBuilding().getRegion().getBlocks();
            StructureVisualizer preview = new StructureVisualizer(KingdomBuildingManager.PREVIEW_NS, player, blocks, Duration.ofSeconds(10L));
            preview.getMetadata().put(KingdomBuildingManager.ORIGIN_NS, (Object)targetted);
            preview.setColor(Color.ORANGE);
            preview.blockMarkers();
            preview.start();
            CommandSession.addSession(player, TurretManager.NS, Duration.ofSeconds(30L), context.getMessageContext(), answer -> {
                if (SessionAnswer.get(answer) == SessionAnswer.YES) {
                    CommandBuildingRemove.remove(new SimpleContextualMessageSender((CommandSender)player, context.getMessageContext().clone()));
                }
                return false;
            });
            return ((KingdomBuildingType)((KingdomBuildingStyle)building.getStyle()).getType()).getLang("confirm-remove");
        }
        return null;
    }
}

