/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.backup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.database.sql.DatabaseProperties;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.base.SQLDatabase;
import org.kingdoms.data.database.sql.connection.SQLConnectionProvider;
import org.kingdoms.data.database.sql.statements.SQLBackup;
import org.kingdoms.data.database.sql.statements.SQLRestore;
import org.kingdoms.data.history.DataVersion;
import org.kingdoms.data.managers.base.DataManager;
import org.kingdoms.dependencies.Dependency;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.snakeyaml.api.Dump;
import org.kingdoms.libs.snakeyaml.api.DumpSettings;
import org.kingdoms.libs.snakeyaml.api.SimpleWriter;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.BackupInfo;
import org.kingdoms.managers.TempKingdomsFolder;
import org.kingdoms.managers.backup.BackupManager;
import org.kingdoms.managers.backup.ZipEntryCreator;
import org.kingdoms.managers.backup.ZipEntryCreatorInputStream;
import org.kingdoms.managers.backup.ZipEntryCreatorPath;
import org.kingdoms.managers.chunkrestoration.ChunkSnapshotManager;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.fs.FSUtil;
import org.kingdoms.utils.fs.walker.visitors.FunctionalPathVisitor;
import org.kingdoms.utils.internal.arrays.FunctionalList;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.versioning.LatestMCVersion;

public final class KingdomsBackup
extends BackupManager {
    public static final Path BACKUPS_FOLDER = Kingdoms.getPath(KingdomsConfig.BACKUPS_FOLDER.getString());
    private static final String BACKUP_PROPERTIES_FILE_NAME = "backup-properties.yml";
    private static final String NATIONS = KingdomsConfig.DATABASE_TABLES_NATIONS.getString();
    private static final String KINGDOMS = KingdomsConfig.DATABASE_TABLES_KINGDOMS.getString();
    private static final String LANDS = KingdomsConfig.DATABASE_TABLES_LANDS.getString();
    private static final String PLAYERS = KingdomsConfig.DATABASE_TABLES_PLAYERS.getString();
    private static final String MAILS = KingdomsConfig.DATABASE_TABLES_MAILS.getString();
    private static final String TURRETS = "Turrets";
    private static final String STRUCTURES = "Structures";
    private static final long INTERVAL_MILLIS = KingdomsConfig.BACKUPS_INTERVAL.getTime().toMillis();
    private final FunctionalPathVisitor functionalPathVisitor = new FunctionalPathVisitor(Kingdoms.getFolder()).onlyIf(KingdomsConfig.BACKUPS_ENABLED_CONFIGS.getBoolean(), visitor -> visitor.visitFolder(TURRETS).visitFolder(STRUCTURES).visitFolder(GUIConfig.getFolder()).visitFolder(LanguageManager.LANG_FOLDER).visitFiles(x -> x.getFileName().toString().endsWith(".yml"))).onlyIf(KingdomsConfig.BACKUPS_ENABLED_DATA.getBoolean(), visitor -> visitor.visitFolder(KingdomsDataCenter.DATA_FOLDER).visitFolder(NATIONS).visitFolder(KINGDOMS).visitFolder(LANDS).visitFolder(PLAYERS).visitFolder(MAILS).onlyIf(!KingdomsConfig.BACKUPS_ENABLED_CHUNK_SNAPSHOTS.getBoolean(), dataVisitor -> dataVisitor.skipFolder(ChunkSnapshotManager.DATA_FOLDER)));

    public KingdomsBackup(Kingdoms plugin) {
        super(BACKUPS_FOLDER, Kingdoms.getFolder(), true, null);
        useMultiBackups = KingdomsConfig.BACKUPS_IGNORE_TODAYS_BACKUP.getBoolean();
    }

    @Override
    public FunctionalPathVisitor getPathVisitor() {
        return this.functionalPathVisitor;
    }

    @Override
    public void configureRestorer(BackupInfo info) {
        info.registerRestorer("data/backup.sql", KingdomsBackup::SQLRestorer);
        info.registerRestorer("backup.sql", KingdomsBackup::SQLRestorer);
    }

    private static void SQLRestorer(BackupInfo.BackupFile file) {
        file.copy(file.path);
        Kingdoms.get().getDependencyManager().loadDependencies(Collections.singleton(Dependency.H2_DRIVER));
        try (SQLConnectionProvider provider = SQLConnectionProvider.getProvider(KingdomsDataCenter.DATA_FOLDER, DatabaseType.H2);){
            provider.connect();
            try (Connection connectin = provider.getConnection();
                 Statement statement = connectin.createStatement();){
                statement.execute(DatabaseType.H2.createStatement(new SQLRestore(file.path), ""));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadH2BackupSystem() {
        Kingdoms.get().getDependencyManager().loadDependencies(Arrays.asList(Dependency.SLF4J_SIMPLE, Dependency.H2_DRIVER, Dependency.HIKARI));
    }

    public static BackupData backupData(Path toFolder) {
        return KingdomsBackup.backupData(toFolder, Collections.singletonList(BackupComponents.Data.name()));
    }

    public static BackupData backupData(Path toFolder, List<String> backupComponents) {
        FSUtil.deleteFolder(toFolder);
        try {
            Files.createDirectories(toFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DataBackupMethod backupMethod = KingdomsBackup.backupData0(toFolder);
        String backupVersion = backupMethod == DataBackupMethod.COPY_FILES ? "1.0" : Dependency.H2_DRIVER.getUsedVersion().getVersion();
        Dump dumper = new Dump(new DumpSettings());
        MappingNode props = KingdomsBackup.createProperties(backupMethod, backupVersion, backupComponents);
        Path propsFile = toFolder.resolve(BACKUP_PROPERTIES_FILE_NAME);
        List files = FSUtil.getFiles(toFolder).stream().map(x -> new ZipEntryCreatorPath((Path)x, "data/" + x.getFileName(), ZipEntryCreator.DuplicateStrategy.SKIP)).collect(Collectors.toList());
        try (BufferedWriter writer = Files.newBufferedWriter(propsFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            dumper.dumpNode(props, new SimpleWriter(writer));
        }
        catch (IOException e) {
            KLogger.error("Error while attempting to save configuration file " + propsFile + ": ");
            e.printStackTrace();
        }
        files.add(new ZipEntryCreatorPath(propsFile, BACKUP_PROPERTIES_FILE_NAME, ZipEntryCreator.DuplicateStrategy.SKIP));
        return new BackupData(files, backupVersion, backupMethod);
    }

    private static void msg(String msg) {
        MessageHandler.sendConsolePluginMessage(msg);
    }

    private static DataBackupMethod backupData0(Path toFolder) {
        DataBackupMethod backupMethod;
        block25: {
            try {
                Files.createDirectories(toFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            DatabaseType databaseType = Kingdoms.get().getDataCenter().getDatabaseType();
            backupMethod = KingdomsBackup.getBackupMethod();
            KingdomsBackup.msg("&2Taking a backup... Detected &8" + (Object)((Object)databaseType) + " &2database, using &9" + (Object)((Object)backupMethod) + " &2backup method.");
            if (backupMethod == DataBackupMethod.COPY_FILES) {
                KingdomsBackup.msg("&2Copying backup files from &9" + KingdomsDataCenter.DATA_FOLDER + " &8-> &9" + toFolder);
                FSUtil.copyFolder(KingdomsDataCenter.DATA_FOLDER, toFolder);
            } else {
                if (backupMethod == DataBackupMethod.DIRECT_H2) {
                    KingdomsBackup.msg("&2Running backup script on the existing data center...");
                    SQLConnectionProvider connProvider = Kingdoms.get().getDataCenter().getSqlConnectionProvider();
                    try (Connection connection = connProvider.getConnection();
                         Statement statement = connection.createStatement();){
                        statement.execute(DatabaseType.H2.createStatement(new SQLBackup(toFolder, "backup"), "{TABLE NOT REQUIRED}"));
                        break block25;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                KingdomsBackup.msg("&2Loading H2 system for backup...");
                KingdomsBackup.loadH2BackupSystem();
                try (KingdomsDataCenter newDataCenter = new KingdomsDataCenter(Namespace.kingdoms("BACKUP"), DatabaseType.H2, toFolder, null, false, true, false);){
                    KingdomsBackup.msg("&2Loading all data to take a backup... This might take several minutes.");
                    for (DataManager<?> dataManager : Kingdoms.get().getDataCenter().getAllDataManagers()) {
                        KingdomsBackup.msg("  &8+ &2Loading &9" + dataManager + " &2data...");
                        dataManager.loadAllData(true);
                        KingdomsBackup.msg("      &8- &3Loaded &9" + dataManager.loadedCount() + " &3data. Copying data...");
                        DataManager<?> newDataManager = newDataCenter.getRegistry().get(dataManager.getNamespace());
                        dataManager.copyAllDataTo((DataManager)Fn.cast(newDataManager));
                        KingdomsBackup.msg("      &8- &3Copied data. Saving new data manager...");
                        newDataManager.saveAll(false);
                        KingdomsBackup.msg("      &8- &3Saved data.");
                    }
                    KingdomsBackup.msg("&2Running backup script on new data center...");
                    DataManager<?> firstDataManager = newDataCenter.getAllDataManagers().iterator().next();
                    SQLDatabase database = (SQLDatabase)firstDataManager.getDatabase();
                    database.executeStatement(new SQLBackup(toFolder, "backup"));
                }
                KingdomsBackup.msg("&2Backup script finished.");
            }
        }
        return backupMethod;
    }

    @NotNull
    private static DataBackupMethod getBackupMethod() {
        DatabaseType databaseType = Kingdoms.get().getDataCenter().getDatabaseType();
        switch (databaseType) {
            case H2: {
                return DataBackupMethod.DIRECT_H2;
            }
            case SQLite: 
            case MySQL: 
            case MariaDB: 
            case PostgreSQL: 
            case MongoDB: {
                return DataBackupMethod.H2;
            }
            case JSON: 
            case YAML: {
                return DataBackupMethod.COPY_FILES;
            }
        }
        throw new UnsupportedOperationException("Unknown database type " + (Object)((Object)databaseType) + " for backup.");
    }

    public void autoBackup() {
        this.setAutomatic(true);
        Kingdoms.taskScheduler().async().repeating(Duration.ZERO, Duration.ofMillis(INTERVAL_MILLIS), this::autoBackupCaller);
    }

    private void autoBackupCaller() {
        if (!useMultiBackups && this.hasBackupToday()) {
            MessageHandler.sendConsolePluginMessage("&2You already have a backup for today!");
            return;
        }
        this.deleteOldBackups(KingdomsConfig.BACKUPS_DELETE_BACKUPS_OLDER_THAN.getInt(), TimeUnit.DAYS);
        this.takeBackup();
    }

    @Override
    public void takeBackup(Path to) {
        MessageHandler.sendConsolePluginMessage("&2Taking a backup...");
        int result = this.zipFiles(to);
        MessageHandler.sendConsolePluginMessage("&2Backed up &6" + result + " &2files.");
    }

    private static boolean dumpRemoteDatabase(DatabaseType databaseType, DatabaseProperties databaseProperties, Path path) {
        String[] executeCmd;
        if (databaseType == DatabaseType.MySQL || databaseType == DatabaseType.MariaDB) {
            String tableNames = Stream.of("kingdoms", "nations", "players", "lands", "mails", "versions").map(x -> SQLConnectionProvider.TABLE_PREFIX + '_' + x).collect(Collectors.joining(" "));
            executeCmd = new String[]{"mysqldump", "--create-options", "--extended-insert", "--host=" + databaseProperties.address, "--port=" + databaseProperties.getPort(), "--user=" + databaseProperties.user, "--password=" + databaseProperties.password, "--databases", databaseProperties.databaseName, "--tables", tableNames, "-r", path.toAbsolutePath().toString()};
        } else if (databaseType == DatabaseType.PostgreSQL) {
            executeCmd = new String[]{"pg_dumpall", "--dbname=\"postgresql://" + databaseProperties.user + ':' + databaseProperties.password + '@' + databaseProperties.address.replace("localhost", "127.0.0.1") + ':' + databaseProperties.getPort() + '/' + databaseProperties.databaseName + '\"', "--table=" + SQLConnectionProvider.TABLE_PREFIX + '*', "--file=" + path.toAbsolutePath()};
        } else if (databaseType == DatabaseType.MongoDB) {
            String collectionNames = Stream.of("kingdoms", "nations", "players", "lands", "mails", "versions").map(x -> SQLConnectionProvider.TABLE_PREFIX + '_' + x).collect(Collectors.joining(", "));
            executeCmd = new String[]{"mongodump", "--db", "minecraft", "--collection", collectionNames, "--host", databaseProperties.address, "--port", String.valueOf(databaseProperties.getPort()), "--username", databaseProperties.user, "--authenticationDatabase", "admin", "--password", databaseProperties.password, "--out", path.toAbsolutePath().toString()};
        } else {
            throw new IllegalArgumentException("Backups not supported for SQL: " + (Object)((Object)databaseType));
        }
        try {
            String line;
            KLogger.info("Generating database dump for " + (Object)((Object)databaseType) + "...");
            Process proc = Runtime.getRuntime().exec(executeCmd);
            try (BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                while ((line = stdInput.readLine()) != null) {
                    KLogger.info('[' + databaseType.name() + "] " + line);
                }
            }
            try (BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
                while ((line = stdError.readLine()) != null) {
                    KLogger.error('[' + databaseType.name() + "] " + line);
                }
            }
            int processComplete = proc.waitFor();
            KLogger.info("Database dump for " + (Object)((Object)databaseType) + " returned " + processComplete);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        return Files.exists(path, new LinkOption[0]);
    }

    private static MappingNode createProperties(DataBackupMethod method, String backupVersion, Collection<String> elements) {
        ConfigSection properties = new ConfigSection(new MappingNode());
        properties.set("kingdoms-version", (Object)Kingdoms.get().getDescription().getVersion());
        properties.set("server-version", (Object)LatestMCVersion.CURRENT_VERSION.asString(false, false));
        properties.set("data-version", (Object)DataVersion.getCurrentVersion().ordinal());
        properties.set("at", (Object)System.currentTimeMillis());
        properties.set("backup-method", (Object)method);
        properties.set("backup-version", (Object)backupVersion);
        properties.set("elements", elements);
        return properties.getNode();
    }

    @Override
    public Collection<ZipEntryCreator> addToZip() {
        boolean backupData = KingdomsConfig.BACKUPS_ENABLED_DATA.getBoolean();
        List<String> backupComponents = FunctionalList.create().addIf(backupData, BackupComponents.Data).addIf(KingdomsConfig.BACKUPS_ENABLED_CONFIGS.getBoolean(), BackupComponents.Configs).addIf(KingdomsConfig.BACKUPS_ENABLED_CHUNK_SNAPSHOTS.getBoolean(), BackupComponents.ChunkSnapshots).stream().map(Enum::name).collect(Collectors.toList());
        if (backupData && KingdomsBackup.getBackupMethod() != DataBackupMethod.COPY_FILES) {
            DatabaseType databaseType = Kingdoms.get().getDataCenter().getDatabaseType();
            if (databaseType != null) {
                Path path = Kingdoms.getPath("kingdomsx-db.dump.temp.sql");
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return KingdomsBackup.backupData((Path)TempKingdomsFolder.getOrCreateFolder((String)"backup"), backupComponents).paths;
            }
        } else {
            MappingNode props = KingdomsBackup.createProperties(backupData ? KingdomsBackup.getBackupMethod() : DataBackupMethod.NONE, "1.0", backupComponents);
            Dump dumper = new Dump(new DumpSettings());
            String str = dumper.dumpToString(props);
            return Collections.singleton(new ZipEntryCreatorInputStream(BACKUP_PROPERTIES_FILE_NAME, FSUtil.stringToInputStream(str)));
        }
        return null;
    }

    public static enum BackupComponents {
        Data,
        Configs,
        ChunkSnapshots;

    }

    public static final class BackupData {
        public final List<ZipEntryCreator> paths;
        public final String backupVersion;
        public final DataBackupMethod backupMethod;

        private BackupData(List<ZipEntryCreator> paths, String backupVersion, DataBackupMethod backupMethod) {
            this.paths = paths;
            this.backupVersion = backupVersion;
            this.backupMethod = backupMethod;
        }
    }

    public static enum DataBackupMethod {
        NONE,
        DIRECT_H2,
        H2,
        COPY_FILES;

    }
}

