/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.awt.Color;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.constants.themes.ThemeContainer;
import org.kingdoms.constants.themes.ThemeProvider;
import org.kingdoms.constants.themes.Themes;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionCategory;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.buildings.structures.NexusManager;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.utils.ColorUtils;
import org.kingdoms.utils.config.ConfigSection;

public final class ThemeManager {
    private final Player player;
    private final ThemeContainer container;
    private final Group group;
    private Consumer<InteractiveGUI> handlers;

    public ThemeManager(Player player, Group group) {
        this.player = player;
        this.container = group;
        this.group = group;
    }

    public ThemeManager setHandlers(Consumer<InteractiveGUI> handlers) {
        this.handlers = handlers;
        return this;
    }

    public InteractiveGUI groupColorTypes() {
        Object gui = new GUIBuilder(KingdomsGUI.COLOR$PICKER_THEMES).forPlayer(this.player).build();
        ReusableOptionHandler theme = ((InteractiveGUI)gui).getReusableOption("themes");
        for (ThemeProvider provider : Themes.INSTANCE.getRegistry().values()) {
            Themes.addValueContext(theme.getMessageContext(), this.container, provider);
            theme.on(ClickType.LEFT, () -> this.getColorPicker(provider));
            theme.on(ClickType.RIGHT, () -> {
                this.container.getThemes().remove(provider.getNamespace());
                this.groupColorTypes();
            });
            theme.done();
        }
        if (this.handlers == null) {
            ((InteractiveGUI)gui).push("back", () -> gui.close(), new Object[0]);
        } else {
            this.handlers.accept((InteractiveGUI)gui);
        }
        ((InteractiveGUI)gui).open();
        return gui;
    }

    public InteractiveGUI getColorPicker(ThemeProvider themeProvider) {
        Namespace colorType = themeProvider.getNamespace();
        return this.getColorPicker(themeProvider, (name, color) -> {
            Kingdoms.taskScheduler().run(TaskThreadType.SYNC, () -> this.group.setColor(colorType, (Color)color, KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player)));
            KingdomsLang.THEMES_SET.sendMessage((CommandSender)this.player, "color", name, "r", color.getRed(), "b", color.getBlue(), "g", color.getGreen(), "hex", color.getRGB());
        }, gui -> gui.push("back", this::groupColorTypes, new Object[0]));
    }

    public InteractiveGUI getColorPicker(ThemeProvider themeProvider, BiConsumer<String, Color> onChoose, Consumer<InteractiveGUI> handlers) {
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
        if (!NexusManager.admin(this.player) && !kp.hasPermission(StandardKingdomPermission.SETTINGS)) {
            StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.player);
            return null;
        }
        InteractiveGUI gui = GUIAccessor.prepare(this.player, kp.getOfflinePlayer(), KingdomsGUI.COLOR$PICKER_COLOR$PICKER.getGUIPath(), new Object[0]);
        if (gui == null) {
            return null;
        }
        Themes.addValueContext(gui.getMessageContext(), this.group, themeProvider);
        gui.push("hex-picker", () -> {
            KingdomsLang.THEMES_PROMPT.sendMessage((CommandSender)this.player);
            gui.startConversation("hex-picker");
        }, color -> {
            Color awtColor;
            if (color.startsWith("#")) {
                awtColor = ColorUtils.hex(color);
                if (awtColor == null) {
                    KingdomsLang.THEMES_WRONG_HEX.sendMessage((CommandSender)this.player, "color", color);
                    return;
                }
            } else {
                awtColor = ColorUtils.rgb(color);
                if (awtColor == null) {
                    KingdomsLang.THEMES_WRONG_RGB.sendMessage((CommandSender)this.player, "color", color);
                    return;
                }
            }
            if (!themeProvider.isThemeAllowed(this.container, awtColor)) {
                KingdomsLang.THEMES_DISALLOWED.sendMessage((CommandSender)this.player, "color", color);
                return;
            }
            onChoose.accept((String)color, awtColor);
            this.getColorPicker(themeProvider, onChoose, handlers);
            gui.endConversation();
        }, new Object[0]);
        for (OptionCategory holder : gui.getOptions("color")) {
            ConfigSection sell = holder.getOption().setEdits("color_allowed", true).getConfig();
            String color2 = sell.getString("color");
            Color parsed = ColorUtils.parseColor(color2);
            if (parsed != null) {
                holder.getOption().setEdits("color_allowed", themeProvider.isThemeAllowed(this.container, parsed)).onNormalClicks(() -> {
                    if (!themeProvider.isThemeAllowed(this.container, parsed)) {
                        KingdomsLang.THEMES_DISALLOWED.sendMessage((CommandSender)this.player, "color", color2);
                        return;
                    }
                    onChoose.accept(color2, parsed);
                    this.getColorPicker(themeProvider, onChoose, handlers);
                }).done();
                continue;
            }
            throw new IllegalStateException("Color is null for " + holder.getName() + " in color-picker GUI");
        }
        if (handlers != null) {
            handlers.accept(gui);
        }
        gui.open();
        return gui;
    }
}

