/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.time.Duration;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.general.admin.CommandSession;
import org.kingdoms.commands.general.home.CommandSetHome;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.utils.ItemUtil;
import org.kingdoms.utils.internal.string.StringMatcher;

public class PrivateKingdomManager
implements Listener {
    private static final Namespace NS = Namespace.kingdoms("PRIVATE_KINGDOM_CREATION");

    @EventHandler
    public void onPrivateKingdomCreate(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInMainHand = player.getInventory().getItemInMainHand();
        if (ItemUtil.isNull(itemInMainHand)) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.hasKingdom()) {
            return;
        }
        if (!KingdomsConfig.PRIVATE_KINGDOMS_ENABLED.getBoolean()) {
            return;
        }
        if (!StringMatcher.parseAndGroup(KingdomsConfig.PRIVATE_KINGDOMS_ITEMS.getStringList()).matches(XMaterial.matchXMaterial((ItemStack)itemInMainHand).name())) {
            return;
        }
        MessagePlaceholderProvider context = new MessagePlaceholderProvider().withContext(player);
        CommandSession.addSession(player, NS, Duration.ofSeconds(30L), context, answer -> {
            Kingdom kingdom = PrivateKingdomManager.createPrivateKingdom(player);
            if (kingdom == null) {
                KingdomsLang.COMMAND_CREATE_PRIVATE_NOT_POSSIBLE.sendError((CommandSender)player, new Object[0]);
                return false;
            }
            KingdomsLang.COMMAND_CREATE_PRIVATE_CREATED.sendMessage((CommandSender)player, context);
            return false;
        });
        KingdomsLang.COMMAND_CREATE_PRIVATE_CONFIRM.sendMessage((CommandSender)player, context);
    }

    public static Kingdom createPrivateKingdom(Player player) {
        Kingdom kingdom = new Kingdom(player.getUniqueId(), "PR-" + player.getName());
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        SimpleChunkLocation chunkLocation = SimpleChunkLocation.of(player.getLocation());
        ClaimProcessor claimProcessor = ClaimProcessor.build(chunkLocation, kp, kingdom).process();
        if (!claimProcessor.isSuccessful()) {
            return null;
        }
        if (kingdom.claim(claimProcessor.getChunk(), kp, ClaimLandEvent.Reason.AUTO_CLAIMED).isCancelled()) {
            return null;
        }
        claimProcessor.finalizeProcess();
        if (KingdomsConfig.HOME_SET_ON_CREATE.getBoolean()) {
            CommandSetHome.setHome(kingdom, BukkitAdapter.adapt(player.getLocation().add(0.0, 1.0, 0.0)), kp);
        }
        XSound.play((String)KingdomsConfig.CREATION_KINGDOMS_SOUND.getString(), x -> x.forPlayers(new Player[]{player}));
        return kingdom;
    }
}

