/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.upgradable.Powerup;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.main.Kingdoms;

public final class PowerupManager
implements Listener {
    private static final String PROJECTILE_SOURCE_META = "PROJECTILE_SOURCE";

    private static SimpleChunkLocation getProjectileLocation(Powerup powerup, Player damager, Entity projectile) {
        if (powerup == Powerup.ARROW_BOOST) {
            List test = projectile.getMetadata(PROJECTILE_SOURCE_META);
            if (test.isEmpty()) {
                return SimpleChunkLocation.of(damager.getLocation());
            }
            return SimpleChunkLocation.of((Location)((MetadataValue)test.get(0)).value());
        }
        return SimpleChunkLocation.of(damager.getLocation());
    }

    public static void onPlayerDeathPowerLoss(Player player, KingdomPlayer kp) {
        if (!KingdomsConfig.Powers.POWER_ENABLED.getManager().getBoolean()) {
            return;
        }
        double amount = KingdomsConfig.Powers.POWER_PLAYER_LOSS_DEATH.getManager().getDouble();
        if (amount <= 0.0) {
            return;
        }
        double previous = kp.getPower();
        kp.addPower(-amount);
        KingdomsLang.POWER_DEATH.sendError((CommandSender)player, "lost", amount, "previous", previous);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerShootEvent(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        Player shooter = (Player)projectile.getShooter();
        projectile.setMetadata(PROJECTILE_SOURCE_META, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)shooter.getLocation()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onDamage(EntityDamageByEntityEvent event) {
        int lvl;
        Player victim;
        KingdomPlayer kp;
        Kingdom kingdom;
        double damage = event.getDamage();
        if (event.getEntity() instanceof Player && Powerup.DAMAGE_REDUCTION.isEnabled() && (kingdom = (kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)(victim = (Player)event.getEntity()))).getKingdom()) != null && (lvl = kingdom.getUpgradeLevel(Powerup.DAMAGE_REDUCTION)) > 0 && (!Powerup.DAMAGE_REDUCTION.isOwnLandOnly() || kingdom.isClaimed(SimpleChunkLocation.of(victim.getLocation())))) {
            damage -= Powerup.DAMAGE_REDUCTION.getScaling(new PlaceholderContextBuilder().withContext(kingdom).raw("lvl", lvl).raw("damage", event.getDamage()));
        }
        Player damager = null;
        if (event.getDamager() instanceof Projectile) {
            Projectile projectile = (Projectile)event.getDamager();
            ProjectileSource shooter = projectile.getShooter();
            if (shooter instanceof Player) {
                damager = (Player)shooter;
            }
        } else if (event.getDamager() instanceof Player) {
            damager = (Player)event.getDamager();
        }
        if (damager != null && (kingdom = (kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)damager)).getKingdom()) != null) {
            int lvl2;
            Powerup powerup;
            Powerup powerup2 = powerup = event.getCause() == EntityDamageEvent.DamageCause.PROJECTILE ? Powerup.ARROW_BOOST : Powerup.DAMAGE_BOOST;
            if (powerup.isEnabled() && (lvl2 = kingdom.getUpgradeLevel(powerup)) > 0 && (!powerup.isOwnLandOnly() || kingdom.isClaimed(PowerupManager.getProjectileLocation(powerup, damager, event.getDamager())))) {
                damage += powerup.getScaling(new PlaceholderContextBuilder().withContext(kingdom).raw("lvl", lvl2).raw("damage", event.getDamage()));
            }
        }
        event.setDamage(Math.max(0.0, damage));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onRegen(EntityRegainHealthEvent event) {
        if (event.getRegainReason() != EntityRegainHealthEvent.RegainReason.EATING) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!Powerup.REGENERATION_BOOST.isEnabled()) {
            return;
        }
        Player damager = (Player)event.getEntity();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)damager);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        int lvl = kingdom.getUpgradeLevel(Powerup.REGENERATION_BOOST);
        if (lvl > 0 && (!Powerup.REGENERATION_BOOST.isOwnLandOnly() || kingdom.isClaimed(SimpleChunkLocation.of(damager.getLocation())))) {
            double amount = Powerup.REGENERATION_BOOST.getScaling(new PlaceholderContextBuilder().withContext(kingdom).raw("lvl", lvl).raw("amount", event.getAmount()));
            event.setAmount(event.getAmount() + amount);
        }
    }
}

