/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.CascadingMessageContextProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.commands.ConfigCommand;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.JavaParser;
import org.kingdoms.utils.internal.arrays.ArrayUtils;

public final class GeneralizedEventWatcher
implements Listener {
    private static final Listener INSTANCE = new GeneralizedEventWatcher();

    private GeneralizedEventWatcher() {
    }

    private static boolean isClassOneOf(Class<?> first, Class<?> ... others) {
        return Arrays.stream(others).anyMatch(x -> x == first);
    }

    public static void init() {
        YamlConfigAccessor events = KingdomsConfig.EVENTS.getManager().getSection().noDefault();
        for (Map.Entry<String, ConfigSection> eventEntry : events.getSection().getSections().entrySet()) {
            GeneralEventExecutor executor;
            Class<?> eventClass;
            try {
                Class<?> clazz = Class.forName(eventEntry.getKey());
                if (!Event.class.isAssignableFrom(clazz)) {
                    KLogger.error("The specified class '" + eventEntry.getKey() + "' is not an event.");
                    continue;
                }
                eventClass = clazz;
            }
            catch (ClassNotFoundException e) {
                KLogger.error("Unknown event: " + eventEntry.getKey());
                continue;
            }
            ConfigSection section = eventEntry.getValue();
            String priorityName = section.getString("priority");
            boolean ignoreCancelled = !section.isSet("ignore-cancelled") || section.getBoolean("ignore-cancelled");
            EventPriority priority = Strings.isNullOrEmpty((String)priorityName) ? EventPriority.NORMAL : (EventPriority)Enums.getIfPresent(EventPriority.class, (String)priorityName.toUpperCase(Locale.ENGLISH)).or((Object)EventPriority.NORMAL);
            ArrayList<Pair<ConditionalCompiler.LogicalOperand, List<ConfigCommand>>> commands = new ArrayList<Pair<ConditionalCompiler.LogicalOperand, List<ConfigCommand>>>();
            ConfigSection cmdSection = section.getSection("commands");
            if (cmdSection != null) {
                for (String condition : cmdSection.getKeys()) {
                    commands.add(Pair.of(ConditionalCompiler.compile(condition).evaluate(), ConfigCommand.parse(cmdSection.getStringList(condition))));
                }
            } else {
                commands.add(Pair.of(ConditionalCompiler.ConstantLogicalOperand.TRUE, ConfigCommand.parse(section.getStringList("commands"))));
            }
            ArrayList<Pair<String, MethodChain>> variables = new ArrayList<Pair<String, MethodChain>>();
            MethodChain primaryCtx = null;
            MethodChain secondaryCtx = null;
            ConfigSection contextSection = section.getSection("context");
            if (contextSection != null) {
                ConfigSection vars = contextSection.getSection("variables");
                if (vars != null) {
                    for (String varName : vars.getKeys()) {
                        variables.add(Pair.of(varName, JavaParser.parse(eventClass, vars.getString(varName))));
                    }
                }
                String primaryCtxStr = contextSection.getString("primary");
                String secondaryCtxStr = contextSection.getString("secondary");
                primaryCtx = primaryCtxStr == null ? null : JavaParser.parse(eventClass, primaryCtxStr);
                MethodChain methodChain = secondaryCtx = secondaryCtxStr == null ? null : JavaParser.parse(eventClass, secondaryCtxStr);
                if (primaryCtx != null && !GeneralizedEventWatcher.isClassOneOf(primaryCtx.getLastReturnType(), Player.class, OfflinePlayer.class, Nation.class, Kingdom.class, KingdomPlayer.class)) {
                    throw new IllegalArgumentException("The primary context method chain is wrong: " + primaryCtx);
                }
                if (secondaryCtx != null && !GeneralizedEventWatcher.isClassOneOf(secondaryCtx.getLastReturnType(), Player.class, OfflinePlayer.class, Nation.class, Kingdom.class, KingdomPlayer.class)) {
                    throw new IllegalArgumentException("The secondary context method chain is wrong: " + secondaryCtx);
                }
            }
            if (CascadingMessageContextProvider.class.isAssignableFrom(eventClass)) {
                executor = new ExactEventExecutor(commands, variables, primaryCtx, secondaryCtx);
            } else {
                ArrayList<Method> nativePlayerMethods = new ArrayList<Method>();
                ArrayList kingdomPlayerMethods = new ArrayList();
                ArrayList kingdomMethods = new ArrayList();
                ArrayList nationMethods = new ArrayList();
                for (Method method : eventClass.getMethods()) {
                    ArrayList<Method> addTo;
                    if (method.getParameterCount() > 0 || Modifier.isStatic(method.getModifiers())) continue;
                    Class<Object> returnType = method.getReturnType();
                    if (returnType.isAssignableFrom(Player.class)) {
                        addTo = nativePlayerMethods;
                    } else if (returnType.isAssignableFrom(OfflinePlayer.class) || returnType.isAssignableFrom(KingdomPlayer.class)) {
                        addTo = kingdomPlayerMethods;
                    } else if (returnType.isAssignableFrom(Kingdom.class)) {
                        addTo = kingdomMethods;
                    } else {
                        if (!returnType.isAssignableFrom(Nation.class)) continue;
                        addTo = nationMethods;
                    }
                    addTo.add(method);
                }
                KLogger.debug((DebugNS)KingdomsDebug.GENERALIZED$EVENT$WATCHER, () -> "Watching event '" + eventClass.getName() + "' with methods:\n    native: " + nativePlayerMethods + '\n' + "    Kingdom Player: " + kingdomPlayerMethods + '\n' + "    Kingdom: " + kingdomMethods + '\n' + "    Nation: " + nationMethods);
                executor = new ReflectiveEventExecutor(commands, variables, primaryCtx, secondaryCtx, nativePlayerMethods, kingdomPlayerMethods, kingdomMethods, nationMethods);
            }
            Bukkit.getPluginManager().registerEvent(eventClass, INSTANCE, priority, (EventExecutor)executor, (Plugin)Kingdoms.get(), ignoreCancelled);
        }
    }

    public static Method findMethodWithName(Class<?> clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static final class MethodChain {
        private final List<Method> methods;

        public MethodChain(List<Method> methods) {
            this.methods = methods;
        }

        public Class<?> getLastReturnType() {
            return ArrayUtils.getLast(this.methods).getReturnType();
        }

        public String toString() {
            return this.methods.get(0).getDeclaringClass() + " -> " + this.methods.stream().map(Method::toString).collect(Collectors.joining(" -> "));
        }

        public Object call(Object instance) {
            for (Method method : this.methods) {
                try {
                    instance = method.invoke(instance, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Error while invoking method '" + method.getName() + "' in chain: " + this, e);
                }
            }
            return instance;
        }
    }

    private static final class ExactEventExecutor
    extends GeneralEventExecutor {
        private ExactEventExecutor(List<Pair<ConditionalExpression, List<ConfigCommand>>> commands, List<Pair<String, MethodChain>> methodChains, MethodChain mainContext, MethodChain relationalSecondContext) {
            super(commands, methodChains, mainContext, relationalSecondContext);
        }

        @Override
        protected MessagePlaceholderProvider getMessageContext(Event event) {
            return ((CascadingMessageContextProvider)event).getMessageContext();
        }
    }

    private static final class ReflectiveEventExecutor
    extends GeneralEventExecutor {
        private final Method main;
        private final Method relationalSecond;

        private ReflectiveEventExecutor(List<Pair<ConditionalExpression, List<ConfigCommand>>> commands, List<Pair<String, MethodChain>> methodChains, MethodChain mainContext, MethodChain relationalSecondContext, List<Method> nativePlayerMethods, List<Method> kingdomPlayerMethods, List<Method> kingdomMethods, List<Method> nationMethods) {
            super(commands, methodChains, mainContext, relationalSecondContext);
            Method main = null;
            Method relationalSecond = null;
            ArrayList<Method> all = new ArrayList<Method>(5);
            all.addAll(nativePlayerMethods);
            all.addAll(kingdomPlayerMethods);
            all.addAll(kingdomMethods);
            all.addAll(nationMethods);
            for (Method meth : all) {
                if (main == null) {
                    main = meth;
                    continue;
                }
                relationalSecond = meth;
                break;
            }
            this.main = main;
            this.relationalSecond = relationalSecond;
        }

        @Override
        protected MessagePlaceholderProvider getMessageContext(Event event) {
            Object player;
            MessagePlaceholderProvider settings = new MessagePlaceholderProvider();
            try {
                settings.setPrimaryTarget(this.main == null ? null : this.main.invoke((Object)event, new Object[0]));
                settings.setSecondaryTarget(this.relationalSecond == null ? null : this.relationalSecond.invoke((Object)event, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (settings.getPrimaryTarget() instanceof Player) {
                player = (Player)settings.getPrimaryTarget();
            } else if (settings.getPrimaryTarget() instanceof OfflinePlayer) {
                player = ((OfflinePlayer)settings.getPrimaryTarget()).getPlayer();
                if (player == null) {
                    settings.withContext((OfflinePlayer)settings.getPrimaryTarget());
                }
            } else {
                player = settings.getPrimaryTarget() instanceof KingdomPlayer ? ((KingdomPlayer)settings.getPrimaryTarget()).getPlayer() : null;
            }
            if (player != null) {
                settings.withContext((Player)player);
            }
            return settings;
        }
    }

    private static abstract class GeneralEventExecutor
    implements EventExecutor {
        private final List<Pair<ConditionalExpression, List<ConfigCommand>>> commands;
        private final List<Pair<String, MethodChain>> methodChains;
        private final MethodChain mainContext;
        private final MethodChain relationalSecondContext;

        private GeneralEventExecutor(List<Pair<ConditionalExpression, List<ConfigCommand>>> commands, List<Pair<String, MethodChain>> methodChains, MethodChain mainContext, MethodChain relationalSecondContext) {
            this.commands = commands;
            this.methodChains = methodChains;
            this.mainContext = mainContext;
            this.relationalSecondContext = relationalSecondContext;
        }

        protected abstract MessagePlaceholderProvider getMessageContext(Event var1);

        public void execute(@NotNull Listener listener, @NotNull Event event) throws EventException {
            try {
                MessagePlaceholderProvider settings = this.getMessageContext(event);
                if (this.mainContext != null) {
                    settings.setPrimaryTarget(this.mainContext.call(event));
                }
                if (this.relationalSecondContext != null) {
                    settings.setSecondaryTarget(this.relationalSecondContext.call(event));
                }
                if (listener instanceof Cancellable) {
                    settings.raw("cancelled", ((Cancellable)listener).isCancelled());
                }
                Player player = settings.getPrimaryTarget() instanceof Player ? (Player)settings.getPrimaryTarget() : null;
                for (Pair<String, MethodChain> pair : this.methodChains) {
                    settings.parse(pair.getKey(), pair.getValue().call(event));
                }
                for (Pair<Object, Object> pair : this.commands) {
                    if (!ConditionProcessor.process((ConditionalExpression)pair.getKey(), settings)) continue;
                    ConfigCommand.execute(player, (Collection)pair.getValue(), settings, true);
                }
            }
            catch (Throwable ex) {
                throw new EventException(ex, "An error occurred while handled generalized event: " + event.getClass().getName());
            }
        }
    }

    private static final class Actions {
        private final List<ConfigCommand> commands;
        private final List<MethodChain> codes;

        private Actions(List<ConfigCommand> commands, List<MethodChain> codes) {
            this.commands = commands;
            this.codes = codes;
        }
    }

    private static final class DynamicMethodInvoker {
        private final Method method;
        private final Object[] parameters;

        private DynamicMethodInvoker(Method method, Object[] parameters) {
            this.method = method;
            this.parameters = parameters;
        }

        private Object invoke(Object instance, MessagePlaceholderProvider context) {
            Object[] newArgs = new Object[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                Object parameter = this.parameters[i];
                if (parameter instanceof String) {
                    MessageObject messageObject = MessageCompiler.compile((String)parameter, new MessageCompilerSettings(false, false, true, true, true, null));
                }
                newArgs[i] = parameter;
            }
            try {
                return this.method.invoke(instance, newArgs);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Error while invoking dynamic method: " + this, e);
            }
        }

        public String toString() {
            return this.method.toString() + '(' + Arrays.stream(this.parameters).map(Object::toString).collect(Collectors.joining(", ")) + ')';
        }
    }

    public static final class MethodCall
    extends Expression {
        private final Method method;
        private final Expression[] parameters;

        public MethodCall(Class<?> castAs, Method method, Expression[] parameters) {
            super(castAs);
            this.method = method;
            this.parameters = parameters;
        }

        @Override
        public String toString() {
            return super.toString() + ' ' + this.method.toString() + " -> (" + Arrays.toString(this.parameters) + ')';
        }
    }

    public static final class Variable
    extends Expression {
        private final String identifier;

        public Variable(Class<?> castAs, String identifier) {
            super(castAs);
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public String toString() {
            return super.toString() + ' ' + this.identifier;
        }
    }

    public static final class ConstantExpression
    extends Expression {
        private final Object object;

        public ConstantExpression(Class<?> castAs, Object object) {
            super(castAs);
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }

    public static abstract class Expression {
        private final Class<?> castAs;

        public Expression(Class<?> castAs) {
            this.castAs = castAs;
        }

        public Object cast(Object obj) {
            try {
                return this.castAs.cast(obj);
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("Cast failed for '" + this + "': " + ex.getMessage());
            }
        }

        public String toString() {
            return '(' + this.castAs.getName() + ')';
        }
    }
}

