/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.kingdoms.utils.fs.FSUtil;
import org.kingdoms.utils.internal.ByteArrayOutputStream;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public class BackupInfo {
    public final Map<String, BackupFile> files = new NonNullMap<String, BackupFile>();
    private final Path root;

    public BackupInfo(Path root) {
        this.root = root;
    }

    public void putFile(ZipFile zipFile, ZipEntry entry) {
        try (InputStream stream = zipFile.getInputStream(entry);
             ByteArrayOutputStream baos = new ByteArrayOutputStream(100);){
            FSUtil.transfer(stream, baos);
            String rawEntryName = entry.getName();
            String entryName = rawEntryName.replace('\\', '/');
            BackupFile file = this.files.get(entryName);
            Path path = this.root.resolve(rawEntryName);
            byte[] content = baos.getArray();
            if (file == null) {
                this.files.put(entryName, new BackupFile(entryName, path, content, null));
            } else {
                this.files.put(entryName, new BackupFile(entryName, path, content, file.restorer));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerRestorer(String entryName, Consumer<BackupFile> restorer) {
        BackupFile file = this.files.get(entryName);
        if (file == null) {
            this.files.put(entryName, new BackupFile(entryName, null, null, restorer));
        } else {
            this.files.put(entryName, new BackupFile(file.name, file.path, file.content, restorer));
        }
    }

    public static final class BackupFile {
        public final String name;
        public final Path path;
        public final byte[] content;
        public final Consumer<BackupFile> restorer;

        public boolean exists() {
            return this.content != null;
        }

        public BackupFile(String name, Path path, byte[] content, Consumer<BackupFile> restorer) {
            this.name = name;
            this.path = path;
            this.content = content;
            this.restorer = restorer;
        }

        public void copy(Path to) {
            ByteArrayInputStream input = new ByteArrayInputStream(this.content);
            try {
                Files.createDirectories(to.getParent(), new FileAttribute[0]);
                Files.copy(input, to, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

