/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.time.LocalDate;
import java.time.Month;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.libs.xseries.XEntityType;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XPotion;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.MathUtils;

public final class AprilFoolsManager
implements Listener {
    private static final Map<XMaterial, XMaterial> OPPOSITE_DAY;
    private static final Color[] COLORS;
    private static final boolean SUPPORTS_DEMO_SCREEN;

    private static String rainbow(String str) {
        int len = str.length();
        int color = 0;
        int incrementor = 0x1000000 / len;
        StringBuilder builder = new StringBuilder(len * 8);
        boolean isColor = false;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == ' ') {
                builder.append(' ');
                isColor = false;
                continue;
            }
            if (ch == '&') {
                isColor = true;
                builder.append('&');
                continue;
            }
            if (isColor) {
                builder.append(ch);
                continue;
            }
            builder.append("&#").append(Integer.toHexString(color));
            builder.append(ch);
            color += incrementor;
        }
        return builder.toString();
    }

    protected static boolean isAprilFools() {
        LocalDate date = LocalDate.now();
        return date.getMonth() == Month.APRIL && date.getDayOfMonth() == 1;
    }

    public AprilFoolsManager(Kingdoms plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (MathUtils.hasChance(50.0)) continue;
                XSound sound = MathUtils.hasChance(50.0) ? XSound.ENTITY_ENDER_DRAGON_AMBIENT : XSound.ENTITY_WITHER_AMBIENT;
                sound.record().soundPlayer().atLocation(player.getLocation()).play();
            }
        }, 20L, 600L);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (SUPPORTS_DEMO_SCREEN) {
            event.getPlayer().showDemoScreen();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBathWaterGet(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        if (event.getBlockClicked().getType().name().contains("WATER")) {
            return;
        }
        if (!MathUtils.hasChance(30.0)) {
            return;
        }
        MessageHandler.sendPluginMessage((CommandSender)player, "&2Congratulations, you've found gamer bath water!");
    }

    private static void celebrate(Location location) {
        Firework firework = (Firework)location.getWorld().spawnEntity(location, XEntityType.FIREWORK_ROCKET.get());
        FireworkMeta meta = firework.getFireworkMeta();
        FireworkEffect effect = FireworkEffect.builder().withColor((Iterable)Arrays.stream(COLORS).limit(MathUtils.randInt(5, 10)).collect(Collectors.toList())).with(FireworkEffect.Type.values()[MathUtils.randInt(0, FireworkEffect.Type.values().length - 1)]).withTrail().build();
        meta.addEffect(effect);
        meta.setPower(0);
        firework.setFireworkMeta(meta);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTurret(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)event.getEntity();
        Entity damager = event.getDamager();
        if (damager.hasMetadata("TURRET_ORIGIN")) {
            AprilFoolsManager.celebrate(entity2.getLocation());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        PlayerInventory inv = player.getInventory();
        if (MathUtils.hasChance(50.0)) {
            player.getWorld().dropItem(block.getLocation(), inv.getItemInMainHand());
            inv.setItemInMainHand(null);
        } else if (MathUtils.hasChance(30.0)) {
            for (BlockFace facing : BlockFace.values()) {
                Block relative = block.getRelative(facing);
                if (!relative.getType().name().endsWith("AIR")) continue;
                relative.setType(block.getType());
                event.setCancelled(true);
                break;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        PlayerInventory inv = player.getInventory();
        if (inv.getItemInMainHand().getType() != Material.AIR && MathUtils.hasChance(30.0)) {
            int empty = inv.firstEmpty();
            if (empty > -1) {
                XSound.ENTITY_ITEM_BREAK.record().soundPlayer().atLocation(player.getLocation()).play();
            }
        } else if (MathUtils.hasChance(70.0)) {
            XMaterial mat = XMaterial.matchXMaterial((Material)block.getType());
            XMaterial rep = OPPOSITE_DAY.get(mat);
            if (rep == null) {
                return;
            }
            block.setType(Material.AIR);
            player.getWorld().dropItem(block.getLocation(), rep.parseItem());
            event.setDropItems(false);
        }
        if (XReflection.supports((int)13) && MathUtils.hasChance(10.0) && XMaterial.matchXMaterial((Material)block.getType()) == XMaterial.SOUL_SAND) {
            player.getWorld().spawnEntity(player.getLocation(), EntityType.EVOKER_FANGS);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onChat(AsyncPlayerChatEvent event) {
        String msg = event.getMessage();
        msg = msg.replaceAll("fuck|cock|pussy|ass|cunt|nigg|faggot|nugget|labbe", "&k$0&r");
        event.setMessage(MessageHandler.colorize(AprilFoolsManager.rainbow(msg)));
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        event.setDeathMessage(event.getDeathMessage() + MessageHandler.colorize(" &cas a maidenless &lRUNT"));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void ongg(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)event.getEntity();
        if (entity2.getHealth() - event.getFinalDamage() <= 0.0) {
            return;
        }
        entity2.setMaximumNoDamageTicks(0);
        if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            event.setDamage(0.3);
        }
        switch (event.getCause()) {
            case FALL: {
                if (!XReflection.supports((int)14)) break;
                entity2.addPotionEffect(XPotion.LEVITATION.buildPotionEffect(100, 2));
                break;
            }
        }
    }

    static {
        boolean supportsDemoScreen;
        OPPOSITE_DAY = new EnumMap<XMaterial, XMaterial>(XMaterial.class);
        COLORS = new Color[50];
        try {
            Player.class.getMethod("showDemoScreen", new Class[0]);
            supportsDemoScreen = true;
        }
        catch (NoSuchMethodException e) {
            supportsDemoScreen = false;
        }
        SUPPORTS_DEMO_SCREEN = supportsDemoScreen;
        OPPOSITE_DAY.put(XMaterial.DIRT, XMaterial.COBBLESTONE);
        OPPOSITE_DAY.put(XMaterial.GRASS_BLOCK, XMaterial.SAND);
        OPPOSITE_DAY.put(XMaterial.SAND, XMaterial.DIRT);
        OPPOSITE_DAY.put(XMaterial.STONE, XMaterial.SHORT_GRASS);
        OPPOSITE_DAY.put(XMaterial.COBBLESTONE, XMaterial.DIRT);
        OPPOSITE_DAY.put(XMaterial.SANDSTONE, XMaterial.SAND);
        OPPOSITE_DAY.put(XMaterial.DIAMOND_ORE, XMaterial.GOLD_ORE);
        OPPOSITE_DAY.put(XMaterial.IRON_ORE, XMaterial.COAL);
        OPPOSITE_DAY.put(XMaterial.GOLD_ORE, XMaterial.IRON_INGOT);
        OPPOSITE_DAY.put(XMaterial.SHORT_GRASS, XMaterial.DEAD_BUSH);
        for (int i = 0; i < COLORS.length; ++i) {
            AprilFoolsManager.COLORS[i] = Color.fromRGB((int)MathUtils.randInt(0, 255), (int)MathUtils.randInt(0, 255), (int)MathUtils.randInt(0, 255));
        }
    }
}

