/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.time.Duration;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.cache.caffeine.CacheHandler;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;

public abstract class AfkF24Manager
implements Listener {
    private final Cache<UUID, Long> stopWatcher = CacheHandler.newBuilder().build();
    private final ConditionalExpression condition;
    private final Duration stopDuration;
    private final boolean considerCameraMovements;

    protected AfkF24Manager(ConditionalExpression condition, Duration stopDuration, boolean considerCameraMovements) {
        this.condition = condition;
        this.stopDuration = stopDuration;
        this.considerCameraMovements = considerCameraMovements;
    }

    protected abstract boolean filter(PlayerMoveEvent var1);

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onPlayerMove(PlayerMoveEvent event) {
        if (!this.filter(event)) {
            return;
        }
        if (!this.considerCameraMovements && !LocationUtils.hasMoved(event)) {
            return;
        }
    }

    public void track(Player player) {
        this.stopWatcher.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
    }

    public boolean isAfk(Player player) {
        Long lastStop = (Long)this.stopWatcher.getIfPresent((Object)player.getUniqueId());
        if (lastStop == null) {
            return false;
        }
        long passed = System.currentTimeMillis() - lastStop;
        return passed >= this.stopDuration.toMillis();
    }

    public void untrack(Player player) {
        this.stopWatcher.invalidate((Object)player.getUniqueId());
    }
}

