/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.placeholders.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.compiler.placeholders.Placeholder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderParser;
import org.kingdoms.locale.placeholders.PlaceholderParts;
import org.kingdoms.locale.placeholders.context.LazyPlaceholderProvider;
import org.kingdoms.locale.placeholders.context.LocalPlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.locale.placeholders.target.BasePlaceholderTargetProvider;
import org.kingdoms.locale.placeholders.target.PlaceholderTarget;
import org.kingdoms.locale.placeholders.target.PlaceholderTargetProvider;
import org.kingdoms.utils.cache.single.CachedSupplier;

public class PlaceholderContextBuilder
implements Cloneable,
LocalPlaceholderProvider,
PlaceholderTargetProvider {
    public static final PlaceholderContextBuilder DEFAULT = new PlaceholderContextBuilder();
    protected Map<String, Object> placeholders;
    protected Map<String, PlaceholderProvider> children;
    protected PlaceholderProvider unknownPlaceholderHandler;
    protected Object primaryTarget;
    protected Object secondaryTarget;
    protected Map<String, Object> targets;

    @Override
    public Object providePlaceholder(String placeholder) {
        Object local = this.provideLocalPlaceholder(new PlaceholderParts(placeholder));
        if (local != null) {
            return local;
        }
        Placeholder parsed = PlaceholderParser.parse(placeholder);
        Object translated = parsed.request(this);
        translated = parsed.process(translated);
        return translated;
    }

    @Override
    @Nullable
    public Object provideLocalPlaceholder(@NotNull PlaceholderParts placeholder) {
        Object unknown;
        PlaceholderProvider child;
        Object full;
        if (this.placeholders != null && (full = this.placeholders.get(placeholder.getFull())) != null) {
            return PlaceholderTranslationContext.unwrapPlaceholder(full);
        }
        if (this.children != null && (child = this.children.get(placeholder.getId())) != null) {
            return PlaceholderTranslationContext.unwrapPlaceholder(child.providePlaceholder(placeholder.getParameterFrom(1)));
        }
        if (this.unknownPlaceholderHandler != null && (unknown = this.unknownPlaceholderHandler.providePlaceholder(placeholder.getFull())) != null) {
            return PlaceholderTranslationContext.unwrapPlaceholder(unknown);
        }
        return null;
    }

    public PlaceholderContextBuilder clone() {
        return this.cloneInto(new PlaceholderContextBuilder());
    }

    public <T extends PlaceholderContextBuilder> T cloneInto(T ctx) {
        ctx.primaryTarget = this.primaryTarget;
        ctx.secondaryTarget = this.secondaryTarget;
        if (this.placeholders != null) {
            ctx.placeholders = new HashMap<String, Object>(this.placeholders);
        }
        if (this.children != null) {
            ctx.children = this.children;
        }
        return ctx;
    }

    public void setChildren(Map<String, PlaceholderProvider> children) {
        this.children = children;
    }

    public Map<String, PlaceholderProvider> getChildren() {
        return this.children;
    }

    public PlaceholderContextBuilder impregnate(int capacity) {
        if (this.children == null) {
            this.children = new HashMap<String, PlaceholderProvider>(capacity);
        }
        return this;
    }

    public PlaceholderContextBuilder addChild(String id, Supplier<PlaceholderProvider> provider) {
        this.addChild(id, new LazyPlaceholderProvider(provider));
        return this;
    }

    public PlaceholderContextBuilder addChild(String id, PlaceholderProvider provider) {
        if (id.contains("_")) {
            throw new IllegalArgumentException("Child element name cannot contain underscore, consider nesting groups instead or using another name: " + id);
        }
        this.impregnate(1);
        this.children.put(id, provider);
        return this;
    }

    private static void validateLength(Object[] edits) {
        if (edits.length % 2 == 1) {
            throw new IllegalArgumentException("Missing variable/replacement for one of edits, possibly: " + edits[edits.length - 1]);
        }
    }

    public PlaceholderContextBuilder inheritPlaceholders(PlaceholderContextBuilder other) {
        this.addAllIfAbsent(other.placeholders);
        if (this.children == null && other.children != null) {
            this.children = other.children;
        }
        return this;
    }

    public PlaceholderContextBuilder inheritContext(BasePlaceholderTargetProvider other, boolean replace) {
        if (replace || this.primaryTarget == null) {
            this.primaryTarget = other.getPrimaryTarget();
        }
        if (replace || this.secondaryTarget == null) {
            this.secondaryTarget = other.getSecondaryTarget();
        }
        return this;
    }

    public PlaceholderContextBuilder addAll(Map<String, Object> placeholders) {
        if (this.placeholders == null) {
            this.placeholders = placeholders;
            return this;
        }
        this.placeholders.putAll(placeholders);
        return this;
    }

    public PlaceholderContextBuilder addAllIfAbsent(Map<String, Object> placeholders) {
        if (placeholders == null || placeholders.isEmpty()) {
            return this;
        }
        if (this.placeholders == null) {
            this.placeholders = new HashMap<String, Object>(placeholders);
            return this;
        }
        for (Map.Entry<String, Object> placeholder : placeholders.entrySet()) {
            this.placeholders.putIfAbsent(placeholder.getKey(), placeholder.getValue());
        }
        return this;
    }

    public PlaceholderContextBuilder raws(Object ... edits) {
        this.variables(true, edits);
        return this;
    }

    public PlaceholderContextBuilder placeholders(Object ... edits) {
        this.variables(false, edits);
        return this;
    }

    protected PlaceholderContextBuilder variables(boolean raw, Object[] edits) {
        if (edits.length == 0) {
            return this;
        }
        PlaceholderContextBuilder.validateLength(edits);
        this.addAll(PlaceholderParser.serializeVariables(raw, this.placeholders, edits));
        return this;
    }

    public Map<String, Object> getPlaceholders() {
        return this.placeholders;
    }

    public boolean hasContext() {
        return this.primaryTarget != null;
    }

    public PlaceholderContextBuilder addTarget(String name, Object target) {
        this.getTargets0().put(name, target);
        return this;
    }

    public PlaceholderContextBuilder withContext(Player player) {
        if (player == null) {
            return this;
        }
        return this.withContext((OfflinePlayer)player);
    }

    public PlaceholderContextBuilder withContext(KingdomPlayer player) {
        Player online = player.getPlayer();
        if (online != null) {
            this.withContext(online);
        }
        OfflinePlayer offline = player.getOfflinePlayer();
        this.withContext(offline);
        return this;
    }

    public PlaceholderContextBuilder withContext(PlaceholderTarget target) {
        Object provided = target.provideTo(this);
        if (provided == null) {
            return this;
        }
        this.primaryTarget = provided;
        return this;
    }

    public PlaceholderContextBuilder withContext(OfflinePlayer player) {
        if (player == null) {
            return this;
        }
        this.primaryTarget = player;
        return this;
    }

    public PlaceholderContextBuilder withContext(CommandSender sender) {
        Objects.requireNonNull(sender);
        if (sender instanceof Player) {
            return this.withContext((Player)sender);
        }
        if (sender instanceof OfflinePlayer) {
            return this.withContext((OfflinePlayer)sender);
        }
        return this;
    }

    public PlaceholderContextBuilder withContext(Kingdom kingdom) {
        this.primaryTarget = kingdom;
        return this;
    }

    public PlaceholderContextBuilder withContext(Nation nation) {
        this.primaryTarget = nation;
        return this;
    }

    public PlaceholderContextBuilder withContext(Group group) {
        if (group == null) {
            return this;
        }
        if (group instanceof Kingdom) {
            return this.withContext((Kingdom)group);
        }
        if (group instanceof Nation) {
            return this.withContext((Nation)group);
        }
        throw new IllegalArgumentException("Unknown placeholder context for group: " + group.getClass() + " -> " + group);
    }

    public PlaceholderProvider getUnknownPlaceholderHandler() {
        return this.unknownPlaceholderHandler;
    }

    public PlaceholderProvider onUnknownPlaceholder(PlaceholderProvider unknownPlaceholderHandler) {
        this.unknownPlaceholderHandler = unknownPlaceholderHandler;
        return this;
    }

    public PlaceholderContextBuilder other(PlaceholderTarget target) {
        Object provided = target.provideTo(this);
        if (provided == null) {
            return this;
        }
        this.secondaryTarget = provided;
        return this;
    }

    public PlaceholderContextBuilder other(Player other) {
        this.secondaryTarget = other;
        return this;
    }

    public PlaceholderContextBuilder other(Kingdom other) {
        this.secondaryTarget = other;
        return this;
    }

    public PlaceholderContextBuilder ensurePlaceholdersCapacity(int amount) {
        if (this.placeholders == null) {
            this.placeholders = new HashMap<String, Object>(amount);
        }
        return this;
    }

    void ensurePlaceholdersCapacity() {
        this.ensurePlaceholdersCapacity(12);
    }

    public PlaceholderContextBuilder resetPlaceholders() {
        this.placeholders = null;
        return this;
    }

    public PlaceholderContextBuilder parse(String variable, Object replacement) {
        if (replacement == null) {
            return this;
        }
        if (PlaceholderTranslationContext.isRaw(replacement)) {
            this.raw(variable, replacement);
            return this;
        }
        this.ensurePlaceholdersCapacity();
        this.placeholders.put(variable, PlaceholderTranslationContext.withDefaultContext(replacement));
        return this;
    }

    public PlaceholderContextBuilder raw(String variable, Supplier<Object> replacement) {
        return this.raw(variable, CachedSupplier.of(replacement));
    }

    public PlaceholderContextBuilder raw(String variable, Object replacement) {
        if (replacement == null) {
            return this;
        }
        this.ensurePlaceholdersCapacity();
        this.placeholders.put(variable, replacement);
        return this;
    }

    public Object getPlaceholder(String str) {
        if (this.placeholders != null) {
            return this.placeholders.get(str);
        }
        return null;
    }

    public String toString() {
        return "MessageBuilder{ context=" + this.primaryTarget + ", other=" + this.secondaryTarget + ", placeholders=" + (this.placeholders == null ? "{}" : this.placeholders.entrySet().stream().map(entry -> String.valueOf(entry.getKey()) + '=' + entry.getValue()).collect(Collectors.toList())) + " }";
    }

    public void setPrimaryTarget(Object primaryTarget) {
        this.primaryTarget = primaryTarget;
    }

    public void setSecondaryTarget(Object secondaryTarget) {
        this.secondaryTarget = secondaryTarget;
    }

    @Override
    public PlaceholderTargetProvider switchTargets() {
        Object main = this.primaryTarget;
        this.primaryTarget = this.secondaryTarget;
        this.secondaryTarget = main;
        return this;
    }

    @Override
    @Nullable
    public Object getPrimaryTarget() {
        return this.primaryTarget;
    }

    @Override
    @Nullable
    public Object getSecondaryTarget() {
        return this.secondaryTarget;
    }

    @ApiStatus.Internal
    protected Map<String, Object> getTargets0() {
        if (this.targets == null) {
            this.targets = new HashMap<String, Object>(3);
        }
        return this.targets;
    }

    @Override
    public @NonNull Map<String, Object> getTargets() {
        return this.getTargets0();
    }
}

