/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.placeholders.context;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.placeholders.PlaceholderParts;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.locale.placeholders.target.BasePlaceholderTargetProvider;
import org.kingdoms.locale.placeholders.target.PlaceholderTarget;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.utils.cache.single.CachedSupplier;
import org.kingdoms.utils.string.Strings;

public class MessagePlaceholderProvider
extends PlaceholderContextBuilder {
    public boolean ignoreColors = false;
    public Boolean usePrefix;
    private @NonNull Language language = LanguageManager.getDefaultLanguage();
    public static final MessagePlaceholderProvider DEFAULT = new MessagePlaceholderProvider();

    @Override
    public MessagePlaceholderProvider placeholders(Object ... edits) {
        super.placeholders(edits);
        return this;
    }

    public MessagePlaceholderProvider lang(Language lang) {
        this.language = Objects.requireNonNull(lang);
        return this;
    }

    @Override
    public MessagePlaceholderProvider ensurePlaceholdersCapacity(int amount) {
        super.ensurePlaceholdersCapacity(amount);
        return this;
    }

    public MessagePlaceholderProvider viewer(OfflinePlayer player) {
        this.lang(KingdomPlayer.getKingdomPlayer(player).getLanguage());
        return this;
    }

    public MessagePlaceholderProvider viewer(KingdomPlayer kp) {
        this.lang(kp.getLanguage());
        return this;
    }

    public @NonNull Language getLanguage() {
        return this.language;
    }

    @Override
    public MessagePlaceholderProvider inheritPlaceholders(PlaceholderContextBuilder other) {
        super.inheritPlaceholders(other);
        if (other instanceof MessagePlaceholderProvider) {
            MessagePlaceholderProvider mb = (MessagePlaceholderProvider)other;
            this.language = mb.language;
            if (mb.ignoreColors) {
                this.ignoreColors = true;
            }
        }
        return this;
    }

    @Override
    @Nullable
    public Object provideLocalPlaceholder(@NotNull PlaceholderParts placeholder) {
        return PlaceholderTranslationContext.unwrapContextualPlaceholder(super.provideLocalPlaceholder(placeholder), this);
    }

    @Override
    public MessagePlaceholderProvider inheritContext(BasePlaceholderTargetProvider other, boolean replace) {
        super.inheritContext(other, replace);
        if (replace || this.primaryTarget == null) {
            if (other.getPrimaryTarget() instanceof Player) {
                this.withContext((Player)other.getPrimaryTarget());
            } else if (other.getPrimaryTarget() instanceof OfflinePlayer) {
                this.withContext((OfflinePlayer)other.getPrimaryTarget());
            }
        }
        return this;
    }

    @Override
    public MessagePlaceholderProvider addAll(Map<String, Object> placeholders) {
        super.addAll(placeholders);
        return this;
    }

    public MessagePlaceholderProvider addAll(PlaceholderContextBuilder ctx) {
        this.addAll((Map)ctx.getPlaceholders());
        return this;
    }

    @Override
    public MessagePlaceholderProvider addChild(String id, PlaceholderProvider provider) {
        super.addChild(id, provider);
        return this;
    }

    @Override
    public MessagePlaceholderProvider addChild(String id, Supplier<PlaceholderProvider> provider) {
        super.addChild(id, provider);
        return this;
    }

    @Override
    public MessagePlaceholderProvider addAllIfAbsent(Map<String, Object> placeholders) {
        super.addAllIfAbsent(placeholders);
        return this;
    }

    @Override
    public MessagePlaceholderProvider raws(Object ... edits) {
        super.raws(edits);
        return this;
    }

    public MessagePlaceholderProvider usePrefix() {
        return this.usePrefix(true);
    }

    public MessagePlaceholderProvider usePrefix(boolean usePrefix) {
        this.usePrefix = usePrefix;
        return this;
    }

    public MessagePlaceholderProvider ignoreColors() {
        this.ignoreColors = true;
        return this;
    }

    public MessagePlaceholderProvider dontIgnoreColors() {
        this.ignoreColors = false;
        return this;
    }

    @Override
    public MessagePlaceholderProvider withContext(OfflinePlayer player) {
        if (player == null) {
            return this;
        }
        super.withContext(player);
        this.raw("player", player);
        this.viewer(player);
        return this;
    }

    @Override
    public MessagePlaceholderProvider withContext(Player player) {
        if (player == null) {
            return this;
        }
        super.withContext(player);
        this.viewer((OfflinePlayer)player);
        this.parse("displayname", new CachedSupplier<String>(() -> {
            if (SoftService.VAULT.isAvailable() && ServiceVault.isAvailable(ServiceVault.Component.CHAT)) {
                return ServiceVault.getDisplayName(player);
            }
            return player.getDisplayName();
        }));
        this.parse("pure-displayname", new CachedSupplier<String>(() -> ((Player)player).getDisplayName()));
        return this;
    }

    @Override
    public MessagePlaceholderProvider withContext(CommandSender sender) {
        if (sender instanceof Player) {
            return this.withContext((Player)sender);
        }
        if (sender instanceof OfflinePlayer) {
            return this.withContext((OfflinePlayer)sender);
        }
        return this;
    }

    @Override
    public MessagePlaceholderProvider withContext(PlaceholderTarget target) {
        super.withContext(target);
        return this;
    }

    @Override
    public MessagePlaceholderProvider withContext(Kingdom kingdom) {
        super.withContext(kingdom);
        return this;
    }

    @Override
    public MessagePlaceholderProvider withContext(Nation nation) {
        super.withContext(nation);
        return this;
    }

    @Override
    public MessagePlaceholderProvider withContext(Group group) {
        super.withContext(group);
        return this;
    }

    @Override
    public MessagePlaceholderProvider other(Player other) {
        super.other(other);
        if (other != null) {
            this.raw("player_other_name", other.getName());
        }
        return this;
    }

    @Override
    public MessagePlaceholderProvider other(PlaceholderTarget target) {
        super.other(target);
        return this;
    }

    @Override
    public MessagePlaceholderProvider other(Kingdom other) {
        super.other(other);
        return this;
    }

    @Override
    public MessagePlaceholderProvider resetPlaceholders() {
        super.resetPlaceholders();
        return this;
    }

    @Override
    public MessagePlaceholderProvider parse(String variable, Object replacement) {
        super.parse(variable, replacement);
        return this;
    }

    @Override
    public MessagePlaceholderProvider raw(String variable, Object replacement) {
        super.raw(variable, replacement);
        return this;
    }

    @Override
    public MessagePlaceholderProvider raw(String variable, Supplier<Object> replacement) {
        super.raw(variable, replacement);
        return this;
    }

    @Override
    public String toString() {
        return "MessageBuilder{ context=" + this.primaryTarget + ", ignoreColors=" + this.ignoreColors + ", prefix=" + this.usePrefix + ", other=" + this.secondaryTarget + ", Children=" + Strings.associatedArrayMap(this.children) + ", placeholders=" + (this.placeholders == null ? "{}" : this.placeholders.entrySet().stream().map(entry -> String.valueOf(entry.getKey()) + '=' + entry.getValue()).collect(Collectors.toList())) + " }";
    }

    @Override
    public MessagePlaceholderProvider clone() {
        MessagePlaceholderProvider builder = new MessagePlaceholderProvider();
        this.cloneInto(builder);
        builder.usePrefix = this.usePrefix;
        builder.ignoreColors = this.ignoreColors;
        return builder;
    }
}

