/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.messenger;

import java.util.Objects;
import java.util.function.Function;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.provider.MessageProvider;

public final class ProcessedMessenger
implements Messenger {
    private final Messenger original;
    private final Function<MessageProvider, MessageProvider> processor;

    public ProcessedMessenger(Messenger original, Function<MessageProvider, MessageProvider> processor) {
        this.original = Objects.requireNonNull(original);
        this.processor = Objects.requireNonNull(processor);
    }

    @Override
    public MessageProvider getProvider(Language locale) {
        return this.processor.apply(this.original.getProvider(locale));
    }

    public static final class RepeatProcessor
    implements Function<MessageProvider, MessageProvider> {
        private final int repeat;

        public RepeatProcessor(int repeat) {
            this.repeat = repeat;
        }

        @Override
        public MessageProvider apply(MessageProvider messageProvider) {
            MessageObject msg;
            MessageObject repeated = msg = messageProvider.getMessage();
            for (int i = 1; i < this.repeat; ++i) {
                repeated = repeated.merge(new MessageObject(msg.getPieces(), false));
            }
            return new MessageProvider(repeated);
        }
    }
}

