/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.messenger;

import java.util.Objects;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.MessageProvider;

public interface Messenger {
    default public String parse(@Nullable Player player, Object ... edits) {
        return this.parse(LanguageManager.localeOf(player), this.createDefaultContext((CommandSender)player, edits));
    }

    default public String parse(MessagePlaceholderProvider settings) {
        return this.parse(settings.getLanguage(), settings);
    }

    default public String parse(@Nullable OfflinePlayer player, Object ... edits) {
        return this.parse(LanguageManager.localeOf(player), this.createDefaultContext(null, edits).withContext(player));
    }

    default public String parse(Language locale, @NonNull MessagePlaceholderProvider context) {
        MessageObject obj = this.getMessageObject(locale);
        return obj == null ? null : obj.buildPlain(this.processContext(context));
    }

    default public String parse(CommandSender sender, Object ... edits) {
        if (!(sender instanceof OfflinePlayer)) {
            return this.parse(edits);
        }
        return this.parse((OfflinePlayer)sender, edits);
    }

    public @Nullable MessageProvider getProvider(@NotNull Language var1);

    default public @Nullable MessageObject getMessageObject(@NotNull Language language) {
        Objects.requireNonNull(language, "Language is null");
        MessageProvider provider = this.getProvider(language);
        return provider == null ? null : provider.getMessage();
    }

    default public String parse(Object ... edits) {
        return this.parse((Player)null, edits);
    }

    default public void sendError(CommandSender receiver, MessagePlaceholderProvider settings) {
        if (receiver instanceof Player) {
            Player player = (Player)receiver;
            KingdomsConfig.errorSound(player);
        }
        this.sendMessage(receiver, settings);
    }

    default public void sendError(CommandSender receiver, Object ... edits) {
        this.sendError(receiver, this.createDefaultContext(receiver, edits));
    }

    default public void sendMessage(CommandSender receiver, Object ... edits) {
        this.sendMessage(receiver, this.createDefaultContext(receiver, edits));
    }

    default public void sendMessage(CommandSender receiver, MessagePlaceholderProvider context) {
        context = this.processContext(context);
        if (KingdomsConfig.PREFIX.getBoolean()) {
            context.usePrefix(true);
        }
        Language locale = context.getLanguage();
        if (receiver instanceof Player) {
            Player player = (Player)receiver;
            locale = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player).getLanguage();
            context.lang(locale);
        }
        Language finalLocale = locale;
        MessageProvider provider = Objects.requireNonNull(this.getProvider(locale), () -> "Message for locale '" + finalLocale + "' is not defined: " + this);
        provider.send(receiver, context);
    }

    default public void sendMessage(CommandSender receiver) {
        this.sendMessage(receiver, this.createDefaultContext(receiver, new Object[0]));
    }

    @NotNull
    default public MessagePlaceholderProvider processContext(@NotNull MessagePlaceholderProvider context) {
        return context;
    }

    @NotNull
    default public MessagePlaceholderProvider createDefaultContext(CommandSender receiver, Object ... edits) {
        return new MessagePlaceholderProvider().withContext(receiver).placeholders(edits);
    }
}

