/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.messenger;

import java.util.function.Supplier;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.messenger.DefaultedMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.OptionalMessenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.provider.MessageProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001d\b\u0016\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0004\b\u0004\u0010\tJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016J\u0006\u0010\u0017\u001a\u00020\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001cH\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/kingdoms/locale/messenger/LanguageEntryMessenger;", "Lorg/kingdoms/locale/messenger/Messenger;", "entry", "Lorg/kingdoms/locale/LanguageEntry;", "<init>", "(Lorg/kingdoms/locale/LanguageEntry;)V", "path", "", "", "([Ljava/lang/String;)V", "getEntry", "()Lorg/kingdoms/locale/LanguageEntry;", "getProvider", "Lorg/kingdoms/locale/provider/MessageProvider;", "locale", "Lorg/kingdoms/locale/Language;", "toString", "optional", "Lorg/kingdoms/locale/messenger/OptionalMessenger;", "or", "Lorg/kingdoms/locale/messenger/DefaultedMessenger;", "other", "Ljava/util/function/Supplier;", "safe", "hashCode", "", "equals", "", "", "Companion", "core"})
public class LanguageEntryMessenger
implements Messenger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageEntry entry;

    public LanguageEntryMessenger(@NotNull LanguageEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entry = entry;
    }

    @NotNull
    public final LanguageEntry getEntry() {
        return this.entry;
    }

    public LanguageEntryMessenger(String ... path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(new LanguageEntry(path));
    }

    @Override
    @Nullable
    public MessageProvider getProvider(@NotNull Language locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return locale.getMessage(this.entry, false);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("LanguageEntryMessenger{");
        String[] stringArray = this.entry.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getPath(...)");
        return stringBuilder.append(ArraysKt.joinToString$default((Object[])stringArray, (CharSequence)" -> ", null, null, (int)0, null, null, (int)62, null)).append('}').toString();
    }

    @NotNull
    public final OptionalMessenger optional() {
        return new OptionalMessenger(this);
    }

    @NotNull
    public final DefaultedMessenger or(@NotNull Supplier<Messenger> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return new DefaultedMessenger(this, other);
    }

    @NotNull
    public final DefaultedMessenger safe() {
        return this.or(() -> LanguageEntryMessenger.safe$lambda$0(this));
    }

    public int hashCode() {
        return this.entry.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof LanguageEntryMessenger && Intrinsics.areEqual((Object)this.entry, (Object)((LanguageEntryMessenger)other).entry);
    }

    private static final Messenger safe$lambda$0(LanguageEntryMessenger this$0) {
        StringBuilder stringBuilder = new StringBuilder().append("&8[&4Error&8] &eMessage path not defined even for EN language &c");
        String[] stringArray = this$0.entry.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getPath(...)");
        return new StaticMessenger(stringBuilder.append(ArraysKt.joinToString$default((Object[])stringArray, (CharSequence)" &7-> &c", null, null, (int)0, null, null, (int)62, null)).toString());
    }

    @JvmStatic
    @NotNull
    public static final LanguageEntryMessenger of(@NotNull String str) {
        return Companion.of(str);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/locale/messenger/LanguageEntryMessenger$Companion;", "", "<init>", "()V", "of", "Lorg/kingdoms/locale/messenger/LanguageEntryMessenger;", "str", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LanguageEntryMessenger of(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            LanguageEntry languageEntry = LanguageEntry.fromString(str);
            Intrinsics.checkNotNullExpressionValue((Object)languageEntry, (String)"fromString(...)");
            return new LanguageEntryMessenger(languageEntry);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

