/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.messenger;

import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.ContextualMessageObject;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.MessageProvider;

public class ContextualMessenger
implements Messenger {
    private final Messenger messenger;
    private final MessagePlaceholderProvider context;

    public ContextualMessenger(Messenger messenger, MessagePlaceholderProvider context) {
        this.messenger = messenger;
        this.context = context;
    }

    @Override
    public @Nullable MessageProvider getProvider(@NotNull Language locale) {
        MessageObject object = this.messenger.getMessageObject(locale);
        return object == null ? null : new MessageProvider(new ContextualMessageObject(object, this.context));
    }

    @Override
    public MessageObject getMessageObject(Language language) {
        Objects.requireNonNull(language, "Language is null");
        MessageObject msgObj = this.messenger.getMessageObject(language);
        return msgObj == null ? null : new ContextualMessageObject(msgObj, this.context);
    }

    @Override
    @NotNull
    public MessagePlaceholderProvider processContext(@NotNull MessagePlaceholderProvider context) {
        return this.context.inheritContext(context, true).inheritPlaceholders(context);
    }

    @Override
    public MessagePlaceholderProvider createDefaultContext(CommandSender receiver, Object ... edits) {
        return this.context.placeholders(edits).withContext(receiver);
    }
}

