/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.messenger;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.CombinedMessageObject;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.provider.MessageProvider;

public final class CombinedMessenger
implements Messenger {
    private final List<Messenger> messengers;

    public CombinedMessenger(List<Messenger> messengers) {
        this.messengers = messengers;
    }

    public CombinedMessenger(Messenger ... messengers) {
        this(Arrays.stream(messengers).collect(Collectors.toList()));
    }

    public List<Messenger> getMessengers() {
        return this.messengers;
    }

    public void add(Messenger messenger) {
        this.messengers.add(messenger);
    }

    @Override
    public MessageProvider getProvider(Language locale) {
        return new MessageProvider(this.getMessageObject(locale));
    }

    @Override
    public MessageObject getMessageObject(Language language) {
        return new CombinedMessageObject((MessageObject[])this.messengers.stream().map(x -> x.getMessageObject(language)).toArray(MessageObject[]::new));
    }
}

