/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.placeholders.types;

import java.util.List;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.placeholders.modifiers.PlaceholderModifier;
import org.kingdoms.locale.compiler.placeholders.types.AbstractPlaceholder;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/types/MacroPlaceholder;", "Lorg/kingdoms/locale/compiler/placeholders/types/AbstractPlaceholder;", "originalString", "", "name", "pointer", "modifiers", "", "Lorg/kingdoms/locale/compiler/placeholders/modifiers/PlaceholderModifier;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "asString", "full", "", "request", "", "provider", "Lorg/kingdoms/locale/placeholders/context/PlaceholderProvider;", "core"})
public final class MacroPlaceholder
extends AbstractPlaceholder {
    @NotNull
    private final String name;

    public MacroPlaceholder(@NotNull String originalString, @NotNull String name, @Nullable String pointer, @NotNull List<? extends PlaceholderModifier> modifiers) {
        Intrinsics.checkNotNullParameter((Object)originalString, (String)"originalString");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        super(originalString, pointer, modifiers);
        this.name = name;
    }

    @Override
    @NotNull
    public String asString(boolean full) {
        String common = this.getCommonString(false, this.name);
        return full ? "{$" + common + '}' : common;
    }

    @Override
    @Nullable
    public Object request(@NotNull PlaceholderProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        if (!(provider instanceof MessagePlaceholderProvider)) {
            return MessageCompiler.compile("&cUnsupported provided context: " + provider);
        }
        MessageObject macro = ((MessagePlaceholderProvider)provider).getLanguage().getVariable((MessagePlaceholderProvider)provider, this.name, false);
        Object object = macro;
        if (object == null) {
            object = new StaticMessenger("&8(&4Unknown macro/variable &e'" + this.name + "'&8)");
        }
        return object;
    }
}

