/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.placeholders.types;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.compiler.placeholders.functions.PlaceholderFunctionData;
import org.kingdoms.locale.compiler.placeholders.functions.PlaceholderFunctionInvoker;
import org.kingdoms.locale.compiler.placeholders.modifiers.PlaceholderModifier;
import org.kingdoms.locale.compiler.placeholders.types.AbstractPlaceholder;
import org.kingdoms.locale.placeholders.KingdomsPlaceholderTranslationContext;
import org.kingdoms.locale.placeholders.KingdomsPlaceholderTranslator;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.locale.placeholders.target.BasePlaceholderTargetProvider;
import org.kingdoms.locale.placeholders.target.PlaceholderTargetProvider;

public class KingdomsPlaceholder
extends AbstractPlaceholder {
    public final @NonNull KingdomsPlaceholderTranslator identifier;
    private final @Nullable PlaceholderFunctionData function;

    public KingdomsPlaceholder(String originalString, @NotNull String pointer, @NotNull List<PlaceholderModifier> modifiers, @NonNull KingdomsPlaceholderTranslator translator, @Nullable PlaceholderFunctionData function) {
        super(originalString, pointer, modifiers);
        this.identifier = translator;
        this.function = function;
    }

    public @Nullable PlaceholderFunctionData getFunction() {
        return this.function;
    }

    public @NonNull PlaceholderFunctionInvoker requireFunction(String ... possible) {
        if (this.function == null) {
            this.error("Function '" + Arrays.toString(possible) + "' required but none was provided for '" + this.asString(true) + '\'');
        }
        if (Arrays.stream(possible).noneMatch(fn -> this.function.getFunctionName().equalsIgnoreCase((String)fn))) {
            this.error("Function '" + Arrays.toString(possible) + "' required but none was provided for '" + this.asString(true) + '\'');
        }
        return this.function.newSession(this);
    }

    @Override
    @NotNull
    public Object request(@NotNull PlaceholderProvider provider) {
        PlaceholderTargetProvider originalTargetProvider;
        BasePlaceholderTargetProvider targetProvider;
        Object translated;
        if (!(provider instanceof PlaceholderTargetProvider)) {
            this.error("Cannot use kingdoms placeholder on a non-target provider " + provider);
        }
        if ((translated = this.identifier.translate(new KingdomsPlaceholderTranslationContext(targetProvider = (originalTargetProvider = (PlaceholderTargetProvider)provider).getTargetProviderFor(this.getPointer()), this))) != null) {
            translated = KingdomsPlaceholder.wrapWithDefaultContextProvider(translated);
        }
        return translated;
    }

    @Override
    @NotNull
    public String asString(boolean full) {
        return this.getCommonString(full, this.getOriginalString());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '(' + "originalString='" + this.getOriginalString() + '\'' + ", pointer=" + this.getPointer() + ", identifier=" + this.identifier + ", modifiers=" + this.getModifiers().stream().map(PlaceholderModifier::getName).collect(Collectors.toList()) + ", function=" + this.function + ')';
    }
}

