/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.placeholders.functions;

import java.util.List;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.KotlinNothingValueException;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.locale.compiler.placeholders.functions.PlaceholderFunctionData;
import org.kingdoms.locale.compiler.placeholders.functions.PlaceholderFunctionInvoker;
import org.kingdoms.locale.compiler.placeholders.types.KingdomsPlaceholder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bJ\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/functions/PlaceholderPositionalFunctionInvoker;", "Lorg/kingdoms/locale/compiler/placeholders/functions/PlaceholderFunctionInvoker;", "placeholder", "Lorg/kingdoms/locale/compiler/placeholders/types/KingdomsPlaceholder;", "function", "Lorg/kingdoms/locale/compiler/placeholders/functions/PlaceholderFunctionData;", "parameters", "", "", "<init>", "(Lorg/kingdoms/locale/compiler/placeholders/types/KingdomsPlaceholder;Lorg/kingdoms/locale/compiler/placeholders/functions/PlaceholderFunctionData;Ljava/util/List;)V", "getPlaceholder", "()Lorg/kingdoms/locale/compiler/placeholders/types/KingdomsPlaceholder;", "getFunction", "()Lorg/kingdoms/locale/compiler/placeholders/functions/PlaceholderFunctionData;", "position", "", "has", "", "name", "next", "getBool", "getInt", "checkRemaining", "", "getString", "core"})
public final class PlaceholderPositionalFunctionInvoker
implements PlaceholderFunctionInvoker {
    @NotNull
    private final KingdomsPlaceholder placeholder;
    @NotNull
    private final PlaceholderFunctionData function;
    @NotNull
    private final List<String> parameters;
    private int position;

    public PlaceholderPositionalFunctionInvoker(@NotNull KingdomsPlaceholder placeholder, @NotNull PlaceholderFunctionData function, @NotNull List<String> parameters) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.placeholder = placeholder;
        this.function = function;
        this.parameters = parameters;
    }

    @Override
    @NotNull
    public KingdomsPlaceholder getPlaceholder() {
        return this.placeholder;
    }

    @Override
    @NotNull
    public PlaceholderFunctionData getFunction() {
        return this.function;
    }

    @Override
    public boolean has(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.parameters.size() >= this.position + 1;
    }

    @NotNull
    public final String next(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.has("")) {
            this.getPlaceholder().error("Missing function parameter '" + name + '\'');
            throw new KotlinNothingValueException();
        }
        int n = this.position;
        this.position = n + 1;
        return this.parameters.get(n);
    }

    @Override
    public boolean getBool(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Boolean bl = StringsKt.toBooleanStrictOrNull((String)this.next(name));
        if (bl == null) {
            this.getPlaceholder().error("Argument '" + name + "' is not a boolean");
            throw new KotlinNothingValueException();
        }
        return bl;
    }

    @Override
    public int getInt(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = StringsKt.toIntOrNull((String)this.next(name));
        if (n == null) {
            this.getPlaceholder().error("Argument '" + name + "' is not a number");
            throw new KotlinNothingValueException();
        }
        return n;
    }

    @Override
    public void checkRemaining() {
        if (this.has("")) {
            this.getPlaceholder().error("Unexpected extra parameter(s): " + CollectionsKt.drop((Iterable)this.parameters, (int)(this.position + 1)));
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public String getString(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.next(name);
    }
}

