/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.placeholders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.kotlin.ranges.IntRange;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.compiler.placeholders.CursorList;
import org.kingdoms.locale.compiler.placeholders.Placeholder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderLexer;
import org.kingdoms.locale.compiler.placeholders.PlaceholderParseException;
import org.kingdoms.locale.compiler.placeholders.functions.PlaceholderFunctionData;
import org.kingdoms.locale.compiler.placeholders.functions.PlaceholderFunctionParameters;
import org.kingdoms.locale.compiler.placeholders.functions.PlaceholderNamedFunctionParameters;
import org.kingdoms.locale.compiler.placeholders.functions.PlaceholderPositionalFunctionParameters;
import org.kingdoms.locale.compiler.placeholders.modifiers.PlaceholderModifier;
import org.kingdoms.locale.compiler.placeholders.types.ExternalOrLocalPlaceholder;
import org.kingdoms.locale.compiler.placeholders.types.KingdomsPlaceholder;
import org.kingdoms.locale.compiler.placeholders.types.PermissionPlaceholder;
import org.kingdoms.locale.placeholders.FunctionalPlaceholder;
import org.kingdoms.locale.placeholders.KingdomsPlaceholderTranslator;
import org.kingdoms.utils.internal.functional.Fn;

public final class PlaceholderParser {
    private boolean rel = false;
    private boolean assumeKingdomsId;
    private String pointer;
    private String id;
    private String parameter;
    private PlaceholderFunctionData function;
    private final List<PlaceholderModifier> modifiers = new ArrayList<PlaceholderModifier>();
    private final PlaceholderLexer lexer;
    private PlaceholderLexer.Token lastExpectedToken;
    private final CursorList<PlaceholderLexer.Token> tokens;
    private final TokenRef tokenRef = new TokenRef();

    public Phase getPhase() {
        if (!this.modifiers.isEmpty()) {
            return Phase.MODIFIER;
        }
        if (this.function != null) {
            return Phase.FUNCTION;
        }
        if (this.pointer != null) {
            return Phase.POINTER;
        }
        return Phase.NONE;
    }

    public int getEndIndex() {
        return this.lexer.getIndex();
    }

    public String getFullString() {
        return this.lexer.getFullString();
    }

    private PlaceholderParser(PlaceholderLexer lexer) {
        this.lexer = lexer;
        this.tokens = new CursorList<PlaceholderLexer.Token>(lexer.getTokens());
    }

    @Nullable
    public static Placeholder parse(String fullPlaceholder) {
        return PlaceholderParser.parse(fullPlaceholder, false);
    }

    @Nullable
    public static Placeholder parse(String fullPlaceholder, boolean assumeKingdomsId) {
        PlaceholderParser parser = PlaceholderParser.parse(0, fullPlaceholder.toCharArray(), false);
        if (parser == null) {
            return null;
        }
        parser.assumeKingdomsId = assumeKingdomsId;
        return parser.getPlaceholder();
    }

    @Nullable
    public static PlaceholderParser parse(int start, char[] chars, boolean lookForClosure) {
        PlaceholderLexer lexer = new PlaceholderLexer(start, chars, lookForClosure);
        switch (lexer.getResult()) {
            case SUCCESS: {
                break;
            }
            case NOT_A_PLACEHOLDER: 
            case CLOSING_CLOSURE_NOT_FOUND: {
                return null;
            }
        }
        return new PlaceholderParser(lexer);
    }

    public String collectSeparatedStrings() {
        if (!this.tokens.hasNext()) {
            this.error(this.tokens.current(), "Placeholder ended unexpectedly, can't collect.");
        }
        StringBuilder namespaced = new StringBuilder(50);
        boolean lastWasString = false;
        while (this.tokens.hasNext()) {
            PlaceholderLexer.Token next = this.tokens.next();
            if (next instanceof PlaceholderLexer.StringToken) {
                if (lastWasString) {
                    this.error(this.tokens.previous(), "Expected a separator after string");
                }
                namespaced.append(((PlaceholderLexer.StringToken)next).getString());
                lastWasString = true;
                continue;
            }
            PlaceholderLexer.CharToken charToken = (PlaceholderLexer.CharToken)next;
            lastWasString = false;
            if (charToken.getType() == PlaceholderLexer.CharTokenType.SEPARATOR) {
                namespaced.append('_');
                continue;
            }
            this.tokens.previous();
            break;
        }
        return namespaced.toString();
    }

    public void collectModifiers() {
        int currentState = this.tokens.getCursor();
        if (!(this.tokens.current() instanceof PlaceholderLexer.StringToken)) {
            return;
        }
        String modifierName = this.collectSeparatedStrings();
        if (!this.charToken(PlaceholderLexer.CharTokenType.MODIFIER)) {
            this.tokens.setCursor(currentState);
            return;
        }
        PlaceholderModifier modifier = PlaceholderModifier.get(modifierName);
        this.tokenRef.modifiers = new IntRange(currentState, this.tokens.getCursor());
        if (modifier != null) {
            this.modifiers.add(modifier);
        } else {
            this.error(this.lastExpectedToken, "Unknown placeholder modifier: " + modifierName);
        }
        this.collectModifiers();
    }

    private <T extends PlaceholderLexer.Token> T expectToken(Class<T> tokenType) {
        if (!this.tokens.hasNext()) {
            return null;
        }
        this.lastExpectedToken = this.tokens.next();
        PlaceholderLexer.Token token = (PlaceholderLexer.Token)Fn.safeCast(this.lastExpectedToken, tokenType);
        if (token == null) {
            this.tokens.previous();
        }
        return (T)token;
    }

    private String stringToken() {
        return this.stringToken(null);
    }

    private String stringToken(String error) {
        PlaceholderLexer.StringToken token = this.expectToken(PlaceholderLexer.StringToken.class);
        if (token == null && error != null) {
            this.error(this.lastExpectedToken, error);
        }
        return token == null ? null : token.getString();
    }

    private boolean charToken(PlaceholderLexer.CharTokenType type) {
        return this.charToken(type, null);
    }

    private boolean charToken(PlaceholderLexer.CharTokenType type, String error) {
        PlaceholderLexer.CharToken charType = this.expectToken(PlaceholderLexer.CharToken.class);
        if (charType == null && error != null) {
            this.error(this.lastExpectedToken, error);
        }
        if (charType != null && charType.getType() == type) {
            return true;
        }
        this.tokens.previous();
        return false;
    }

    private RuntimeException error(PlaceholderLexer.Token token, String msg) {
        throw new PlaceholderParseException(msg + " for token " + token + " at " + token.getStartIndex() + " in placeholder '" + this.lexer.getFullString() + '\'');
    }

    private RuntimeException error(int pointerStart, int pointerEnd, String msg) {
        throw new PlaceholderParseException(msg + " at " + pointerStart + " '" + this.lexer.getFullString().substring(pointerStart, pointerEnd) + "' in placeholder '" + this.lexer.getFullString() + '\'');
    }

    private boolean isNextTokenRelational() {
        int currentState = this.tokens.getCursor();
        String strToken = this.stringToken();
        if (strToken == null) {
            return false;
        }
        this.tokenRef.rel = (PlaceholderLexer.StringToken)this.lastExpectedToken;
        boolean relational = strToken.equals("rel");
        if (relational) {
            if (!this.charToken(PlaceholderLexer.CharTokenType.SEPARATOR)) {
                this.tokens.setCursor(currentState);
                return false;
            }
        } else {
            this.tokens.setCursor(currentState);
            return false;
        }
        return true;
    }

    String parsePointer() {
        if (!this.tokens.hasNext(2)) {
            return null;
        }
        int currentCursor = this.tokens.getCursor();
        String pointerName = this.collectSeparatedStrings();
        if (!this.charToken(PlaceholderLexer.CharTokenType.POINTER)) {
            this.tokens.setCursor(currentCursor);
            return null;
        }
        return pointerName;
    }

    private void parseLegacyModifiers(boolean supportsOther) {
        int currentCursor = this.tokens.getCursor();
        String next = this.stringToken();
        if (next == null) {
            return;
        }
        if (next.equals("other")) {
            this.pointer = "other";
            if (!supportsOther) {
                this.error(this.tokens.previous(), "'other' modifier not expected here");
            }
            this.charToken(PlaceholderLexer.CharTokenType.SEPARATOR, "Expected placeholder ID after legacy pointer");
        } else {
            Optional<PlaceholderModifier> mod = PlaceholderModifier.getRegistered().values().stream().filter(x -> x.getName().equals(next)).findFirst();
            if (mod.isPresent()) {
                PlaceholderModifier modifier = mod.get();
                this.modifiers.add(modifier);
                this.charToken(PlaceholderLexer.CharTokenType.SEPARATOR, "Expected placeholder ID after legacy modifier");
            } else {
                this.tokens.setCursor(currentCursor);
            }
        }
    }

    private void parseFunction() {
        PlaceholderFunctionParameters parameters;
        String fnName;
        block14: {
            boolean isPositional;
            if (!this.charToken(PlaceholderLexer.CharTokenType.FUNCTION_START)) {
                return;
            }
            fnName = this.stringToken("Expected a placeholder function name");
            int revertParameters = this.tokens.getCursor();
            String parasadm = this.stringToken("Expected placeholder function parameters");
            if (this.charToken(PlaceholderLexer.CharTokenType.FUNCTION_ARGUMENT_SEPARATOR)) {
                isPositional = true;
            } else if (this.charToken(PlaceholderLexer.CharTokenType.FUNCTION_ARGUMENT_EQUAL)) {
                isPositional = false;
            } else {
                if (this.tokens.hasNext()) {
                    throw this.error(this.lastExpectedToken, "Unexpected character in function parameters '" + fnName + "' - '" + parasadm + "' - " + this.tokens.current());
                }
                isPositional = false;
            }
            this.tokens.setCursor(revertParameters);
            if (isPositional) {
                ArrayList<String> params = new ArrayList<String>();
                parameters = new PlaceholderPositionalFunctionParameters(params);
                do {
                    String param = this.stringToken("Expected parameter value");
                    params.add(param);
                    if (!this.tokens.hasNext()) break block14;
                } while (this.charToken(PlaceholderLexer.CharTokenType.FUNCTION_ARGUMENT_SEPARATOR));
                if (this.charToken(PlaceholderLexer.CharTokenType.FUNCTION_ARGUMENT_EQUAL)) {
                    throw this.error(this.lastExpectedToken, "Cannot use mix named and positional placeholder function parameters");
                }
            } else {
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                parameters = new PlaceholderNamedFunctionParameters(params);
                do {
                    String paramName = this.stringToken("Expected parameter name");
                    if (!this.charToken(PlaceholderLexer.CharTokenType.FUNCTION_ARGUMENT_EQUAL)) {
                        if (this.charToken(PlaceholderLexer.CharTokenType.FUNCTION_ARGUMENT_SEPARATOR)) {
                            throw this.error(this.lastExpectedToken, "Cannot use mix named and positional placeholder function parameters");
                        }
                        throw this.error(this.lastExpectedToken, "Expected parameter value assignment");
                    }
                    String paramValue = this.collectSeparatedStrings();
                    params.put(paramName, paramValue);
                    if (!this.tokens.hasNext()) break block14;
                } while (this.charToken(PlaceholderLexer.CharTokenType.FUNCTION_ARGUMENT_SEPARATOR));
                if (this.tokens.current() instanceof PlaceholderLexer.StringToken) {
                    this.error(this.tokens.current(), "Missing comma for function parameter");
                }
            }
        }
        this.function = new PlaceholderFunctionData(fnName, parameters);
    }

    private <T extends Placeholder> T createPH(Class<T> type) {
        String originalString = this.lexer.getFullString();
        if (type == ExternalOrLocalPlaceholder.class) {
            return (T)((Placeholder)Fn.cast(new ExternalOrLocalPlaceholder(originalString, this.rel, this.id, this.parameter, this.pointer, this.modifiers)));
        }
        if (type == PermissionPlaceholder.class) {
            if (this.rel) {
                this.error(this.tokenRef.rel, "Permission placeholders can't be relational");
            }
            if (this.parameter == null) {
                this.error(this.tokens.current(), "No permission specified for permission placeholder");
            }
            return (T)((Placeholder)Fn.cast(new PermissionPlaceholder(originalString, this.parameter, this.pointer, this.modifiers)));
        }
        if (type == KingdomsPlaceholder.class) {
            KingdomsPlaceholderTranslator translator;
            if (this.rel) {
                this.error(this.tokenRef.rel, "Kingdoms placeholders should not have relational prefix");
            }
            if ((translator = KingdomsPlaceholderTranslator.getByName(this.parameter)) == null) {
                this.error(this.tokens.previous(), "Unknown kingdoms placeholder with parameter '" + this.parameter + '\'');
            }
            return (T)((Placeholder)Fn.cast(new KingdomsPlaceholder(originalString, this.pointer, this.modifiers, translator, this.function)));
        }
        throw this.error(this.tokens.previous(), "Unknown requested placeholder type '" + type + '\'');
    }

    private Placeholder createPH() {
        boolean isKingdoms;
        boolean bl = isKingdoms = this.assumeKingdomsId || this.id.equals("kingdoms");
        if (this.assumeKingdomsId && this.parameter == null) {
            this.error(this.tokens.previous(), "Can't assume kingdoms placeholder with no parameter set, id=" + this.id);
        }
        if (this.parameter == null && this.id.equals("perm")) {
            this.error(this.tokens.previous(), "Missing permission placeholder parameters");
        }
        if (isKingdoms && this.parameter != null) {
            return this.createPH(KingdomsPlaceholder.class);
        }
        if (this.id.equals("perm")) {
            return this.createPH(PermissionPlaceholder.class);
        }
        return this.createPH(ExternalOrLocalPlaceholder.class);
    }

    void expectMoreTokens(String errorMsg) {
        if (!this.tokens.hasNext()) {
            this.error(this.tokens.previous(), errorMsg);
        }
    }

    public Placeholder getPlaceholder() {
        Placeholder placeholder = this.parse();
        this.validate(placeholder);
        return placeholder;
    }

    private void validate(Placeholder placeholder) {
        if (this.pointer != null && !PlaceholderLexer.isNormal(this.pointer)) {
            this.error(this.tokens.get(0), "Unexpected character in placeholder pointer");
        }
        if (this.id.equals("perm")) {
            this.modifiers.stream().filter(x -> !x.isSupported(Boolean.class)).findFirst().ifPresent(placeholderModifier -> this.error(this.tokens.previous(), "Modifier '" + placeholderModifier.getName() + "' is not supported for permission placeholders"));
        }
        if (this.function != null && placeholder instanceof KingdomsPlaceholder) {
            KingdomsPlaceholder kingdomsPlaceholder = (KingdomsPlaceholder)placeholder;
            if (kingdomsPlaceholder.identifier.getFunctions() != null) {
                FunctionalPlaceholder.CompiledFunction fn = kingdomsPlaceholder.identifier.getFunctions().get(this.function.getFunctionName());
                if (fn == null) {
                    this.error(this.tokens.previous(), "Unknown function '" + this.function.getFunctionName() + "' for kingdoms placeholder '" + kingdomsPlaceholder.identifier + '\'');
                }
                if (this.function.getParameters() instanceof PlaceholderNamedFunctionParameters) {
                    PlaceholderNamedFunctionParameters named = (PlaceholderNamedFunctionParameters)this.function.getParameters();
                    for (FunctionalPlaceholder.Parameter fnParameter : fn.getParameters()) {
                        if (fnParameter.getOptional() || fnParameter.getType().isInternal() || named.getParameters().containsKey(fnParameter.getName())) continue;
                        this.error(this.tokens.previous(), "Missing parameter '" + fnParameter.getName() + '\'');
                    }
                }
            }
        }
        if (!this.modifiers.isEmpty()) {
            PlaceholderModifier modifier = null;
            Set<PlaceholderModifier> expectedMods = placeholder.getExpectedModifiers();
            for (PlaceholderModifier other : this.modifiers) {
                if (expectedMods != null && !expectedMods.contains(other)) {
                    this.error(this.tokenRef.modifiers.getStart(), this.tokenRef.modifiers.getEndInclusive(), "Unexpected modifier '" + other.getName() + '\'');
                }
                if (modifier == null) {
                    modifier = other;
                    continue;
                }
                String modifierRef = modifier.getName() + " (" + modifier.getOutputType() + ") -> " + other.getName() + " (" + other.getOutputType() + ')';
                switch (modifier.compareCompatibiltyWith(other)) {
                    case COMPATIBLE: 
                    case BEFORE: {
                        break;
                    }
                    case INCOMPATIBLE: {
                        this.error(this.tokenRef.modifiers.getStart(), this.tokenRef.modifiers.getEndInclusive(), "Incompatible placeholder modifiers " + modifierRef);
                    }
                    case AFTER: {
                        this.error(this.tokenRef.modifiers.getStart(), this.tokenRef.modifiers.getEndInclusive(), "Incompatible placeholder modifiers, the order must be switched " + modifierRef);
                    }
                }
            }
        }
    }

    private Placeholder parse() {
        boolean isInternalPlaceholder;
        String first = this.stringToken("Placeholder starts with unexpected character");
        if (!this.tokens.hasNext()) {
            if (this.assumeKingdomsId) {
                this.id = "kingdoms";
                this.parameter = first;
            } else {
                this.id = first;
            }
            return this.createPH();
        }
        this.tokens.setCursor(0);
        this.pointer = this.parsePointer();
        if (this.pointer != null && !this.pointer.equals("other")) {
            this.error(this.tokens.get(0), "Unknown pointer for target '" + this.pointer + "' only 'other' is supported.");
        }
        this.expectMoreTokens("No ID specified for the placeholder");
        this.collectModifiers();
        this.expectMoreTokens("No ID specified for the placeholder");
        this.rel = this.isNextTokenRelational();
        this.parseLegacyModifiers(false);
        if (this.assumeKingdomsId) {
            isInternalPlaceholder = true;
            this.id = "kingdoms";
        } else {
            this.id = this.stringToken("No ID specified for the placeholder");
            isInternalPlaceholder = this.id.equals("kingdoms");
            if (!isInternalPlaceholder && this.id.equalsIgnoreCase("kingdoms")) {
                this.error(this.lastExpectedToken, "Kingdoms placeholders must be 'kingdoms' not '" + this.id + "' (case-sensitive)");
            }
            if (!this.tokens.hasNext()) {
                return this.createPH();
            }
            this.charToken(PlaceholderLexer.CharTokenType.SEPARATOR);
        }
        if (isInternalPlaceholder) {
            this.parseLegacyModifiers(true);
        }
        if (!this.tokens.hasNext()) {
            return this.createPH();
        }
        this.parameter = this.collectSeparatedStrings();
        if (!this.tokens.hasNext()) {
            return this.createPH();
        }
        if (isInternalPlaceholder) {
            this.parseFunction();
        }
        if (!this.tokens.hasNext()) {
            return this.createPH();
        }
        if (this.tokens.hasNext()) {
            this.error(this.tokens.next(), "Unknown final placeholder part");
        }
        return this.createPH();
    }

    public String toString() {
        return "PlaceholderParser{rel=" + this.rel + ", pointer='" + this.pointer + '\'' + ", id='" + this.id + '\'' + ", parameter='" + this.parameter + '\'' + ", function=" + this.function + ", modifiers=" + this.modifiers + '}';
    }

    @Nullable
    public static Map<String, Object> serializeVariables(boolean raw, @Nullable Map<String, Object> source, @NonNull Object[] edits) {
        if (edits.length == 0) {
            return source;
        }
        if (source == null) {
            source = new HashMap<String, Object>(edits.length / 2);
        }
        int len = edits.length - 1;
        for (int i = 0; i < len; i += 2) {
            Object replacement = edits[i + 1];
            if (replacement == null) continue;
            if (!raw && !PlaceholderTranslationContext.isRaw(replacement)) {
                replacement = PlaceholderTranslationContext.withDefaultContext(replacement);
            }
            source.put(String.valueOf(edits[i]), replacement);
        }
        return source;
    }

    private static Object[] legacyVariables(Object ... edits) {
        int len = edits.length - 1;
        for (int i = 0; i < len; i += 2) {
            if (edits[i].toString().charAt(0) == '%') continue;
            edits[i] = '%' + String.valueOf(edits[i]) + '%';
        }
        return edits;
    }

    public static enum Phase {
        NONE,
        POINTER,
        FUNCTION,
        MODIFIER;


        public boolean hasPassed(Phase phase) {
            return this.ordinal() > phase.ordinal();
        }
    }

    private static final class TokenRef {
        PlaceholderLexer.StringToken rel;
        PlaceholderLexer.StringToken pointer;
        PlaceholderLexer.StringToken id;
        PlaceholderLexer.StringToken parameter;
        PlaceholderLexer.StringToken function;
        IntRange modifiers;

        private TokenRef() {
        }
    }
}

