/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.placeholders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.CharsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 .2\u00020\u0001:\u0006)*+,-.B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u001f\u0010\u001d\u001a\u00020\u001e2\u0014\b\u0004\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00070 H\u0082\bJ\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\fH\u0002J\b\u0010$\u001a\u00020\u001eH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020!H\u0002J\b\u0010(\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006/"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer;", "", "start", "", "chars", "", "lookForClosure", "", "<init>", "(I[CZ)V", "tokens", "", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$Token;", "getTokens", "()Ljava/util/List;", "length", "index", "getIndex", "()I", "setIndex", "(I)V", "result", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$Result;", "getResult", "()Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$Result;", "setResult", "(Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$Result;)V", "getFullString", "", "doUntil", "", "action", "Lorg/kingdoms/libs/kotlin/Function1;", "", "addToken", "token", "lex", "getCharToken", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$CharToken;", "char", "untilNextChar", "CharTokenType", "Result", "Token", "StringToken", "CharToken", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPlaceholderLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaceholderLexer.kt\norg/kingdoms/locale/compiler/placeholders/PlaceholderLexer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n37#1,5:202\n37#1,5:207\n1755#2,3:199\n1#3:212\n*S KotlinDebug\n*F\n+ 1 PlaceholderLexer.kt\norg/kingdoms/locale/compiler/placeholders/PlaceholderLexer\n*L\n71#1:202,5\n124#1:207,5\n61#1:199,3\n*E\n"})
public final class PlaceholderLexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int start;
    @NotNull
    private final char[] chars;
    private final boolean lookForClosure;
    @NotNull
    private final List<Token> tokens;
    private final int length;
    private int index;
    @Nullable
    private Result result;

    public PlaceholderLexer(int start, @NotNull char[] chars, boolean lookForClosure) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        this.start = start;
        this.chars = chars;
        this.lookForClosure = lookForClosure;
        this.tokens = new ArrayList();
        this.length = this.chars.length;
        this.index = this.start;
        this.lex();
    }

    @NotNull
    public final List<Token> getTokens() {
        return this.tokens;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @Nullable
    public final Result getResult() {
        return this.result;
    }

    public final void setResult(@Nullable Result result) {
        this.result = result;
    }

    @NotNull
    public final String getFullString() {
        if (this.result != Result.SUCCESS) {
            throw new IllegalArgumentException("Cannot get full string of unsuccessful placeholder lexicon");
        }
        return this.lookForClosure ? new String(this.chars, this.start, this.index - this.start) : new String(this.chars);
    }

    private final void doUntil(Function1<? super Character, Boolean> action) {
        boolean $i$f$doUntil = false;
        do {
            char c;
            if (!((Boolean)action.invoke((Object)Character.valueOf(c = this.chars[this.index]))).booleanValue()) {
                return;
            }
            int n = this.index;
            this.index = n + 1;
        } while (this.index < this.chars.length);
    }

    private final void addToken(Token token) {
        if (token instanceof CharToken) {
            if (((CharToken)token).getType() == CharTokenType.WHITESPACE) {
                if (this.tokens.isEmpty()) {
                    this.result = Result.NOT_A_PLACEHOLDER;
                }
                return;
            }
            if (((CharToken)token).getType() == CharTokenType.CLOSURE) {
                boolean bl;
                block8: {
                    if (!this.lookForClosure) {
                        throw new IllegalStateException("Not expecting to look for placeholder closure, but found one at " + this.index + " -> " + new String(this.chars));
                    }
                    Iterable $this$any$iv = this.tokens;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Token it = (Token)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof StringToken)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                this.result = !bl ? Result.NOT_A_PLACEHOLDER : Result.SUCCESS;
                return;
            }
        }
        this.tokens.add(token);
    }

    /*
     * Unable to fully structure code
     */
    private final void lex() {
        this_$iv = this;
        $i$f$doUntil = false;
        do {
            block7: {
                char = char$iv = this_$iv.chars[this_$iv.index];
                $i$a$-doUntil-PlaceholderLexer$lex$1 = false;
                charToken = PlaceholderLexer.access$getCharToken(this, char);
                if (charToken == null) break block7;
                PlaceholderLexer.access$addToken(this, charToken);
                ** GOTO lbl-1000
            }
            if (!PlaceholderLexer.access$untilNextChar(this)) {
                this.setResult(Result.NOT_A_PLACEHOLDER);
                v0 = false;
            } else if (this.getTokens().size() == 1 && this.getTokens().get(0) instanceof CharToken) {
                this.setResult(Result.NOT_A_PLACEHOLDER);
                v0 = false;
            } else {
                v0 = this.getResult() == null;
            }
            if (!v0) break;
            var4_4 = this_$iv.index;
            this_$iv.index = var4_4 + 1;
        } while (this_$iv.index < this_$iv.chars.length);
        if (this.result == null) {
            this.result = this.lookForClosure != false ? Result.CLOSING_CLOSURE_NOT_FOUND : Result.SUCCESS;
        }
    }

    private final CharToken getCharToken(char c) {
        CharTokenType charTokenType;
        switch (c) {
            case '*': {
                charTokenType = CharTokenType.POINTER;
                break;
            }
            case '_': {
                charTokenType = CharTokenType.SEPARATOR;
                break;
            }
            case ':': {
                charTokenType = CharTokenType.FUNCTION_START;
                break;
            }
            case '=': {
                charTokenType = CharTokenType.FUNCTION_ARGUMENT_EQUAL;
                break;
            }
            case ',': {
                charTokenType = CharTokenType.FUNCTION_ARGUMENT_SEPARATOR;
                break;
            }
            case '@': {
                charTokenType = CharTokenType.MODIFIER;
                break;
            }
            case '%': {
                charTokenType = CharTokenType.CLOSURE;
                break;
            }
            default: {
                charTokenType = CharsKt.isWhitespace((char)c) ? CharTokenType.WHITESPACE : null;
            }
        }
        if (charTokenType == null) {
            return null;
        }
        CharTokenType charType = charTokenType;
        return new CharToken(charType, this.index);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean untilNextChar() {
        StringBuilder builder = new StringBuilder(this.length / 2);
        boolean standard = false;
        standard = true;
        CharToken nextCharToken = null;
        int startIndex = this.index;
        boolean lastEscaped = false;
        boolean insideQuote = false;
        boolean isFirst = false;
        isFirst = true;
        PlaceholderLexer this_$iv = this;
        boolean $i$f$doUntil = false;
        do {
            boolean bl;
            block17: {
                char c;
                block20: {
                    block19: {
                        char char$iv;
                        c = char$iv = this_$iv.chars[this_$iv.index];
                        boolean bl2 = false;
                        if (!isFirst) break block19;
                        isFirst = false;
                        if (c != '\"') break block20;
                        insideQuote = true;
                        bl = true;
                        break block17;
                    }
                    if (!insideQuote) break block20;
                    if (c == '\"') {
                        if (lastEscaped) {
                            builder.append(c);
                            lastEscaped = false;
                            bl = true;
                            break block17;
                        } else {
                            bl = false;
                        }
                        break block17;
                    } else {
                        if (c == '\\') {
                            if (lastEscaped) {
                                builder.append('\\');
                            }
                            lastEscaped = true;
                        } else {
                            builder.append(c);
                        }
                        bl = true;
                    }
                    break block17;
                }
                if (c == '\\') {
                    if (lastEscaped) {
                        builder.append('\\');
                    }
                    lastEscaped = true;
                    bl = true;
                } else {
                    CharToken charToken = this.getCharToken(c);
                    if (charToken != null) {
                        if (lastEscaped) {
                            builder.append(c);
                            lastEscaped = false;
                            bl = true;
                        } else {
                            nextCharToken = charToken;
                            bl = false;
                        }
                    } else {
                        builder.append(c);
                        if (!Companion.isNormal(c)) {
                            return false;
                        }
                        bl = true;
                    }
                }
            }
            if (!bl) break;
            int n = this_$iv.index;
            this_$iv.index = n + 1;
        } while (this_$iv.index < this_$iv.chars.length);
        if (!standard) {
            return false;
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.addToken(new StringToken(string, standard, startIndex));
        CharToken charToken = nextCharToken;
        if (charToken == null) return true;
        CharToken it = charToken;
        boolean bl = false;
        this.addToken(it);
        return true;
    }

    @JvmStatic
    public static final boolean isNormal(@NotNull CharSequence str) {
        return Companion.isNormal(str);
    }

    @JvmStatic
    public static final boolean isNormal(char c) {
        return Companion.isNormal(c);
    }

    public static final /* synthetic */ void access$addToken(PlaceholderLexer $this, Token token) {
        $this.addToken(token);
    }

    public static final /* synthetic */ boolean access$untilNextChar(PlaceholderLexer $this) {
        return $this.untilNextChar();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$CharToken;", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$Token;", "type", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$CharTokenType;", "startIndex", "", "<init>", "(Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$CharTokenType;I)V", "getType", "()Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$CharTokenType;", "toString", "", "core"})
    public static final class CharToken
    extends Token {
        @NotNull
        private final CharTokenType type;

        public CharToken(@NotNull CharTokenType type, int startIndex) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            super(startIndex);
            this.type = type;
        }

        @NotNull
        public final CharTokenType getType() {
            return this.type;
        }

        @NotNull
        public String toString() {
            return "Char{" + (Object)((Object)this.type) + '}';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$CharTokenType;", "", "<init>", "(Ljava/lang/String;I)V", "WHITESPACE", "POINTER", "SEPARATOR", "FUNCTION_START", "FUNCTION_ARGUMENT_EQUAL", "FUNCTION_ARGUMENT_SEPARATOR", "MODIFIER", "CLOSURE", "core"})
    public static final class CharTokenType
    extends Enum<CharTokenType> {
        public static final /* enum */ CharTokenType WHITESPACE = new CharTokenType();
        public static final /* enum */ CharTokenType POINTER = new CharTokenType();
        public static final /* enum */ CharTokenType SEPARATOR = new CharTokenType();
        public static final /* enum */ CharTokenType FUNCTION_START = new CharTokenType();
        public static final /* enum */ CharTokenType FUNCTION_ARGUMENT_EQUAL = new CharTokenType();
        public static final /* enum */ CharTokenType FUNCTION_ARGUMENT_SEPARATOR = new CharTokenType();
        public static final /* enum */ CharTokenType MODIFIER = new CharTokenType();
        public static final /* enum */ CharTokenType CLOSURE = new CharTokenType();
        private static final /* synthetic */ CharTokenType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CharTokenType[] values() {
            return (CharTokenType[])$VALUES.clone();
        }

        public static CharTokenType valueOf(String value) {
            return Enum.valueOf(CharTokenType.class, value);
        }

        @NotNull
        public static EnumEntries<CharTokenType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = charTokenTypeArray = new CharTokenType[]{CharTokenType.WHITESPACE, CharTokenType.POINTER, CharTokenType.SEPARATOR, CharTokenType.FUNCTION_START, CharTokenType.FUNCTION_ARGUMENT_EQUAL, CharTokenType.FUNCTION_ARGUMENT_SEPARATOR, CharTokenType.MODIFIER, CharTokenType.CLOSURE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$Companion;", "", "<init>", "()V", "isNormal", "", "str", "", "char", "", "core"})
    @SourceDebugExtension(value={"SMAP\nPlaceholderLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaceholderLexer.kt\norg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,198:1\n1069#2,2:199\n*S KotlinDebug\n*F\n+ 1 PlaceholderLexer.kt\norg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$Companion\n*L\n186#1:199,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isNormal(@NotNull CharSequence str) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                CharSequence $this$all$iv = str;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(i);
                    boolean bl2 = false;
                    if (Companion.isNormal(it)) continue;
                    bl = false;
                    break block1;
                }
                bl = true;
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isNormal(char c) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            char c2 = c;
            if ('a' <= c2) {
                if (c2 < '{') {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if ('A' <= c2) {
                if (c2 < '[') {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if ('0' <= c2) {
                if (c2 < ':') {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (c2 != '-') return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$Result;", "", "<init>", "(Ljava/lang/String;I)V", "SUCCESS", "CLOSING_CLOSURE_NOT_FOUND", "NOT_A_PLACEHOLDER", "core"})
    public static final class Result
    extends Enum<Result> {
        public static final /* enum */ Result SUCCESS = new Result();
        public static final /* enum */ Result CLOSING_CLOSURE_NOT_FOUND = new Result();
        public static final /* enum */ Result NOT_A_PLACEHOLDER = new Result();
        private static final /* synthetic */ Result[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }

        public static Result valueOf(String value) {
            return Enum.valueOf(Result.class, value);
        }

        @NotNull
        public static EnumEntries<Result> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resultArray = new Result[]{Result.SUCCESS, Result.CLOSING_CLOSURE_NOT_FOUND, Result.NOT_A_PLACEHOLDER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$StringToken;", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$Token;", "string", "", "standard", "", "startIndex", "", "<init>", "(Ljava/lang/String;ZI)V", "getString", "()Ljava/lang/String;", "getStandard", "()Z", "toString", "core"})
    public static final class StringToken
    extends Token {
        @NotNull
        private final String string;
        private final boolean standard;

        public StringToken(@NotNull String string, boolean standard, int startIndex) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            super(startIndex);
            this.string = string;
            this.standard = standard;
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        public final boolean getStandard() {
            return this.standard;
        }

        @NotNull
        public String toString() {
            return "String{" + this.string + '}';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderLexer$Token;", "", "startIndex", "", "<init>", "(I)V", "getStartIndex", "()I", "core"})
    public static abstract class Token {
        private final int startIndex;

        public Token(int startIndex) {
            this.startIndex = startIndex;
        }

        public final int getStartIndex() {
            return this.startIndex;
        }
    }
}

