/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.pieces.showitem;

import java.util.Map;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.kingdoms.locale.compiler.builders.context.ComplexMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.HTMLMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.MessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.PlainMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.compiler.pieces.showitem.ChatItem;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.utils.PlaceholderContextProviders;

public final class ShowItemMessagePiece
extends MessagePiece {
    private final String usedFormat;
    private final Messenger text;

    public ShowItemMessagePiece(String usedFormat, Messenger text) {
        this.usedFormat = usedFormat;
        this.text = text;
    }

    private static void addEdits(MessageBuilderContextProvider context) {
        Map<String, PlaceholderProvider> children = context.getSettings().getChildren();
        if (children != null && children.containsKey("item")) {
            return;
        }
        Player player = (Player)context.getSettings().getPrimaryTarget();
        PlaceholderContextProviders.provide((PlaceholderContextBuilder)context.getSettings(), player.getInventory().getItemInMainHand());
    }

    @Override
    public void build(ComplexMessageBuilderContextProvider context) {
        TextComponent comp = context.newComponent(ComponentBuilder.FormatRetention.NONE);
        Player player = (Player)context.getSettings().getPrimaryTarget();
        HoverEvent hoverEvent = ChatItem.constructHoverItem(player.getInventory().getItemInMainHand());
        comp.setHoverEvent(hoverEvent);
        ShowItemMessagePiece.addEdits(context);
        this.text.getMessageObject(context.getSettings().getLanguage()).build(context);
        context.getComponent().setHoverEvent(hoverEvent);
    }

    @Override
    public void build(PlainMessageBuilderContextProvider context) {
        ShowItemMessagePiece.addEdits(context);
        this.text.getMessageObject(context.getSettings().getLanguage()).build(context);
    }

    @Override
    public void build(HTMLMessageBuilderContextProvider context) {
        ShowItemMessagePiece.addEdits(context);
        this.text.getMessageObject(context.getSettings().getLanguage()).build(context);
    }

    @Override
    public int length() {
        return this.usedFormat.length();
    }

    @Override
    public int jsonLength() {
        return this.usedFormat.length() + 100;
    }

    public String toString() {
        return "ShowItemMessagePiece(" + this.usedFormat + ')';
    }
}

