/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.pieces.showitem;

import java.util.ArrayList;
import java.util.List;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.data.Pair;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageTokenHandler;
import org.kingdoms.locale.compiler.MessageTokenResult;
import org.kingdoms.locale.compiler.pieces.showitem.ShowItemMessagePiece;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.string.Strings;

public final class ChatShowItemTokenizer
extends MessageTokenHandler {
    public static final ChatShowItemTokenizer INSTANCE = new ChatShowItemTokenizer();
    private static final List<Pair<String, Messenger>> FORMATS = new ArrayList<Pair<String, Messenger>>();

    private ChatShowItemTokenizer() {
    }

    @Override
    public MessageTokenResult consumeUntil(MessageCompiler compiler) {
        for (Pair<String, Messenger> format : FORMATS) {
            if (!Strings.startsWith(compiler.getChars(), compiler.getIndex(), compiler.getChars().length, format.getKey())) continue;
            return new MessageTokenResult(compiler.getIndex() + format.getKey().length() - 1, new ShowItemMessagePiece(format.getKey(), format.getValue()));
        }
        return null;
    }

    static {
        ConfigSection replaces = KingdomsConfig.Chat.SHOW_ITEM.getManager().getSection().get("main-hand", "replace").getSection().getSection();
        for (String key : replaces.getKeys()) {
            String msg = replaces.getString(key);
            FORMATS.add(Pair.of(key, new StaticMessenger(msg)));
        }
    }
}

