/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.container;

import java.util.ArrayList;
import java.util.List;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.config.accessor.KeyedConfigAccessor;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.snakeyaml.markers.Mark;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.container.ConditionalMessageContainer;
import org.kingdoms.locale.compiler.container.SimpleMessageContainer;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.config.ConfigSection;

public interface MessageContainer {
    public MessageObject get(MessagePlaceholderProvider var1);

    public static List<Pair<ConditionalExpression, String>> parseRaw(KeyedConfigAccessor accessor) {
        ArrayList<Pair<ConditionalExpression, String>> list = new ArrayList<Pair<ConditionalExpression, String>>();
        if (!accessor.isSet()) {
            return list;
        }
        ConfigAccessor variableSection = accessor.getSection();
        if (variableSection != null) {
            ConfigSection varSection = variableSection.getSection();
            for (String conds : variableSection.getKeys()) {
                list.add(Pair.of(ConditionalCompiler.compile(conds).evaluate(), varSection.getString(conds)));
            }
        } else {
            list.add(Pair.of(null, accessor.getString()));
        }
        return list;
    }

    public static MessageContainer parse(KeyedConfigAccessor accessor) {
        MessageContainer container;
        ConfigAccessor variableSection = accessor.getSection();
        if (variableSection != null) {
            ConfigSection varSection = variableSection.getSection();
            ArrayList<Pair<ConditionalExpression, MessageObject>> messages = new ArrayList<Pair<ConditionalExpression, MessageObject>>(2);
            container = new ConditionalMessageContainer(messages);
            for (String conds : variableSection.getKeys()) {
                ConditionalCompiler.LogicalOperand condition = ConditionalCompiler.compile(conds).evaluate();
                MessageObject msg = MessageCompiler.compile(varSection.getString(conds), MessageCompiler.defaultSettingsWithErroHandler(exes -> {
                    Mark mark = varSection.getNode(conds).getStartMark();
                    KLogger.warn("While parsing '" + accessor.getOptionPath() + "' macro, line " + mark.getLine() + ":\n" + exes.joinExceptions());
                }));
                messages.add(Pair.of(condition, msg));
            }
        } else {
            container = new SimpleMessageContainer(MessageCompiler.compile(accessor.getString(), MessageCompiler.defaultSettingsWithErroHandler(exes -> {
                Mark mark = accessor.getNode().getStartMark();
                KLogger.warn("While parsing '" + accessor.getOptionPath() + "' macro, line " + mark.getLine() + ":\n" + exes.joinExceptions());
            })));
        }
        return container;
    }
}

