/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.builders.context;

import java.util.ArrayList;
import java.util.List;
import org.kingdoms.locale.compiler.builders.context.MessageBuilderContextProvider;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public final class PlainMessageBuilderContextProvider
extends MessageBuilderContextProvider {
    private final List<StringBuilder> lines = new ArrayList<StringBuilder>(5);
    private StringBuilder currentLine;
    boolean used = false;

    public PlainMessageBuilderContextProvider(MessagePlaceholderProvider settings) {
        super(settings);
        this.newLine();
    }

    public StringBuilder getCurrentLine() {
        this.checkUsed();
        return this.currentLine;
    }

    public void newLine() {
        this.checkUsed();
        this.currentLine = new StringBuilder();
        this.lines.add(this.currentLine);
    }

    private void checkUsed() {
        if (this.used) {
            throw new IllegalStateException("This message was already merged and cannot be accessed anymore");
        }
    }

    public String merge() {
        this.checkUsed();
        this.used = true;
        StringBuilder first = this.lines.get(0);
        for (StringBuilder builder : this.lines) {
            if (first == builder) continue;
            first.append('\n').append((CharSequence)builder);
        }
        return first.toString();
    }

    public List<StringBuilder> getLines() {
        this.checkUsed();
        return this.lines;
    }

    @Override
    public void build(MessagePiece messagePiece) {
        this.checkUsed();
        messagePiece.build(this);
    }
}

