/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.builders.context;

import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.compiler.builders.context.MessageBuilderContextProvider;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.XComponentBuilder;

public final class ComplexMessageBuilderContextProvider
extends MessageBuilderContextProvider {
    private final XComponentBuilder builder;
    private TextComponent component;
    private int jsonLength;
    private ComplexMessageBuilderContextProvider parent;

    public ComplexMessageBuilderContextProvider(ComplexMessageBuilderContextProvider parent, XComponentBuilder builder, TextComponent first, MessagePlaceholderProvider settings) {
        super(settings);
        this.builder = builder;
        this.parent = parent;
        this.component = new TextComponent(first);
        this.component.setText("");
        this.builder.append((BaseComponent)this.component, ComponentBuilder.FormatRetention.NONE);
        if (first.getText() == null || first.getText().isEmpty()) {
            first.setText("");
        }
    }

    public ComplexMessageBuilderContextProvider(MessagePlaceholderProvider settings) {
        this(null, new XComponentBuilder(), new TextComponent(), settings);
    }

    public XComponentBuilder getBuilder() {
        return this.builder;
    }

    public TextComponent getComponent() {
        return this.component;
    }

    public void newComponent(ComponentBuilder.FormatRetention formatRetention, BaseComponent ... components) {
        BaseComponent lastComponent = components[components.length - 1];
        TextComponent newComp = new TextComponent();
        newComp.setText("");
        XComponentBuilder.copyFormatting((BaseComponent)newComp, lastComponent, ComponentBuilder.FormatRetention.FORMATTING);
        this.builder.append((BaseComponent)newComp, formatRetention);
        for (BaseComponent comp : components) {
            this.builder.append(comp, formatRetention);
            this.addPacketSize(comp);
            this.checkPacketSize();
        }
        this.component = newComp;
    }

    public void newComponent(BaseComponent ... components) {
        this.newComponent(ComponentBuilder.FormatRetention.NONE, components);
    }

    public TextComponent newComponent(ComponentBuilder.FormatRetention formatRetention) {
        TextComponent component = new TextComponent();
        component.setText("");
        XComponentBuilder.copyFormatting((BaseComponent)component, (BaseComponent)this.component, formatRetention);
        this.builder.append((BaseComponent)component, ComponentBuilder.FormatRetention.NONE);
        this.addPacketSize((BaseComponent)component);
        this.component = component;
        return this.component;
    }

    public void appendRemaining() {
    }

    private void addJsonLength(int i) {
        if (this.parent != null) {
            this.parent.jsonLength += i;
        } else {
            this.jsonLength += i;
        }
    }

    public void checkPacketSize() {
        if (this.jsonLength >= 200000) {
            if (this.parent != null) {
                throw new IllegalStateException("Message with parent packet size exceeded");
            }
            this.builder.newPacket();
            this.jsonLength = 0;
        }
    }

    public void addPacketSize(BaseComponent component) {
        List extras;
        this.addJsonLength(MessagePiece.Plain.JSON_LEN);
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            this.addJsonLength(textComponent.getText() == null ? 0 : textComponent.getText().length());
            if (textComponent.getHoverEvent() != null) {
                this.addJsonLength(textComponent.getHoverEvent().getValue().length);
            }
            if (textComponent.getClickEvent() != null) {
                this.addJsonLength(textComponent.getClickEvent().getValue().length());
            }
            if (XReflection.supports((int)16) && textComponent.getFontRaw() != null) {
                this.addJsonLength(textComponent.getFontRaw().length());
            }
            if (textComponent.getInsertion() != null) {
                this.addJsonLength(textComponent.getInsertion().length());
            }
        }
        if ((extras = component.getExtra()) != null) {
            extras.forEach(this::addPacketSize);
        }
    }

    @Override
    public void build(MessagePiece messagePiece) {
        messagePiece.build(this);
        this.addJsonLength(messagePiece.jsonLength());
        this.checkPacketSize();
    }
}

