/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.builders;

import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.context.ComplexMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.HTMLMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.PlainMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public class ContextualMessageObject
extends MessageObject {
    private final MessageObject message;
    private final MessagePlaceholderProvider context;

    public ContextualMessageObject(MessageObject message, MessagePlaceholderProvider context) {
        super(message.getPieces(), message.getUsePrefix());
        this.message = message;
        this.context = context;
    }

    @Override
    public void build(ComplexMessageBuilderContextProvider contextProvider) {
        MessagePlaceholderProvider previousSettings = contextProvider.getSettings();
        contextProvider.setSettings(this.context);
        for (MessagePiece piece : this.message.getPieces()) {
            if (this.context.ignoreColors && piece instanceof MessagePiece.Color) continue;
            contextProvider.build(piece);
        }
        contextProvider.setSettings(previousSettings);
        contextProvider.appendRemaining();
    }

    @Override
    public void build(PlainMessageBuilderContextProvider contextProvider) {
        MessagePlaceholderProvider previousSettings = contextProvider.getSettings();
        contextProvider.setSettings(this.context);
        for (MessagePiece piece : this.message.getPieces()) {
            if (this.context.ignoreColors && piece instanceof MessagePiece.Color) continue;
            piece.build(contextProvider);
        }
        contextProvider.setSettings(previousSettings);
    }

    @Override
    public void build(HTMLMessageBuilderContextProvider contextProvider) {
        MessagePlaceholderProvider previousSettings = contextProvider.getSettings();
        contextProvider.setSettings(this.context);
        for (MessagePiece piece : this.message.getPieces()) {
            if (this.context.ignoreColors && piece instanceof MessagePiece.Color) continue;
            piece.build(contextProvider);
        }
        contextProvider.setSettings(previousSettings);
    }

    @Override
    public boolean isAvailable(MessagePlaceholderProvider builder) {
        return this.message.isAvailable(builder);
    }

    @Override
    public MessageObject evaluateDynamicPieces(MessagePlaceholderProvider placeholderContextProvider) {
        return this.message.evaluateDynamicPieces(this.context);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(message: " + this.message + ", context: " + this.context + ')';
    }
}

