/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.libs.snakeyaml.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.snakeyaml.comments.CommentLine;
import org.kingdoms.libs.snakeyaml.comments.CommentType;
import org.kingdoms.libs.snakeyaml.common.reference.NodeReference;
import org.kingdoms.libs.snakeyaml.markers.Mark;
import org.kingdoms.libs.snakeyaml.nodes.NodeType;
import org.kingdoms.libs.snakeyaml.nodes.Tag;

public abstract class Node
implements Cloneable {
    private Tag tag;
    private final Mark startMark;
    protected Mark endMark;
    private NodeReference reference;
    private List<CommentLine> comments = new ArrayList<CommentLine>();

    public Node(Tag tag, Mark startMark, Mark endMark) {
        this.setTag(tag);
        this.startMark = startMark;
        this.endMark = endMark;
    }

    public Tag getTag() {
        return this.tag;
    }

    public Mark getEndMark() {
        return this.endMark;
    }

    public Mark getWholeMark() {
        int[] firstBuffer = this.startMark.getBuffer();
        int[] secondBuffer = this.endMark.getBuffer();
        int[] combinedBuffer = new int[firstBuffer.length + secondBuffer.length];
        System.arraycopy(firstBuffer, 0, combinedBuffer, 0, firstBuffer.length);
        System.arraycopy(secondBuffer, 0, combinedBuffer, firstBuffer.length, secondBuffer.length);
        return new Mark(this.startMark.getName(), this.startMark.getIndex(), this.startMark.getLine(), this.startMark.getColumn(), combinedBuffer, this.startMark.getPointer());
    }

    public abstract NodeType getNodeType();

    public Mark getStartMark() {
        return this.startMark;
    }

    public void setTag(Tag tag) {
        this.tag = Objects.requireNonNull(tag, "Tag in a Node is required.");
    }

    public abstract void cacheConstructed(Object var1);

    public abstract Object getParsed();

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public @Nullable NodeReference getReference() {
        return this.reference;
    }

    public void setReference(NodeReference reference) {
        this.reference = reference;
    }

    public List<CommentLine> getComments() {
        return this.comments;
    }

    public List<CommentLine> getComments(CommentType commentType) {
        return this.comments.stream().filter(x -> x.getCommentType() == commentType).collect(Collectors.toList());
    }

    public void setComments(@NonNull CommentType commentType, @NonNull List<CommentLine> comments) {
        Objects.requireNonNull(commentType);
        Objects.requireNonNull(comments);
        if (comments.isEmpty()) {
            return;
        }
        this.comments.removeIf(x -> x.getCommentType() == commentType);
        this.comments.addAll(comments);
    }

    public void setSimpleComments(@NonNull String[] comments) {
        if (comments == null || comments.length == 0) {
            this.comments.clear();
            return;
        }
        this.comments = Arrays.stream(comments).map(x -> new CommentLine(null, null, x.isEmpty() ? "" : ' ' + x, x.isEmpty() ? CommentType.BLANK_LINE : CommentType.BLOCK_BEFORE, 0)).collect(Collectors.toList());
    }

    public abstract Node clone();

    protected String getReferenceString() {
        return this.reference == null ? "" : ", reference=" + this.reference;
    }

    protected Node copyPropertiesOf(Node other) {
        this.reference = other.reference;
        if (other.comments != null) {
            this.comments = new ArrayList<CommentLine>(other.comments);
        }
        return this;
    }
}

