/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.libs.snakeyaml.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.snakeyaml.common.Anchor;
import org.kingdoms.libs.snakeyaml.common.FlowStyle;
import org.kingdoms.libs.snakeyaml.common.NodeReplacer;
import org.kingdoms.libs.snakeyaml.common.ScalarStyle;
import org.kingdoms.libs.snakeyaml.common.reference.CrossNodeReference;
import org.kingdoms.libs.snakeyaml.markers.Mark;
import org.kingdoms.libs.snakeyaml.nodes.CollectionNode;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.snakeyaml.nodes.NodePair;
import org.kingdoms.libs.snakeyaml.nodes.NodeType;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.libs.snakeyaml.nodes.Tag;

public class MappingNode
extends CollectionNode<NodePair> {
    private LinkedHashMap<String, Anchor> anchors;
    private LinkedHashMap<String, NodePair> pairs;
    private boolean merged = false;

    public MappingNode(Tag tag, LinkedHashMap<String, NodePair> pairs, FlowStyle flowStyle, Mark startMark, Mark endMark) {
        super(tag, flowStyle, startMark, endMark);
        this.pairs = Objects.requireNonNull(pairs);
    }

    public MappingNode(Tag tag, LinkedHashMap<String, NodePair> pairs, FlowStyle flowStyle) {
        this(tag, pairs, flowStyle, null, null);
    }

    public MappingNode() {
        this(Tag.MAP, new LinkedHashMap<String, NodePair>(), FlowStyle.BLOCK);
    }

    public void merge(MappingNode other) {
        this.pairs.putAll(other.pairs);
    }

    public NodePair put(ScalarNode key, Node valueNode) {
        NodePair pair = new NodePair(key, valueNode);
        this.pairs.put(key.getValue(), pair);
        return pair;
    }

    public NodePair put(String key, Node valueNode) {
        ScalarNode keyNode = new ScalarNode(Tag.STR, key, ScalarStyle.PLAIN);
        NodePair pair = new NodePair(keyNode, valueNode);
        this.pairs.put(key, pair);
        return pair;
    }

    public void setAnchors(LinkedHashMap<String, Anchor> anchors) {
        this.anchors = anchors;
    }

    public LinkedHashMap<String, Anchor> getAnchors() {
        return this.anchors;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MAPPING;
    }

    @Override
    public void cacheConstructed(Object obj) {
    }

    @Override
    public Object getParsed() {
        return null;
    }

    public Node getNode(String key) {
        NodePair pair = this.pairs.get(key);
        return pair == null ? null : pair.getValue();
    }

    public void setPairs(LinkedHashMap<String, NodePair> pairs) {
        this.pairs = pairs;
    }

    public void copyIfDoesntExist(@NonNull MappingNode copyFrom, @NonNull String copyOrigin, @NonNull String rootPath, @Nullable Predicate<NodeReplacer.ReplacementDetails> ignore) {
        Objects.requireNonNull(copyFrom, "Cannot copy from null source");
        Objects.requireNonNull(copyOrigin, "copyOrigin is null");
        Objects.requireNonNull(rootPath, "rootPath is null");
        for (Map.Entry<String, NodePair> pair : copyFrom.pairs.entrySet()) {
            String path = rootPath;
            path = path.isEmpty() ? pair.getKey() : path + '.' + pair.getKey();
            if (ignore != null && ignore.test(new NodeReplacer.ReplacementDetails(path, pair.getValue().getKey(), true, null))) continue;
            Node copyNode = pair.getValue().getValue();
            NodePair currentPair = this.pairs.get(pair.getKey());
            if (currentPair == null) {
                ScalarNode key = pair.getValue().getKey().clone();
                key.setReference(new CrossNodeReference(pair.getValue().getKey(), copyOrigin));
                Node value = pair.getValue().getValue().clone();
                value.setReference(new CrossNodeReference(pair.getValue().getValue(), copyOrigin));
                this.pairs.put(pair.getKey(), new NodePair(key, value));
                continue;
            }
            Node currentNode = currentPair.getValue();
            if (!(currentNode instanceof MappingNode) || !(copyNode instanceof MappingNode)) continue;
            ((MappingNode)currentNode).copyIfDoesntExist((MappingNode)copyNode, copyOrigin, path, ignore);
        }
    }

    public void insertAfter(String key, NodePair pair, BiPredicate<String, NodePair> afterNode) {
        ArrayList<Map.Entry<String, NodePair>> after = null;
        if (afterNode != null) {
            Iterator<Map.Entry<String, NodePair>> iter = this.pairs.entrySet().iterator();
            int beforeSize = 0;
            while (iter.hasNext()) {
                Map.Entry<String, NodePair> next = iter.next();
                ++beforeSize;
                if (!afterNode.test(next.getKey(), next.getValue())) continue;
                after = new ArrayList(this.pairs.size() - beforeSize);
                break;
            }
            while (iter.hasNext()) {
                after.add(iter.next());
                iter.remove();
            }
        } else {
            after = new ArrayList<Map.Entry<String, NodePair>>(this.pairs.entrySet());
            this.pairs.clear();
        }
        this.pairs.put(key, pair);
        after.forEach(x -> this.pairs.put((String)x.getKey(), (NodePair)x.getValue()));
    }

    public LinkedHashMap<String, NodePair> getPairs() {
        return this.pairs;
    }

    @Override
    public Collection<NodePair> getValue() {
        return this.pairs.values();
    }

    public void setValue(LinkedHashMap<String, NodePair> pairs) {
        this.pairs = pairs;
    }

    @Override
    public MappingNode clone() {
        LinkedHashMap<String, NodePair> nodes = new LinkedHashMap<String, NodePair>(this.pairs.size());
        for (Map.Entry<String, NodePair> pair : this.pairs.entrySet()) {
            nodes.put(pair.getKey(), new NodePair(pair.getValue().getKey().clone(), pair.getValue().getValue().clone()));
        }
        MappingNode node = new MappingNode(this.getTag(), nodes, this.getFlowStyle(), this.getStartMark(), this.getEndMark());
        node.copyPropertiesOf(this);
        node.merged = this.merged;
        return node;
    }

    static StringBuilder repeatSpaces(int count) {
        StringBuilder buffer = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            buffer.append(' ');
        }
        return buffer;
    }

    static void toString(Collection<NodePair> vals, StringBuilder buf, int level) {
        for (NodePair pair : vals) {
            buf.append((CharSequence)MappingNode.repeatSpaces(level * 2));
            buf.append('\"').append(pair.getKey()).append('\"');
            buf.append(" => ");
            if (pair.getValue() instanceof MappingNode) {
                buf.append('\n');
                MappingNode.toString(((MappingNode)pair.getValue()).getValue(), buf, level + 1);
            } else {
                buf.append(pair.getValue());
            }
            buf.append('\n');
        }
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Collection<NodePair> vals = this.getValue();
        if (!vals.isEmpty()) {
            buf.append('\n');
            MappingNode.toString(vals, buf, 1);
            buf.append('\n');
        }
        return '<' + this.getClass().getSimpleName() + " (tag=" + this.getTag() + ", values(" + vals.size() + ")={" + buf + '}' + this.getReferenceString() + ", comments=" + this.getComments() + ")>";
    }
}

