/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.libs.snakeyaml.events;

import java.util.Objects;
import java.util.Optional;
import org.kingdoms.libs.snakeyaml.common.Anchor;
import org.kingdoms.libs.snakeyaml.common.FlowStyle;
import org.kingdoms.libs.snakeyaml.events.NodeEvent;
import org.kingdoms.libs.snakeyaml.markers.Mark;

public abstract class CollectionStartEvent
extends NodeEvent {
    private final Optional<String> tag;
    private final FlowStyle flowStyle;

    public CollectionStartEvent(Optional<Anchor> anchor, Optional<String> tag, FlowStyle flowStyle, Mark startMark, Mark endMark) {
        super(anchor, startMark, endMark);
        Objects.requireNonNull(tag);
        this.tag = tag;
        Objects.requireNonNull(flowStyle);
        this.flowStyle = flowStyle;
    }

    public Optional<String> getTag() {
        return this.tag;
    }

    public FlowStyle getFlowStyle() {
        return this.flowStyle;
    }

    public boolean isFlow() {
        return FlowStyle.FLOW == this.flowStyle;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.getAnchor().ifPresent(a -> builder.append(" &").append(a.getIdentifier()));
        return builder.toString();
    }
}

