/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.libs.snakeyaml.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kingdoms.libs.snakeyaml.api.LoadSettings;
import org.kingdoms.libs.snakeyaml.comments.CommentEventsCollector;
import org.kingdoms.libs.snakeyaml.comments.CommentLine;
import org.kingdoms.libs.snakeyaml.comments.CommentType;
import org.kingdoms.libs.snakeyaml.common.Anchor;
import org.kingdoms.libs.snakeyaml.common.FlowStyle;
import org.kingdoms.libs.snakeyaml.common.NodeReplacer;
import org.kingdoms.libs.snakeyaml.common.reference.AnciasNodeReference;
import org.kingdoms.libs.snakeyaml.constructor.StandardConstructor;
import org.kingdoms.libs.snakeyaml.events.AliasEvent;
import org.kingdoms.libs.snakeyaml.events.Event;
import org.kingdoms.libs.snakeyaml.events.MappingStartEvent;
import org.kingdoms.libs.snakeyaml.events.NodeEvent;
import org.kingdoms.libs.snakeyaml.events.ScalarEvent;
import org.kingdoms.libs.snakeyaml.events.SequenceStartEvent;
import org.kingdoms.libs.snakeyaml.exceptions.ComposerException;
import org.kingdoms.libs.snakeyaml.markers.Mark;
import org.kingdoms.libs.snakeyaml.nodes.AliasNode;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.snakeyaml.nodes.NodePair;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.libs.snakeyaml.nodes.SequenceNode;
import org.kingdoms.libs.snakeyaml.nodes.Tag;
import org.kingdoms.libs.snakeyaml.parser.Parser;
import org.kingdoms.libs.snakeyaml.resolver.ResolverContext;
import org.kingdoms.libs.snakeyaml.resolver.ScalarResolver;

public class Composer {
    protected final Parser parser;
    private final ScalarResolver scalarResolver;
    private int nonScalarAliasesCount = 0;
    private final LinkedHashMap<String, Anchor> anchors = new LinkedHashMap();
    private final LoadSettings settings;
    private final CommentEventsCollector blockCommentsCollector;
    private final CommentEventsCollector inlineCommentsCollector;

    public Composer(LoadSettings settings, Parser parser) {
        this.parser = parser;
        this.scalarResolver = settings.getScalarResolver();
        this.settings = settings;
        this.blockCommentsCollector = new CommentEventsCollector(parser, CommentType.BLANK_LINE, CommentType.BLOCK_BEFORE);
        this.inlineCommentsCollector = new CommentEventsCollector(parser, CommentType.IN_LINE);
    }

    public LinkedHashMap<String, Anchor> getAnchors() {
        return this.anchors;
    }

    public static void collectAnchors(Node node, LinkedHashMap<String, Anchor> anchors) {
        AnciasNodeReference ref = (AnciasNodeReference)node.getReference();
        if (ref != null && ref.getType() == AnciasNodeReference.Type.ANCHOR) {
            anchors.computeIfAbsent(ref.getReference().getIdentifier(), k -> ref.getReference());
        }
        switch (node.getNodeType()) {
            case MAPPING: {
                for (NodePair pair : ((MappingNode)node).getValue()) {
                    Composer.collectAnchors(pair.getValue(), anchors);
                }
                break;
            }
            case SEQUENCE: {
                for (Node element : ((SequenceNode)node).getValue()) {
                    Composer.collectAnchors(element, anchors);
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Node resolveAliases(Node node, LoadSettings loadSettings, LinkedHashMap<String, Anchor> anchors) {
        switch (node.getNodeType()) {
            case ALIAS: {
                void var6_18;
                AliasNode alias = (AliasNode)node;
                String anchorName = alias.getReference().getReference().getIdentifier();
                Anchor anchor = anchors.get(anchorName);
                if (anchor == null) {
                    throw new ComposerException("found undefined alias " + anchorName, alias.getStartMark());
                }
                Node node3 = anchor.getReference();
                node3 = node3.clone();
                node3.setReference(new AnciasNodeReference(AnciasNodeReference.Type.ALIAS, anchor));
                if (anchor.getIdentifier().startsWith("fn-") && node3 instanceof MappingNode) {
                    MappingNode map = (MappingNode)node3;
                    SequenceNode params = (SequenceNode)map.getNode("args");
                    Map<String, Node> parsedParams = Composer.getFunctionParameters(params, alias.getParameters(), loadSettings);
                    Node node5 = Objects.requireNonNull(map.getNode("return"), "Cannot find return value for function").clone();
                    node5 = new NodeReplacer(node5, parsedParams, null).replaceAll().getFinalNode();
                }
                return var6_18;
            }
            case MAPPING: {
                MappingNode mapping = (MappingNode)node;
                Node fnNode = mapping.getNode("[fn]");
                if (fnNode instanceof AliasNode) {
                    AliasNode alias = (AliasNode)fnNode;
                    String string = alias.getReference().getReference().getIdentifier();
                    Anchor anchor = anchors.get(string);
                    if (anchor == null) {
                        throw new ComposerException("found undefined alias " + string, alias.getStartMark());
                    }
                    Node ref = anchor.getReference();
                    ref = ref.clone();
                    ref.setReference(new AnciasNodeReference(AnciasNodeReference.Type.ALIAS, anchor));
                    if (anchor.getIdentifier().startsWith("fn-") && ref instanceof MappingNode) {
                        MappingNode map = (MappingNode)ref;
                        SequenceNode params = (SequenceNode)map.getNode("args");
                        Map<String, Node> parsedParams = Composer.getFunctionParameters(params, mapping, loadSettings);
                        ref = Objects.requireNonNull(map.getNode("return"), "Cannot find return value for function").clone();
                        ref = new NodeReplacer(ref, parsedParams, null).replaceAll().getFinalNode();
                    }
                    return ref;
                }
                ArrayList<Map.Entry<String, NodePair>> cloned = new ArrayList<Map.Entry<String, NodePair>>(mapping.getPairs().entrySet());
                for (Map.Entry entry : cloned) {
                    Node result = Composer.resolveAliases(((NodePair)entry.getValue()).getValue(), loadSettings, anchors);
                    if (result == null) continue;
                    mapping.put(((NodePair)entry.getValue()).getKey(), result);
                }
                return null;
            }
            case SEQUENCE: {
                SequenceNode seq = (SequenceNode)node;
                ArrayList<Node> newValues = new ArrayList<Node>(seq.getValue().size());
                boolean changed = false;
                for (Node element : seq.getValue()) {
                    Node result = Composer.resolveAliases(element, loadSettings, anchors);
                    if (result != null) {
                        newValues.add(result);
                        changed = true;
                        continue;
                    }
                    newValues.add(element);
                }
                if (changed) {
                    seq.setValue(newValues);
                }
                return null;
            }
            case SCALAR: {
                NodeReplacer ref = new NodeReplacer(node, null, anchors).allowRootReplacement(true).replaceAll();
                if (ref.isChanged()) {
                    return ref.getNewNode();
                }
                return null;
            }
        }
        return null;
    }

    public MappingNode getRoot() {
        Optional<Object> document = Optional.empty();
        if (!this.parser.checkEvent(Event.ID.DocumentEnd)) {
            document = Optional.of(this.next());
        }
        if (!this.parser.checkEvent(Event.ID.DocumentEnd)) {
            Event event = this.parser.next();
            Mark previousDocMark = document.map(Node::getStartMark).orElse(null);
            throw new ComposerException("expected a single document in the stream", previousDocMark, "but found another document", event.getStartMark());
        }
        this.parser.next();
        Node rootNode = document.orElseGet(MappingNode::new);
        if (!(rootNode instanceof MappingNode)) {
            throw new IllegalStateException("Root of file only contains a non-map value: " + rootNode.getWholeMark());
        }
        if (this.settings.shouldResolveAliases()) {
            Composer.collectAnchors(rootNode, this.anchors);
            Node resolved = Composer.resolveAliases(rootNode, this.settings, this.anchors);
            if (resolved != null) {
                rootNode = resolved;
            }
        }
        return (MappingNode)rootNode;
    }

    public Node next() {
        this.blockCommentsCollector.collectEvents();
        if (this.parser.checkEvent(Event.ID.DocumentEnd)) {
            List<CommentLine> commentLines = this.blockCommentsCollector.consume();
            Mark startMark = commentLines.get(0).getStartMark();
            LinkedHashMap<String, NodePair> children = new LinkedHashMap<String, NodePair>();
            MappingNode node = new MappingNode(Tag.MAP, children, FlowStyle.BLOCK, startMark, null);
            node.setComments(CommentType.BLOCK_BEFORE, commentLines);
            return node;
        }
        Node node = this.composeNode(Optional.empty());
        this.blockCommentsCollector.collectEvents();
        this.parser.next();
        this.nonScalarAliasesCount = 0;
        return node;
    }

    private Node composeNode(Optional<Node> parent) {
        this.blockCommentsCollector.collectEvents();
        if (this.parser.checkEvent(Event.ID.Alias)) {
            AliasEvent event = (AliasEvent)this.parser.next();
            SequenceNode parameters = null;
            if (this.parser.checkEvent(Event.ID.SequenceStart)) {
                parameters = this.composeSequenceNode(Optional.empty());
            }
            List<CommentLine> blockComments = this.blockCommentsCollector.consume();
            List<CommentLine> inlineComments = this.inlineCommentsCollector.collectEvents().consume();
            AliasNode node = new AliasNode(new Anchor(event.getAnchor().get().getIdentifier(), null), parameters, event.getStartMark(), event.getEndMark());
            node.getComments().addAll(blockComments);
            node.getComments().addAll(inlineComments);
            return node;
        }
        NodeEvent event = (NodeEvent)this.parser.peekEvent();
        Optional<Anchor> anchor = event.getAnchor();
        Node node = this.parser.checkEvent(Event.ID.Scalar) ? this.composeScalarNode(anchor, this.blockCommentsCollector.consume()) : (this.parser.checkEvent(Event.ID.SequenceStart) ? this.composeSequenceNode(anchor) : this.composeMappingNode(anchor));
        return node;
    }

    private static Map<String, Node> getFunctionParameters(SequenceNode signature, MappingNode values, LoadSettings settings) {
        HashMap<String, Node> parsedParams = new HashMap<String, Node>();
        Set sig = signature.getValue().stream().map(x -> (ScalarNode)x).map(ScalarNode::getValue).collect(Collectors.toSet());
        StandardConstructor ctor = new StandardConstructor(settings);
        for (Map.Entry<String, NodePair> entry : values.getPairs().entrySet()) {
            String name = entry.getKey();
            if (name.equals("[fn]")) continue;
            if (!sig.contains(name)) {
                NodePair fnName = values.getPairs().get("[fn]");
                throw new IllegalArgumentException("YAML function '" + (fnName == null ? null : fnName.getValue()) + "' doesn't have a parameter named '" + name + "' (parameters: " + sig + ')');
            }
            Node real = entry.getValue().getValue();
            ctor.constructObject(real);
            parsedParams.put(name, real);
        }
        return parsedParams;
    }

    private static Map<String, Node> getFunctionParameters(SequenceNode signature, SequenceNode values, LoadSettings settings) {
        HashMap<String, Node> parsedParams = new HashMap<String, Node>();
        Collection sig = signature.getValue();
        int index = 0;
        StandardConstructor ctor = new StandardConstructor(settings);
        for (int i = 0; i < sig.size(); ++i) {
            String name = ((ScalarNode)sig.get(index)).getValue();
            Node real = (Node)values.getValue().get(index);
            ctor.constructObject(real);
            parsedParams.put(name, real);
            ++index;
        }
        return parsedParams;
    }

    private void registerAnchor(Anchor anchor, Node node) {
        this.anchors.put(anchor.getIdentifier(), anchor);
        node.setReference(new AnciasNodeReference(AnciasNodeReference.Type.ANCHOR, anchor));
        anchor.setReference(node);
    }

    protected Node composeScalarNode(Optional<Anchor> anchor, List<CommentLine> blockComments) {
        ScalarEvent ev = (ScalarEvent)this.parser.next();
        Tag nodeTag = this.scalarResolver.resolve(new ResolverContext(ev.getValue(), ev.getScalarStyle()));
        ScalarNode node = new ScalarNode(nodeTag, ev.getValue(), ev.getScalarStyle(), ev.getStartMark(), ev.getEndMark());
        anchor.ifPresent(a -> this.registerAnchor((Anchor)a, node));
        node.setComments(CommentType.BLOCK_BEFORE, blockComments);
        node.setComments(CommentType.IN_LINE, this.inlineCommentsCollector.collectEvents().consume());
        return node;
    }

    protected SequenceNode composeSequenceNode(Optional<Anchor> anchor) {
        SequenceStartEvent startEvent = (SequenceStartEvent)this.parser.next();
        ArrayList<Node> children = new ArrayList<Node>();
        SequenceNode node = new SequenceNode(Tag.SEQ, children, startEvent.getFlowStyle(), startEvent.getStartMark(), null);
        if (startEvent.isFlow()) {
            node.setComments(CommentType.BLOCK_BEFORE, this.blockCommentsCollector.consume());
        }
        anchor.ifPresent(a -> this.registerAnchor((Anchor)a, node));
        while (!this.parser.checkEvent(Event.ID.SequenceEnd)) {
            this.blockCommentsCollector.collectEvents();
            if (this.parser.checkEvent(Event.ID.SequenceEnd)) break;
            children.add(this.composeNode(Optional.of(node)));
        }
        if (startEvent.isFlow()) {
            node.setComments(CommentType.IN_LINE, this.inlineCommentsCollector.collectEvents().consume());
        }
        Event endEvent = this.parser.next();
        node.setEndMark(endEvent.getEndMark());
        this.inlineCommentsCollector.collectEvents();
        if (!this.inlineCommentsCollector.isEmpty()) {
            node.setComments(CommentType.IN_LINE, this.inlineCommentsCollector.consume());
        }
        return node;
    }

    protected Node composeMappingNode(Optional<Anchor> anchor) {
        MappingStartEvent startEvent = (MappingStartEvent)this.parser.next();
        LinkedHashMap<String, NodePair> children = new LinkedHashMap<String, NodePair>();
        MappingNode node = new MappingNode(Tag.MAP, children, startEvent.getFlowStyle(), startEvent.getStartMark(), null);
        node.setAnchors(this.anchors);
        if (startEvent.isFlow()) {
            node.setComments(CommentType.BLOCK_BEFORE, this.blockCommentsCollector.consume());
        }
        anchor.ifPresent(a -> this.registerAnchor((Anchor)a, node));
        while (!this.parser.checkEvent(Event.ID.MappingEnd)) {
            this.blockCommentsCollector.collectEvents();
            if (this.parser.checkEvent(Event.ID.MappingEnd)) break;
            this.composeMappingChildren(children, node);
        }
        if (startEvent.isFlow()) {
            node.setComments(CommentType.IN_LINE, this.inlineCommentsCollector.collectEvents().consume());
        }
        Event endEvent = this.parser.next();
        node.setEndMark(endEvent.getEndMark());
        this.inlineCommentsCollector.collectEvents();
        if (!this.inlineCommentsCollector.isEmpty()) {
            node.setComments(CommentType.IN_LINE, this.inlineCommentsCollector.consume());
        }
        return node;
    }

    protected void composeMappingChildren(LinkedHashMap<String, NodePair> children, MappingNode node) {
        ScalarNode keyNode = (ScalarNode)this.composeNode(Optional.of(node));
        if (keyNode.getTag().equals(Tag.MERGE)) {
            node.setMerged(true);
        }
        Node valueNode = this.composeNode(Optional.of(node));
        children.put(keyNode.getValue(), new NodePair(keyNode, valueNode));
    }
}

