/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.libs.snakeyaml.common;

import java.util.Objects;
import org.kingdoms.libs.snakeyaml.exceptions.EmitterException;
import org.kingdoms.libs.snakeyaml.exceptions.ScannerException;
import org.kingdoms.libs.snakeyaml.markers.Mark;
import org.kingdoms.libs.snakeyaml.nodes.Node;

public class Anchor {
    private final String identifier;
    private Node reference;

    public Anchor(String id, Mark startMark) {
        Objects.requireNonNull(id);
        if (id.isEmpty()) {
            throw new IllegalArgumentException("Empty anchor");
        }
        for (int i = 0; i < id.length(); ++i) {
            char ch = id.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-') continue;
            String problem = "Invalid character '" + ch + "' in the anchor: " + id;
            if (startMark == null) {
                throw new EmitterException(problem);
            }
            throw new ScannerException(problem, startMark);
        }
        this.identifier = id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setReference(Node reference) {
        this.reference = reference;
    }

    public String toString() {
        return "Anchor(" + this.identifier + " -> " + this.reference + ')';
    }

    public Node getReference() {
        return this.reference;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Anchor)) {
            return false;
        }
        Anchor otherAnchor = (Anchor)obj;
        return this.identifier.equals(otherAnchor.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

