/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.libs.snakeyaml.api;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.kingdoms.libs.snakeyaml.api.DumpSettings;
import org.kingdoms.libs.snakeyaml.api.StreamDataWriter;
import org.kingdoms.libs.snakeyaml.emitter.Emitter;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.snakeyaml.representer.BaseRepresenter;
import org.kingdoms.libs.snakeyaml.representer.StandardRepresenter;
import org.kingdoms.libs.snakeyaml.serializer.NodeSerializer;

public class Dump {
    protected final DumpSettings settings;
    protected final BaseRepresenter representer;

    public Dump(DumpSettings settings) {
        this(settings, new StandardRepresenter(settings));
    }

    public Dump(DumpSettings settings, BaseRepresenter representer) {
        this.settings = Objects.requireNonNull(settings, "DumpSettings cannot be null");
        this.representer = Objects.requireNonNull(representer, "Representer cannot be null");
    }

    public void dumpAll(Iterator<?> instancesIterator, StreamDataWriter streamDataWriter) {
        NodeSerializer serializer = new NodeSerializer(this.settings, new Emitter(this.settings, streamDataWriter));
        while (instancesIterator.hasNext()) {
            Object instance = instancesIterator.next();
            Node node = this.representer.represent(instance);
            serializer.serializeDocument(node);
        }
    }

    public void dump(Object yaml, StreamDataWriter streamDataWriter) {
        Iterator<Object> iter = Collections.singleton(yaml).iterator();
        this.dumpAll(iter, streamDataWriter);
    }

    public String dumpAllToString(Iterator<?> instancesIterator) {
        StreamToStringWriter writer = new StreamToStringWriter();
        this.dumpAll(instancesIterator, writer);
        return writer.toString();
    }

    public String dumpToString(Object yaml) {
        StreamToStringWriter writer = new StreamToStringWriter();
        this.dump(yaml, writer);
        return writer.toString();
    }

    public void dumpNode(Node node, StreamDataWriter streamDataWriter) {
        NodeSerializer serializer = new NodeSerializer(this.settings, new Emitter(this.settings, streamDataWriter));
        serializer.serializeDocument(node);
    }

    public static final class StreamToStringWriter
    extends StringWriter
    implements StreamDataWriter {
        @Override
        public void closeWriter() {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

