/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui.objects;

import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.kingdoms.gui.objects.GUIInteractionType;
import org.kingdoms.gui.objects.GUIOptionBuilder;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.libs.xseries.base.XBase;
import org.kingdoms.libs.xseries.profiles.builder.XSkull;
import org.kingdoms.libs.xseries.profiles.objects.Profileable;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.utils.ItemUtil;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.reflection.Reflect;

public class GUIOptionObject
implements GUIOptionBuilder {
    protected final String name;
    protected final int[] slots;
    protected final XSound.Record sound;
    protected final List<String> commands;
    protected final GUIInteractionType interactionType;
    protected final ItemStack item;
    protected final MessageObject itemName;
    protected final MessageObject[] lore;
    protected final MessageObject message;
    protected final MessageObject skull;
    protected final ConfigSection config;
    private static final boolean JUKEBOX_PLAYABLE = Reflect.classExists("org.bukkit.inventory.meta.components.JukeboxPlayableComponent");

    public GUIOptionObject(String name, int[] slots, XSound.Record sound, List<String> commands, GUIInteractionType interactionType, ItemStack item, MessageObject itemName, MessageObject[] lore, MessageObject message, MessageObject skull, ConfigSection config) {
        this.name = Objects.requireNonNull(name);
        this.slots = Objects.requireNonNull(slots);
        this.sound = sound;
        this.commands = commands;
        this.interactionType = interactionType;
        this.item = Objects.requireNonNull(item);
        this.itemName = itemName;
        this.lore = lore;
        this.message = message;
        this.skull = skull;
        this.config = config;
    }

    public GUIInteractionType getInteractionType() {
        return this.interactionType;
    }

    public ConfigSection getConfig() {
        return this.config;
    }

    @Override
    public GUIOptionObject getOption(PlaceholderProvider contextProvider) {
        return this;
    }

    public int[] getSlots() {
        return this.slots;
    }

    public MessageObject getMessage() {
        return this.message;
    }

    public XSound.Record getSound() {
        return this.sound;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack defineVariables(MessagePlaceholderProvider settings) {
        JukeboxPlayableComponent playable;
        if (this.item.getType() == Material.AIR) {
            return new ItemStack(Material.AIR);
        }
        ItemStack item = this.item.clone();
        ItemMeta meta = item.getItemMeta();
        if (this.itemName != null) {
            meta.setDisplayName(this.itemName.buildPlain(settings));
        }
        if (JUKEBOX_PLAYABLE && XTag.ITEMS_MUSIC_DISCS.isTagged((XBase)XMaterial.matchXMaterial((ItemStack)item)) && (playable = meta.getJukeboxPlayable()) != null) {
            playable.setShowInTooltip(false);
            meta.setJukeboxPlayable(playable);
        }
        if (this.lore != null) {
            ItemUtil.translate(meta, this.lore, settings);
        }
        if (this.skull != null) {
            String skullString = this.skull.buildPlain(settings);
            meta = (ItemMeta)XSkull.of((ItemMeta)meta).profile(Profileable.detect((String)skullString)).apply();
        }
        item.setItemMeta(meta);
        return item;
    }

    public String getName() {
        return this.name;
    }
}

