/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui.objects;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.kingdoms.gui.bedrock.FormBuilderObject;
import org.kingdoms.gui.objects.GUIOptionBuilder;
import org.kingdoms.gui.objects.inventory.GUIInventoryConstructor;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.conditions.ConditionChain;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;

public class GUIObject {
    private final String name;
    private final YamlWithDefaults config;
    private final MessageObject title;
    private final GUIInventoryConstructor inventoryConstructor;
    private final @Unmodifiable Map<String, GUIOptionBuilder> options;
    private final @Unmodifiable List<Integer> interactableSlots;
    private final @Unmodifiable List<String> commands;
    private final FormBuilderObject form;
    private final XSound.Record sound;
    private final ConditionChain<Messenger> openConditions;
    private final boolean disallowCreative;
    private final MessageObject message;

    public GUIObject(String name, YamlWithDefaults config, String errorMessage) {
        this.name = name;
        this.config = config;
        this.message = MessageCompiler.compile(errorMessage);
        this.inventoryConstructor = null;
        this.disallowCreative = false;
        this.sound = null;
        this.commands = null;
        this.interactableSlots = null;
        this.form = null;
        this.openConditions = null;
        this.options = null;
        this.title = null;
    }

    public GUIObject(String name, YamlWithDefaults config, MessageObject title, FormBuilderObject form, GUIInventoryConstructor inventoryConstructor, Map<String, GUIOptionBuilder> options, List<Integer> interactableSlots, List<String> commands, XSound.Record sound, ConditionChain<Messenger> openConditions, boolean disallowCreative, MessageObject message) {
        this.openConditions = openConditions;
        this.name = name;
        this.config = config;
        this.title = title;
        this.form = form;
        this.inventoryConstructor = inventoryConstructor;
        this.options = Collections.unmodifiableMap(options);
        this.interactableSlots = Collections.unmodifiableList(interactableSlots);
        this.commands = Collections.unmodifiableList(commands);
        this.sound = sound;
        this.disallowCreative = disallowCreative;
        this.message = message;
    }

    public boolean isBroken() {
        return this.inventoryConstructor == null;
    }

    public Inventory buildBukkitInventory(Player owner, MessagePlaceholderProvider builder) {
        return this.inventoryConstructor.create((InventoryHolder)owner, this.title.buildPlain(builder));
    }

    public FormBuilder<?, ?, ?> buildBedrockForm(Player owner, MessagePlaceholderProvider builder) {
        return this.form.build(builder);
    }

    public ConditionChain<Messenger> getOpenConditions() {
        return this.openConditions;
    }

    public boolean hasFormBuilder() {
        return this.form != null;
    }

    public FormBuilderObject getForm() {
        return this.form;
    }

    public boolean isCreativeDisallowed() {
        return this.disallowCreative;
    }

    public @Unmodifiable List<String> getCommands() {
        return this.commands;
    }

    public MessageObject getMessage() {
        return this.message;
    }

    public XSound.Record getSound() {
        return this.sound;
    }

    public @Unmodifiable List<Integer> getInteractableSlots() {
        return this.interactableSlots;
    }

    public GUIOptionBuilder getOption(String name) {
        return this.options.get(name);
    }

    public @Unmodifiable Map<String, GUIOptionBuilder> getOptions() {
        return this.options;
    }

    public YamlWithDefaults getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }
}

