/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui.general;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.cache.caffeine.CacheHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u0012\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010%\u001a\u0004\u0018\u00010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0019\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0019\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010#\u00a8\u0006'"}, d2={"Lorg/kingdoms/gui/general/ItemAmountPickerGUI;", "", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/bukkit/inventory/ItemStack;", "itemId", "", "min", "", "max", "useMemory", "", "costFactor", "", "modifier", "Ljava/util/function/Consumer;", "Lorg/kingdoms/gui/InteractiveGUI;", "done", "<init>", "(Lorg/bukkit/entity/Player;Lorg/bukkit/inventory/ItemStack;Ljava/lang/String;IIZDLjava/util/function/Consumer;Ljava/util/function/Consumer;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "getItem", "()Lorg/bukkit/inventory/ItemStack;", "getItemId", "()Ljava/lang/String;", "getMin", "()I", "getMax", "getUseMemory", "()Z", "getCostFactor", "()D", "getModifier", "()Ljava/util/function/Consumer;", "getDone", "process", "Companion", "core"})
public final class ItemAmountPickerGUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Player player;
    @NotNull
    private final ItemStack item;
    @NotNull
    private final String itemId;
    private final int min;
    private final int max;
    private final boolean useMemory;
    private final double costFactor;
    @NotNull
    private final Consumer<InteractiveGUI> modifier;
    @NotNull
    private final Consumer<ItemStack> done;
    @NotNull
    private static final Cache<UUID, Map<String, Integer>> AMOUNT_PICKER_MEM;

    public ItemAmountPickerGUI(@NotNull Player player, @NotNull ItemStack item, @NotNull String itemId, int min, int max, boolean useMemory, double costFactor, @NotNull Consumer<InteractiveGUI> modifier, @NotNull Consumer<ItemStack> done) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter(done, (String)"done");
        this.player = player;
        this.item = item;
        this.itemId = itemId;
        this.min = min;
        this.max = max;
        this.useMemory = useMemory;
        this.costFactor = costFactor;
        this.modifier = modifier;
        this.done = done;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final ItemStack getItem() {
        return this.item;
    }

    @NotNull
    public final String getItemId() {
        return this.itemId;
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public final boolean getUseMemory() {
        return this.useMemory;
    }

    public final double getCostFactor() {
        return this.costFactor;
    }

    @NotNull
    public final Consumer<InteractiveGUI> getModifier() {
        return this.modifier;
    }

    @NotNull
    public final Consumer<ItemStack> getDone() {
        return this.done;
    }

    @Nullable
    public final InteractiveGUI process() {
        Integer remAmount;
        Map remAmountList;
        if (this.useMemory && (remAmountList = (Map)AMOUNT_PICKER_MEM.getIfPresent((Object)this.player.getUniqueId())) != null && (remAmount = (Integer)remAmountList.get(this.itemId)) != null) {
            this.item.setAmount(Math.min(remAmount, this.max));
            this.done.accept(this.item);
            return null;
        }
        InteractiveGUI interactiveGUI = GUIAccessor.prepare(this.player, KingdomsGUI.STRUCTURES_OUTPOST_AMOUNT$PICKER);
        if (interactiveGUI == null) {
            return null;
        }
        InteractiveGUI gui = interactiveGUI;
        gui.getMessageContext().raw("cost", this.costFactor * (double)this.item.getAmount()).raw("min", this.min).raw("max", this.max).raw("cost_factor", this.costFactor);
        Consumer<Integer> setAmount = arg_0 -> ItemAmountPickerGUI.process$lambda$0(this, arg_0);
        gui.getMessageContext().raw("can_increase", this.item.getAmount() < this.max);
        gui.getMessageContext().raw("can_decrease", this.item.getAmount() > this.min);
        gui.option("item").editItem(arg_0 -> ItemAmountPickerGUI.process$lambda$1(this, arg_0)).done();
        gui.option("increase").on(ClickType.LEFT, () -> ItemAmountPickerGUI.process$lambda$2(setAmount, this)).on(ClickType.RIGHT, () -> ItemAmountPickerGUI.process$lambda$3(setAmount, this)).on(ClickType.SHIFT_RIGHT, () -> ItemAmountPickerGUI.process$lambda$4(setAmount, this)).on(ClickType.SHIFT_LEFT, () -> ItemAmountPickerGUI.process$lambda$5(setAmount, this)).done();
        gui.option("decrease").on(ClickType.LEFT, () -> ItemAmountPickerGUI.process$lambda$6(setAmount, this)).on(ClickType.RIGHT, () -> ItemAmountPickerGUI.process$lambda$7(setAmount, this)).on(ClickType.SHIFT_RIGHT, () -> ItemAmountPickerGUI.process$lambda$8(setAmount, this)).on(ClickType.SHIFT_LEFT, () -> ItemAmountPickerGUI.process$lambda$9(setAmount, this)).done();
        gui.option("done").onNormalClicks(() -> ItemAmountPickerGUI.process$lambda$12(this)).done();
        this.modifier.accept(gui);
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    private static final void process$lambda$0(ItemAmountPickerGUI this$0, int amt) {
        this$0.item.setAmount(Math.min(this$0.max, Math.max(this$0.min, amt)));
        this$0.process();
    }

    private static final ItemStack process$lambda$1(ItemAmountPickerGUI this$0, ItemStack it) {
        return this$0.item;
    }

    private static final void process$lambda$2(Consumer $setAmount, ItemAmountPickerGUI this$0) {
        $setAmount.accept(this$0.item.getAmount() + 1);
    }

    private static final void process$lambda$3(Consumer $setAmount, ItemAmountPickerGUI this$0) {
        $setAmount.accept(this$0.item.getAmount() + 10);
    }

    private static final void process$lambda$4(Consumer $setAmount, ItemAmountPickerGUI this$0) {
        $setAmount.accept(this$0.item.getAmount() + 30);
    }

    private static final void process$lambda$5(Consumer $setAmount, ItemAmountPickerGUI this$0) {
        $setAmount.accept(this$0.max);
    }

    private static final void process$lambda$6(Consumer $setAmount, ItemAmountPickerGUI this$0) {
        $setAmount.accept(this$0.item.getAmount() - 1);
    }

    private static final void process$lambda$7(Consumer $setAmount, ItemAmountPickerGUI this$0) {
        $setAmount.accept(this$0.item.getAmount() - 10);
    }

    private static final void process$lambda$8(Consumer $setAmount, ItemAmountPickerGUI this$0) {
        $setAmount.accept(this$0.item.getAmount() - 30);
    }

    private static final void process$lambda$9(Consumer $setAmount, ItemAmountPickerGUI this$0) {
        $setAmount.accept(this$0.min);
    }

    private static final Map process$lambda$12$lambda$10(UUID it) {
        return new HashMap();
    }

    private static final Map process$lambda$12$lambda$11(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final void process$lambda$12(ItemAmountPickerGUI this$0) {
        Object object = AMOUNT_PICKER_MEM.get((Object)this$0.player.getUniqueId(), arg_0 -> ItemAmountPickerGUI.process$lambda$12$lambda$11(ItemAmountPickerGUI::process$lambda$12$lambda$10, arg_0));
        Intrinsics.checkNotNull((Object)object);
        ((Map)object).put(this$0.itemId, this$0.item.getAmount());
        this$0.done.accept(this$0.item);
    }

    static {
        Cache cache = CacheHandler.newBuilder().expireAfterAccess(Duration.ofMinutes(30L)).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        AMOUNT_PICKER_MEM = cache;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R.\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/gui/general/ItemAmountPickerGUI$Companion;", "", "<init>", "()V", "AMOUNT_PICKER_MEM", "Lorg/kingdoms/libs/caffeine/cache/Cache;", "Ljava/util/UUID;", "", "", "", "getAMOUNT_PICKER_MEM$annotations", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getAMOUNT_PICKER_MEM$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

